/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.log;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.nextop.WireValue;
import io.nextop.log.Log;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

public final class LogEntry {
    private static final int S_VERSION = 1;
    private static final String S_KEY_VERSION = "version";
    private static final String S_KEY_TYPE = "type";
    private static final String S_KEY_LEVEL = "level";
    private static final String S_KEY_KEY = "key";
    private static final String S_KEY_VALUE = "value";
    private static final String S_KEY_UNIT = "unit";
    private static final String S_KEY_MESSAGE = "message";
    private static final String S_KEY_THROWABLE = "throwable";
    private static final String S_THROWABLE_KEY_CLASS_NAME = "className";
    private static final String S_THROWABLE_KEY_MESSAGE = "message";
    private static final String S_THROWABLE_KEY_STACK_TRACE = "stackTrace";
    private static final String S_THROWABLE_KEY_CAUSE = "cause";
    private static final String S_TRACE_CLASS_NAME = "className";
    private static final String S_TRACE_FILE_NAME = "fileName";
    private static final String S_TRACE_LINE_NUMBER = "lineNumber";
    private static final String S_TRACE_METHOD_NAME = "methodName";
    public final Type type;
    public final Level level;
    public final String key;
    public final long value;
    @Nullable
    public final Log.Unit unit;
    @Nullable
    public final String message;
    @Nullable
    public final LogThrowable t;

    public static LogEntry count(Level level, String key, long d) {
        return new LogEntry(Type.COUNT, level, key, d, null, null, null);
    }

    public static LogEntry metric(Level level, String key, long value, Log.Unit unit) {
        return new LogEntry(Type.METRIC, level, key, value, unit, null, null);
    }

    public static LogEntry message(Level level, String key, @Nullable String message) {
        return new LogEntry(Type.MESSAGE, level, key, 0L, null, message, null);
    }

    public static LogEntry handled(Level level, String key, Throwable t, @Nullable String message) {
        return new LogEntry(Type.HANDLED, level, key, 0L, null, message, LogThrowable.valueOf(t));
    }

    public static LogEntry unhandled(Level level, String key, Throwable t, @Nullable String message) {
        return new LogEntry(Type.UNHANDLED, level, key, 0L, null, message, LogThrowable.valueOf(t));
    }

    public static WireValue toWireValue(LogEntry entry) {
        HashMap<String, Object> map = new HashMap<String, Object>(32);
        map.put(S_KEY_VERSION, 1);
        map.put(S_KEY_TYPE, entry.type.toString());
        map.put(S_KEY_LEVEL, entry.level.getName());
        map.put(S_KEY_KEY, entry.key);
        switch (entry.type) {
            case COUNT: 
            case METRIC: {
                map.put(S_KEY_VALUE, entry.value);
                break;
            }
        }
        switch (entry.type) {
            case METRIC: {
                map.put(S_KEY_UNIT, entry.unit.toString());
                break;
            }
        }
        if (null != entry.message) {
            map.put("message", entry.message);
        }
        if (null != entry.t) {
            map.put(S_KEY_THROWABLE, LogEntry.throwableToWireValue(entry.t));
        }
        return WireValue.of(map);
    }

    public static LogEntry fromWireValue(WireValue value) {
        Map<WireValue, WireValue> map = value.asMap();
        int version = map.get(S_KEY_VERSION).asInt();
        switch (version) {
            default: {
                if (version >= 1) break;
                throw new IllegalArgumentException();
            }
            case 1: 
        }
        Type type = Type.valueOf(map.get(S_KEY_TYPE).asString());
        Level level = Level.parse(map.get(S_KEY_LEVEL).asString());
        String key = map.get(S_KEY_KEY).asString();
        long v = map.containsKey(S_KEY_VALUE) ? map.get(S_KEY_VALUE).asLong() : 0L;
        Log.Unit unit = map.containsKey(S_KEY_UNIT) ? Log.Unit.valueOf(map.get(S_KEY_UNIT).asString()) : null;
        String message = map.containsKey("message") ? map.get("message").asString() : null;
        LogThrowable t = map.containsKey(S_KEY_THROWABLE) ? LogEntry.throwableFromWireValue(map.get(S_KEY_THROWABLE), version) : null;
        return new LogEntry(type, level, key, v, unit, message, t);
    }

    private static WireValue throwableToWireValue(LogThrowable t) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("className", t.className);
        if (null != t.message) {
            map.put("message", t.message);
        }
        map.put(S_THROWABLE_KEY_STACK_TRACE, LogEntry.stackTraceToWireValue(t.stackTrace));
        if (null != t.cause) {
            map.put(S_THROWABLE_KEY_CAUSE, LogEntry.throwableToWireValue(t.cause));
        }
        return WireValue.of(map);
    }

    private static LogThrowable throwableFromWireValue(WireValue value, int version) {
        switch (version) {
            default: {
                if (version >= 1) break;
                throw new IllegalArgumentException();
            }
            case 1: 
        }
        Map<WireValue, WireValue> map = value.asMap();
        String className = map.get("className").asString();
        String message = map.containsKey("message") ? map.get("message").asString() : null;
        ImmutableList stackTrace = ImmutableList.copyOf(LogEntry.stackTraceFromWireValue(map.get(S_THROWABLE_KEY_STACK_TRACE), version));
        LogThrowable cause = map.containsKey(S_THROWABLE_KEY_CAUSE) ? LogEntry.throwableFromWireValue(map.get(S_THROWABLE_KEY_CAUSE), version) : null;
        return new LogThrowable(className, message, (ImmutableList<StackTraceElement>)stackTrace, cause);
    }

    private static WireValue stackTraceToWireValue(List<StackTraceElement> stackTrace) {
        return WireValue.of((Object)Lists.transform(stackTrace, (Function)new Function<StackTraceElement, WireValue>(){

            public WireValue apply(@Nullable StackTraceElement input) {
                return LogEntry.stackTraceElementToWireValue(input);
            }
        }));
    }

    private static WireValue stackTraceElementToWireValue(StackTraceElement stackTraceElement) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("className", stackTraceElement.getClassName());
        map.put(S_TRACE_FILE_NAME, stackTraceElement.getFileName());
        map.put(S_TRACE_LINE_NUMBER, stackTraceElement.getLineNumber());
        map.put(S_TRACE_METHOD_NAME, stackTraceElement.getMethodName());
        return WireValue.of(map);
    }

    private static List<StackTraceElement> stackTraceFromWireValue(WireValue value, final int version) {
        switch (version) {
            default: {
                if (version >= 1) break;
                throw new IllegalArgumentException();
            }
            case 1: 
        }
        return Lists.transform(value.asList(), (Function)new Function<WireValue, StackTraceElement>(){

            public StackTraceElement apply(@Nullable WireValue input) {
                return LogEntry.stackTraceElementFromWireValue(input, version);
            }
        });
    }

    private static StackTraceElement stackTraceElementFromWireValue(WireValue value, int version) {
        switch (version) {
            default: {
                if (version >= 1) break;
                throw new IllegalArgumentException();
            }
            case 1: 
        }
        Map<WireValue, WireValue> map = value.asMap();
        String className = map.get("className").asString();
        String fileName = map.get(S_TRACE_FILE_NAME).asString();
        int lineNumber = map.get(S_TRACE_LINE_NUMBER).asInt();
        String methodName = map.get(S_TRACE_METHOD_NAME).asString();
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }

    LogEntry(Type type, Level level, String key, long value, @Nullable Log.Unit unit, @Nullable String message, @Nullable LogThrowable t) {
        this.type = type;
        this.level = level;
        this.key = key;
        this.value = value;
        this.unit = unit;
        this.message = message;
        this.t = t;
    }

    public void writeTo(Log log) {
        switch (this.type) {
            case COUNT: {
                log.count(this.level, this.key, this.value, new Object[0]);
                break;
            }
            case METRIC: {
                log.metric(this.level, this.key, this.value, (Object)this.unit, new Object[0]);
                break;
            }
            case MESSAGE: {
                log.message(this.level, this.key, this.message, new Object[0]);
                break;
            }
            case HANDLED: {
                log.handled(this.level, this.key, this.t.toThrowable(), this.message, new Object[0]);
                break;
            }
            case UNHANDLED: {
                log.unhandled(this.level, this.key, this.t.toThrowable(), this.message, new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static final class LogThrowableMissingImplementation
    extends Throwable {
        private final String className;
        private final String message;

        public LogThrowableMissingImplementation(String className, @Nullable String message, @Nullable Throwable cause) {
            super(LogThrowableMissingImplementation.concat(className, message), cause);
            this.className = className;
            this.message = message;
        }

        private static String concat(String className, @Nullable String message) {
            String prefix = String.format("Missing \"%s\"", className);
            if (null != message) {
                return String.format("%s: %s", prefix, message);
            }
            return message;
        }
    }

    public static final class LogThrowable {
        public final String className;
        @Nullable
        public final String message;
        public final ImmutableList<StackTraceElement> stackTrace;
        @Nullable
        public final LogThrowable cause;

        public static LogThrowable valueOf(Throwable t) {
            LogThrowable cause = null != t.getCause() ? LogThrowable.valueOf(t.getCause()) : null;
            return new LogThrowable(t.getClass().getCanonicalName(), t.getMessage(), (ImmutableList<StackTraceElement>)ImmutableList.copyOf((Object[])t.getStackTrace()), cause);
        }

        LogThrowable(String className, @Nullable String message, ImmutableList<StackTraceElement> stackTrace, @Nullable LogThrowable cause) {
            this.className = className;
            this.message = message;
            this.stackTrace = stackTrace;
            this.cause = cause;
        }

        public Throwable toThrowable() {
            Throwable t = this._toThrowable();
            t.setStackTrace((StackTraceElement[])this.stackTrace.toArray((Object[])new StackTraceElement[this.stackTrace.size()]));
            return t;
        }

        private Throwable _toThrowable() {
            Throwable ct = null != this.cause ? this.cause.toThrowable() : null;
            try {
                Class<?> clazz = Class.forName(this.className);
                try {
                    Constructor<?> c = clazz.getConstructor(String.class, Throwable.class);
                    return (Throwable)c.newInstance(this.message, ct);
                }
                catch (NoSuchMethodException e) {
                    if (null == this.message && null == ct) {
                        Constructor<?> c = clazz.getConstructor(new Class[0]);
                        return (Throwable)c.newInstance(new Object[0]);
                    }
                    if (null == this.message) {
                        Constructor<?> c = clazz.getConstructor(Throwable.class);
                        return (Throwable)c.newInstance(ct);
                    }
                    if (null == ct) {
                        Constructor<?> c = clazz.getConstructor(String.class);
                        return (Throwable)c.newInstance(this.message);
                    }
                    return new LogThrowableMissingImplementation(this.className, this.message, ct);
                }
            }
            catch (Exception e) {
                return new LogThrowableMissingImplementation(this.className, this.message, ct);
            }
        }
    }

    public static enum Type {
        COUNT,
        METRIC,
        MESSAGE,
        HANDLED,
        UNHANDLED;

    }
}

