/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.log;

import io.nextop.log.LogEntry;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nullable;
import rx.functions.Func0;

public interface Log {
    public void count(String var1, Object ... var2);

    public void count(String var1, long var2, Object ... var4);

    public void count(Level var1, String var2, long var3, Object ... var5);

    public void metric(String var1, long var2, Object var4, Object ... var5);

    public void metric(Level var1, String var2, long var3, Object var5, Object ... var6);

    public <R> R duration(String var1, Func0<R> var2);

    public <R> R duration(Level var1, String var2, Func0<R> var3);

    public <R> R durationWithException(String var1, Callable<R> var2) throws Exception;

    public <R> R durationWithException(Level var1, String var2, Callable<R> var3) throws Exception;

    public void message(String var1);

    public void message(String var1, @Nullable String var2, Object ... var3);

    public void message(Level var1, String var2, @Nullable String var3, Object ... var4);

    public void handled(String var1, Throwable var2);

    public void handled(Level var1, String var2, Throwable var3);

    public void handled(String var1, Throwable var2, @Nullable String var3, Object ... var4);

    public void handled(Level var1, String var2, Throwable var3, @Nullable String var4, Object ... var5);

    public void unhandled(String var1, Throwable var2);

    public void unhandled(Level var1, String var2, Throwable var3);

    public void unhandled(String var1, Throwable var2, @Nullable String var3, Object ... var4);

    public void unhandled(Level var1, String var2, Throwable var3, @Nullable String var4, Object ... var5);

    public static interface Out {
        public boolean isWrite(Level var1, LogEntry.Type var2);

        public int lineWidth();

        public int keyWidth();

        public int valueWidth();

        public int unitWidth();

        public void write(Level var1, LogEntry.Type var2, String ... var3);

        public boolean isWriteUp(Level var1, LogEntry.Type var2);

        public void writeUp(LogEntry var1);
    }

    public static class Unit {
        private final String name;
        private static final String NAME_NANOSECONDS = "ns";
        private static final String NAME_MICROSECONDS = "us";
        private static final String NAME_MILLISECONDS = "ms";
        private static final String NAME_SECONDS = "s";
        private static final String NAME_MINUTES = "m";
        private static final String NAME_HOURS = "h";
        private static final String NAME_DAYS = "d";

        public static Unit create(String name) {
            try {
                return Unit.timeUnit(name);
            }
            catch (IllegalArgumentException e) {
                return new Unit(name);
            }
        }

        public static Unit valueOf(Object unit) {
            if (unit instanceof Unit) {
                return (Unit)unit;
            }
            if (unit instanceof TimeUnit) {
                return Unit.timeUnit((TimeUnit)((Object)unit));
            }
            return Unit.create(String.valueOf(unit));
        }

        private Unit(String name) {
            this.name = name;
        }

        public long convert(long sourceValue, Unit sourceUnit) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        private static Unit timeUnit(TimeUnit timeUnit) {
            class T
            extends Unit {
                final TimeUnit timeUnit;

                T(TimeUnit timeUnit) {
                    super(Unit.timeUnitToName(timeUnit));
                    this.timeUnit = timeUnit;
                }

                @Override
                public long convert(long sourceValue, Unit sourceUnit) {
                    if (!(sourceUnit instanceof T)) {
                        throw new IllegalArgumentException();
                    }
                    return this.timeUnit.convert(sourceValue, ((T)sourceUnit).timeUnit);
                }
            }
            return new T(timeUnit);
        }

        private static Unit timeUnit(String name) {
            return Unit.timeUnit(Unit.timeUnitFromName(name));
        }

        private static String timeUnitToName(TimeUnit timeUnit) {
            switch (timeUnit) {
                case NANOSECONDS: {
                    return NAME_NANOSECONDS;
                }
                case MICROSECONDS: {
                    return NAME_MICROSECONDS;
                }
                case MILLISECONDS: {
                    return NAME_MILLISECONDS;
                }
                case SECONDS: {
                    return NAME_SECONDS;
                }
                case MINUTES: {
                    return NAME_MINUTES;
                }
                case HOURS: {
                    return NAME_HOURS;
                }
                case DAYS: {
                    return NAME_DAYS;
                }
            }
            throw new IllegalArgumentException();
        }

        private static TimeUnit timeUnitFromName(String name) {
            String n = name.toLowerCase();
            if (NAME_NANOSECONDS.equals(n)) {
                return TimeUnit.NANOSECONDS;
            }
            if (NAME_MICROSECONDS.equals(n)) {
                return TimeUnit.MICROSECONDS;
            }
            if (NAME_MILLISECONDS.equals(n)) {
                return TimeUnit.MILLISECONDS;
            }
            if (NAME_SECONDS.equals(n)) {
                return TimeUnit.SECONDS;
            }
            if (NAME_MINUTES.equals(n)) {
                return TimeUnit.MINUTES;
            }
            if (NAME_HOURS.equals(n)) {
                return TimeUnit.HOURS;
            }
            if (NAME_DAYS.equals(n)) {
                return TimeUnit.DAYS;
            }
            throw new IllegalArgumentException();
        }
    }
}

