/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.log;

import io.nextop.log.Log;
import io.nextop.log.LogEntry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nullable;
import rx.functions.Func0;

public class DefaultLog
implements Log {
    protected final Log.Out out;
    protected final Level defaultLevel = Level.INFO;
    protected final Level defaultHandledLevel = Level.WARNING;
    protected final Level defaultUnhandledLevel = Level.SEVERE;

    public DefaultLog(Log.Out out) {
        this.out = out;
    }

    @Override
    public void count(String keyFormat, Object ... keyArgs) {
        this.count(keyFormat, 1L, keyArgs);
    }

    @Override
    public void count(String keyFormat, long d, Object ... keyArgs) {
        this.count(this.defaultLevel, keyFormat, d, keyArgs);
    }

    @Override
    public void count(Level level, String keyFormat, long d, Object ... keyArgs) {
        if (this.out.isWrite(level, LogEntry.Type.COUNT)) {
            String key = String.format(keyFormat, keyArgs);
            int r = this.out.lineWidth() - (Math.max(key.length(), this.out.keyWidth()) + 1);
            this.out.write(level, LogEntry.Type.COUNT, String.format("%-" + this.out.keyWidth() + "s %" + r + "d", key, d));
        }
    }

    @Override
    public void metric(String keyFormat, long value, Object unit, Object ... keyArgs) {
        this.metric(this.defaultLevel, keyFormat, value, unit, keyArgs);
    }

    @Override
    public void metric(Level level, String keyFormat, long value, Object unit, Object ... keyArgs) {
        if (this.out.isWrite(level, LogEntry.Type.METRIC)) {
            String key = String.format(keyFormat, keyArgs);
            int r = this.out.lineWidth() - (Math.max(key.length(), this.out.keyWidth()) + 1);
            this.out.write(level, LogEntry.Type.METRIC, String.format("%-" + this.out.keyWidth() + "s %" + r + "s", key, String.format("%d %-" + this.out.unitWidth() + "s", value, unit)));
        }
    }

    @Override
    public <R> R duration(String key, Func0<R> eval) {
        return this.duration(this.defaultLevel, key, eval);
    }

    @Override
    public <R> R duration(Level level, String key, Func0<R> eval) {
        long startNanos = System.nanoTime();
        Object r = eval.call();
        this.metric(level, key, System.nanoTime() - startNanos, (Object)TimeUnit.NANOSECONDS, new Object[0]);
        return (R)r;
    }

    @Override
    public <R> R durationWithException(String key, Callable<R> eval) throws Exception {
        return this.durationWithException(key, eval);
    }

    @Override
    public <R> R durationWithException(Level level, String key, Callable<R> eval) throws Exception {
        long startNanos = System.nanoTime();
        R r = eval.call();
        this.metric(level, key, System.nanoTime() - startNanos, (Object)TimeUnit.NANOSECONDS, new Object[0]);
        return r;
    }

    @Override
    public void message(String key) {
        this.message(key, null, new Object[0]);
    }

    @Override
    public void message(String key, @Nullable String messageFormat, Object ... args) {
        this.message(this.defaultLevel, key, messageFormat, args);
    }

    @Override
    public void message(Level level, String key, @Nullable String messageFormat, Object ... args) {
        if (this.out.isWrite(level, LogEntry.Type.MESSAGE)) {
            if (null != messageFormat) {
                this.out.write(level, LogEntry.Type.MESSAGE, String.format("%-" + this.out.keyWidth() + "s %s", key, String.format(messageFormat, args)));
            } else {
                this.out.write(level, LogEntry.Type.MESSAGE, String.format("%-" + this.out.keyWidth() + "s", key));
            }
        }
    }

    @Override
    public void handled(String key, Throwable t) {
        this.handled(this.defaultHandledLevel, key, t);
    }

    @Override
    public void handled(Level level, String key, Throwable t) {
        this.handled(level, key, t);
    }

    @Override
    public void handled(String key, Throwable t, @Nullable String messageFormat, Object ... args) {
        this.handled(key, t, messageFormat, args);
    }

    @Override
    public void handled(Level level, String key, Throwable t, @Nullable String messageFormat, Object ... args) {
        if (this.out.isWrite(level, LogEntry.Type.HANDLED)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            String s = sw.toString();
            String prefix = String.format("%-" + this.out.keyWidth() + "s ", key);
            this.out.write(level, LogEntry.Type.HANDLED, prefix + s.replace("\n", "\n" + prefix));
        }
    }

    @Override
    public void unhandled(String key, Throwable t) {
        this.unhandled(this.defaultUnhandledLevel, key, t);
    }

    @Override
    public void unhandled(Level level, String key, Throwable t) {
        this.unhandled(level, key, t);
    }

    @Override
    public void unhandled(String key, Throwable t, @Nullable String messageFormat, Object ... args) {
        this.unhandled(key, t, messageFormat, args);
    }

    @Override
    public void unhandled(Level level, String key, Throwable t, @Nullable String messageFormat, Object ... args) {
        if (this.out.isWrite(level, LogEntry.Type.UNHANDLED)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            String s = sw.toString();
            String prefix = String.format("%-" + this.out.keyWidth() + "s ", key);
            this.out.write(level, LogEntry.Type.UNHANDLED, prefix + s.replace("\n", "\n" + prefix));
        }
    }
}

