/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.log;

import io.nextop.log.DefaultLog;
import io.nextop.log.Log;
import io.nextop.log.LogEntry;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nullable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public final class AggregatorLog
extends DefaultLog {
    final Scheduler scheduler;
    final Scheduler.Worker worker;
    final int metricReservoirSize = 16;
    final int[] metricPercentiles = new int[]{1, 50, 99};
    final int metricWindowSize = 4;
    final int[] countWindowsMs = new int[]{5000, 60000};
    int summaryIntervalMs = (int)TimeUnit.SECONDS.toMillis(5L);
    int ejectTimeoutMs = (int)TimeUnit.SECONDS.toMillis(180L);
    @Nullable
    Subscription processSubscription = null;
    long mostRecentProcessNanos = Long.MAX_VALUE;
    long nextProcessNanos = Long.MAX_VALUE;
    final Object aggregatorStateMutex = new Object();
    final NavigableSet<Aggregator> orderedAggregators;
    final Map<AggregatorKey, Aggregator> aggregators;
    static final Comparator<Aggregator> C_UPDATE_PRIORITY = new Comparator<Aggregator>(){

        @Override
        public int compare(Aggregator a, Aggregator b) {
            if (a == b) {
                return 0;
            }
            if (a.mostRecentUpdateNanos < b.mostRecentUpdateNanos) {
                return 1;
            }
            if (b.mostRecentUpdateNanos < a.mostRecentUpdateNanos) {
                return -1;
            }
            return a.key.compareTo(b.key);
        }
    };
    private static final Comparator<Sample> C_SAMPLE_VALUE_ASCENDING = new Comparator<Sample>(){

        @Override
        public int compare(Sample a, Sample b) {
            if (a == b) {
                return 0;
            }
            if (a.value < b.value) {
                return -1;
            }
            if (b.value < a.value) {
                return 1;
            }
            if (a.nanos < b.nanos) {
                return -1;
            }
            if (b.nanos < a.nanos) {
                return 1;
            }
            return 0;
        }
    };

    public AggregatorLog(Log.Out out, Scheduler scheduler) {
        super(out);
        this.scheduler = scheduler;
        this.worker = scheduler.createWorker();
        this.orderedAggregators = new TreeSet<Aggregator>(C_UPDATE_PRIORITY);
        this.aggregators = new HashMap<AggregatorKey, Aggregator>(32);
    }

    @Override
    public void count(Level level, String keyFormat, final long d, Object ... keyArgs) {
        if (this.out.isWrite(level, LogEntry.Type.METRIC) || this.out.isWriteUp(level, LogEntry.Type.METRIC)) {
            String key = String.format(keyFormat, keyArgs);
            this.update(level, new AggregatorKey(AggregatorType.COUNT, key), new Action1<Aggregator>(){

                public void call(Aggregator aggregator) {
                    ((Count)aggregator).add(d);
                }
            });
        }
    }

    @Override
    public void metric(Level level, String keyFormat, final long value, Object unit, Object ... keyArgs) {
        if (this.out.isWrite(level, LogEntry.Type.METRIC) || this.out.isWriteUp(level, LogEntry.Type.METRIC)) {
            String key = String.format(keyFormat, keyArgs);
            final Log.Unit u = Log.Unit.valueOf(unit);
            this.update(level, new AggregatorKey(AggregatorType.PERCENTILE, key), new Action1<Aggregator>(){

                public void call(Aggregator aggregator) {
                    ((Percentile)aggregator).add(value, u);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        Object object = this.aggregatorStateMutex;
        synchronized (object) {
            long nanos = System.nanoTime();
            for (Aggregator aggregator : this.orderedAggregators) {
                int k = 2;
                if (TimeUnit.MILLISECONDS.toNanos(k * this.summaryIntervalMs) < nanos - aggregator.mostRecentUpdateNanos) break;
                Aggregator aggregator2 = aggregator;
                synchronized (aggregator2) {
                    if (aggregator.pendingSummary) {
                        aggregator.pendingSummary = false;
                        aggregator.summarize();
                    }
                }
            }
            long maxNonEjectionNanos = nanos + TimeUnit.MILLISECONDS.toNanos(this.ejectTimeoutMs) / 2L;
            Iterator<Aggregator> itr = this.orderedAggregators.descendingIterator();
            while (itr.hasNext()) {
                Aggregator aggregator = itr.next();
                if (TimeUnit.MILLISECONDS.toNanos(this.ejectTimeoutMs) < nanos - aggregator.mostRecentUpdateNanos) {
                    Aggregator aggregator3 = aggregator;
                    synchronized (aggregator3) {
                        aggregator.ejected = true;
                        aggregator.eject();
                    }
                    itr.remove();
                    continue;
                }
                maxNonEjectionNanos = aggregator.mostRecentUpdateNanos;
                break;
            }
            this.mostRecentProcessNanos = nanos;
            if (null != this.processSubscription) {
                this.processSubscription.unsubscribe();
            }
            this.nextProcessNanos = maxNonEjectionNanos;
            this.worker.schedule(new Action0(){

                public void call() {
                    AggregatorLog.this.process();
                }
            }, this.nextProcessNanos - nanos, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Level level, AggregatorKey key, Action1<Aggregator> updater) {
        boolean ejected;
        Aggregator aggregator;
        Object object = this.aggregatorStateMutex;
        synchronized (object) {
            long nanos = System.nanoTime();
            aggregator = this.aggregators.get(key);
            if (null != aggregator) {
                assert (!aggregator.ejected);
                if (aggregator.ejected) {
                    return;
                }
                this.orderedAggregators.remove(aggregator);
                aggregator.mostRecentUpdateNanos = nanos;
                this.orderedAggregators.add(aggregator);
            } else {
                switch (key.type) {
                    case COUNT: {
                        aggregator = new Count(key, nanos);
                        break;
                    }
                    case PERCENTILE: {
                        aggregator = new Percentile(key, nanos);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                this.aggregators.put(key, aggregator);
                this.orderedAggregators.add(aggregator);
            }
            if (nanos + (long)this.summaryIntervalMs < this.nextProcessNanos) {
                if (null != this.processSubscription) {
                    this.processSubscription.unsubscribe();
                }
                this.processSubscription = this.worker.schedule(new Action0(){

                    public void call() {
                        AggregatorLog.this.process();
                    }
                }, (long)this.summaryIntervalMs, TimeUnit.MILLISECONDS);
            }
        }
        Aggregator aggregator2 = aggregator;
        synchronized (aggregator2) {
            ejected = aggregator.ejected;
            if (!ejected) {
                ejected = false;
                aggregator.pendingSummary = true;
                aggregator.level = level;
                updater.call((Object)aggregator);
            }
        }
        if (ejected) {
            this.update(level, key, updater);
        }
    }

    private static void pad(StringBuilder[] lines) {
        int length = 0;
        for (StringBuilder line : lines) {
            int n = line.length();
            if (length >= n) continue;
            length = n;
        }
        AggregatorLog.pad(lines, length);
    }

    private static void pad(StringBuilder[] lines, int length) {
        for (StringBuilder line : lines) {
            for (int d = length - line.length(); 0 < d; --d) {
                line.append(' ');
            }
        }
    }

    private static final class Sample {
        final long value;
        final long nanos;

        Sample(long value, long nanos) {
            this.value = value;
            this.nanos = nanos;
        }
    }

    final class Percentile
    extends Aggregator {
        final Sample[] reservoir;
        final Sample[] mostRecent;
        int count;
        final Sample[] percentiles;
        final Sample[] previousPercentiles;
        @Nullable
        Log.Unit unit;
        final Random r;

        Percentile(AggregatorKey key, long nanos) {
            super(key, nanos);
            this.reservoir = new Sample[16];
            this.mostRecent = new Sample[4];
            this.count = 0;
            this.percentiles = new Sample[AggregatorLog.this.metricPercentiles.length];
            this.previousPercentiles = new Sample[AggregatorLog.this.metricPercentiles.length];
            this.unit = null;
            this.r = new Random();
        }

        synchronized void add(long value, Log.Unit unit) {
            long cvalue;
            if (null == this.unit) {
                this.unit = unit;
                cvalue = value;
            } else {
                cvalue = this.unit.convert(value, unit);
            }
            long nanos = System.nanoTime();
            Sample s = new Sample(cvalue, nanos);
            int i = this.count % this.mostRecent.length;
            this.mostRecent[i] = s;
            i = this.count < this.reservoir.length ? this.count : this.r.nextInt(this.count + 1);
            if (i < this.reservoir.length) {
                this.reservoir[i] = s;
            }
            ++this.count;
        }

        @Override
        synchronized void summarize() {
            this.summarize(this.key.key);
        }

        @Override
        synchronized void eject() {
            this.summarize(String.format("%s.eject", this.key.key));
        }

        private synchronized void summarize(String key) {
            int i;
            if (this.count <= 0) {
                assert (false);
                return;
            }
            int k = Math.min(this.count, this.reservoir.length);
            Arrays.sort(this.reservoir, 0, k, C_SAMPLE_VALUE_ASCENDING);
            int n = AggregatorLog.this.metricPercentiles.length;
            for (i = 0; i < n; ++i) {
                this.previousPercentiles[i] = this.percentiles[i];
                int percentileIndex = (AggregatorLog.this.metricPercentiles[i] * (k - 1) + 50) / 100;
                this.percentiles[i] = this.reservoir[percentileIndex];
            }
            if (AggregatorLog.this.out.isWrite(this.level, LogEntry.Type.METRIC)) {
                long nanos = System.nanoTime();
                StringBuilder[] lines = new StringBuilder[3];
                for (int i2 = 0; i2 < 3; ++i2) {
                    lines[i2] = new StringBuilder(AggregatorLog.this.out.lineWidth());
                }
                String keyPrefix = String.format("%-" + AggregatorLog.this.out.keyWidth() + "s ", key);
                lines[0].append(keyPrefix);
                AggregatorLog.pad(lines);
                String valueFormat = "%-" + AggregatorLog.this.out.valueWidth() + "d";
                String cpValueFormat = String.format("%s/%s ", valueFormat, valueFormat);
                String cValueFormat = String.format("%s ", valueFormat);
                String mrValueFormat = String.format("%s ", valueFormat);
                for (int i3 = 0; i3 < n; ++i3) {
                    Sample ps = this.previousPercentiles[i3];
                    Sample s = this.percentiles[i3];
                    float mins = (float)((nanos - s.nanos) / 1000000L) / 60000.0f;
                    lines[0].append(String.format("p%d ", AggregatorLog.this.metricPercentiles[i3]));
                    if (null != ps) {
                        lines[1].append(String.format(cpValueFormat, s.value, ps.value));
                    } else {
                        lines[1].append(String.format(cValueFormat, s.value));
                    }
                    lines[2].append(String.format("-%.2fm ", Float.valueOf(mins)));
                    AggregatorLog.pad(lines);
                }
                lines[1].append("; [");
                AggregatorLog.pad(lines);
                StringBuilder[] subLines = new StringBuilder[]{lines[1], lines[2]};
                int j = Math.min(this.count, this.mostRecent.length);
                for (int i4 = 0; i4 < j; ++i4) {
                    int index = (this.count - 1 - i4 + this.mostRecent.length) % this.mostRecent.length;
                    Sample s = this.mostRecent[index];
                    float mins = (float)((nanos - s.nanos) / 1000000L) / 60000.0f;
                    lines[1].append(String.format(mrValueFormat, s.value));
                    lines[2].append(String.format("-%.2fm ", Float.valueOf(mins)));
                    AggregatorLog.pad(subLines);
                }
                StringBuilder[] supLines = new StringBuilder[]{lines[0], lines[1]};
                lines[0].append("most recent");
                lines[1].append("] ");
                AggregatorLog.pad(supLines);
                lines[0].append(String.format("/ %-" + AggregatorLog.this.out.valueWidth() + "d", this.count));
                lines[1].append(String.format("%" + AggregatorLog.this.out.unitWidth() + "s", this.unit));
                String[] lineStrings = new String[3];
                for (int i5 = 0; i5 < 3; ++i5) {
                    lineStrings[i5] = lines[i5].toString();
                }
                AggregatorLog.this.out.write(this.level, LogEntry.Type.METRIC, lineStrings);
            }
            if (AggregatorLog.this.out.isWriteUp(this.level, LogEntry.Type.METRIC)) {
                for (i = 0; i < n; ++i) {
                    String pkey = String.format("%s.p%d", key, AggregatorLog.this.metricPercentiles[i]);
                    long pvalue = this.percentiles[i].value;
                    AggregatorLog.this.out.writeUp(LogEntry.metric(this.level, pkey, pvalue, this.unit));
                }
            }
        }
    }

    class Count
    extends Aggregator {
        final long[] windows;
        final long[] windowStartNanos;
        final long[] previousWindows;
        long total;
        long startNanos;
        int count;

        Count(AggregatorKey key, long nanos) {
            super(key, nanos);
            this.windows = new long[AggregatorLog.this.countWindowsMs.length];
            this.windowStartNanos = new long[AggregatorLog.this.countWindowsMs.length];
            this.previousWindows = new long[AggregatorLog.this.countWindowsMs.length];
            this.total = 0L;
            this.startNanos = 0L;
            this.count = 0;
        }

        synchronized void add(long d) {
            long nanos = System.nanoTime();
            this.rotateWindows(nanos);
            int i = 0;
            int n = AggregatorLog.this.countWindowsMs.length;
            while (i < n) {
                int n2 = i++;
                this.windows[n2] = this.windows[n2] + d;
            }
            this.total += d;
            if (0 == this.count) {
                this.startNanos = nanos;
            }
            ++this.count;
        }

        @Override
        void summarize() {
            this.summarize(this.key.key);
        }

        @Override
        void eject() {
            this.summarize(String.format("%s.eject", this.key.key));
        }

        private void rotateWindows(long nanos) {
            int n = AggregatorLog.this.countWindowsMs.length;
            for (int i = 0; i < n; ++i) {
                if (TimeUnit.MILLISECONDS.toNanos(AggregatorLog.this.countWindowsMs[i]) >= nanos - this.windowStartNanos[i]) continue;
                this.previousWindows[i] = this.windows[i];
                this.windows[i] = 0L;
                this.windowStartNanos[i] = nanos;
            }
        }

        private synchronized void summarize(String key) {
            if (this.count <= 0) {
                assert (false);
                return;
            }
            int n = AggregatorLog.this.countWindowsMs.length;
            long nanos = System.nanoTime();
            if (AggregatorLog.this.out.isWrite(this.level, LogEntry.Type.COUNT)) {
                StringBuilder[] lines = new StringBuilder[2];
                for (int i = 0; i < 2; ++i) {
                    lines[i] = new StringBuilder(AggregatorLog.this.out.lineWidth());
                }
                String keyPrefix = String.format("%-" + AggregatorLog.this.out.keyWidth() + "s ", key);
                lines[0].append(keyPrefix);
                AggregatorLog.pad(lines);
                String valueFormat = "%-" + AggregatorLog.this.out.valueWidth() + "d";
                String cpValueFormat = String.format("%s/%s", valueFormat, valueFormat);
                for (int i = 0; i < n; ++i) {
                    long wvalue = this.windows[i];
                    long pwvalue = this.previousWindows[i];
                    long wnanos = this.windowStartNanos[i];
                    float mins = (float)((nanos - wnanos) / 1000000L) / 60000.0f;
                    lines[0].append(String.format("-%.2fm ", Float.valueOf(mins)));
                    lines[1].append(String.format(cpValueFormat, wvalue, pwvalue));
                    AggregatorLog.pad(lines);
                }
                lines[1].append("; ");
                AggregatorLog.pad(lines);
                float mins = (float)((nanos - this.startNanos) / 1000000L) / 60000.0f;
                lines[0].append(String.format("-%.2fm ", Float.valueOf(mins)));
                lines[1].append(String.format(valueFormat, this.total));
                String[] lineStrings = new String[2];
                for (int i = 0; i < 2; ++i) {
                    lineStrings[i] = lines[i].toString();
                }
                AggregatorLog.this.out.write(this.level, LogEntry.Type.COUNT, lineStrings);
            }
            if (AggregatorLog.this.out.isWriteUp(this.level, LogEntry.Type.COUNT)) {
                AggregatorLog.this.out.writeUp(LogEntry.count(this.level, key, this.total));
                for (int i = 0; i < n; ++i) {
                    String wkey = String.format("%s.w%d", key, AggregatorLog.this.countWindowsMs[i]);
                    long wvalue = this.windows[i];
                    AggregatorLog.this.out.writeUp(LogEntry.count(this.level, wkey, wvalue));
                }
            }
            this.rotateWindows(nanos);
        }
    }

    abstract class Aggregator {
        final AggregatorKey key;
        boolean pendingSummary = false;
        boolean ejected = false;
        Level level = Level.INFO;
        long mostRecentUpdateNanos;

        Aggregator(AggregatorKey key, long nanos) {
            this.key = key;
            this.mostRecentUpdateNanos = nanos;
        }

        abstract void summarize();

        abstract void eject();
    }

    static final class AggregatorKey
    implements Comparable<AggregatorKey> {
        final AggregatorType type;
        final String key;

        AggregatorKey(AggregatorType type, String key) {
            this.type = type;
            this.key = key;
        }

        public int hashCode() {
            int c = this.type.hashCode();
            c = 31 * c + this.key.hashCode();
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AggregatorKey)) {
                return false;
            }
            AggregatorKey b = (AggregatorKey)o;
            return this.type.equals((Object)b.type) && this.key.equals(b.key);
        }

        @Override
        public int compareTo(AggregatorKey b) {
            int d = this.type.compareTo(b.type);
            if (0 != d) {
                return d;
            }
            d = this.key.compareTo(b.key);
            return d;
        }
    }

    static enum AggregatorType {
        COUNT,
        PERCENTILE;

    }
}

