/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client.node.nextop;

import io.nextop.Authority;
import io.nextop.Id;
import io.nextop.Message;
import io.nextop.Route;
import io.nextop.Wire;
import io.nextop.WireValue;
import io.nextop.Wires;
import io.nextop.client.MessageControl;
import io.nextop.client.MessageControlNode;
import io.nextop.client.MessageControlState;
import io.nextop.client.node.AbstractMessageControlNode;
import io.nextop.client.node.Head;
import io.nextop.client.node.http.HttpNode;
import io.nextop.client.retry.SendStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.SocketFactory;

public class NextopClientWireFactory
extends AbstractMessageControlNode
implements Wire.Factory {
    static final Config DEFAULT_CONFIG = new Config(Authority.valueOf("dns.nextop.io"), 2);
    static final SendStrategy DEFAULT_DNS_SEND_STRATEGY;
    static final SendStrategy FAILSAFE_DNS_SEND_STRATEGY;
    static final SendStrategy DEFAULT_DNS_RETAKE_STRATEGY;
    static final SendStrategy FAILSAFE_DNS_RETAKE_STRATEGY;
    final Config config;
    final SocketFactory socketFactory;
    final byte[] greetingBuffer = new byte[1024];
    HttpNode dnsHttpNode;
    Head dnsHead;
    State state;
    SendStrategy dnsSendStrategy = DEFAULT_DNS_SEND_STRATEGY;
    SendStrategy dnsRetakeStrategy = DEFAULT_DNS_RETAKE_STRATEGY;
    SendStrategy mostRecentDnsSendStrategy = null;
    long mostRecentDnsSendNanos = 0L;
    SendStrategy mostRecentDnsRetakeStrategy = null;
    boolean active = false;
    final Id clientId = Id.create();
    Id accessKey = Id.create();
    Set<Id> grantKeys = Collections.emptySet();

    public NextopClientWireFactory() {
        this(DEFAULT_CONFIG);
    }

    public NextopClientWireFactory(Config config) {
        this.config = config;
        this.socketFactory = SocketFactory.getDefault();
    }

    @Override
    protected void initSelf(MessageControlNode.Bundle savedState) {
        this.state = new State();
        MessageControlState dnsMcs = new MessageControlState(this);
        this.dnsHttpNode = new HttpNode();
        this.dnsHead = Head.create(this, dnsMcs, this.dnsHttpNode, this.getScheduler());
        this.dnsHead.init(savedState);
    }

    @Override
    public void onSaveState(MessageControlNode.Bundle savedState) {
    }

    @Override
    public void onActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            if (active) {
                this.dnsHead.start();
            } else {
                this.dnsHead.stop();
            }
        }
    }

    @Override
    public void onMessageControl(MessageControl mc) {
        assert (false);
    }

    @Override
    public Wire create(@Nullable Wire replace) throws NoSuchElementException {
        if (replace instanceof NextopRemoteWire) {
            this.state.fail(((NextopRemoteWire)replace).authority);
        }
        block4: while (this.active) {
            Authority upAuthority;
            try {
                this.mostRecentDnsRetakeStrategy = this.dnsRetakeStrategy;
                if (null == this.mostRecentDnsSendStrategy) {
                    this.mostRecentDnsSendStrategy = this.dnsSendStrategy;
                }
                while (null == (upAuthority = this.state.getFirstUpAuthority(this.config.allowedFailsPerAuthority))) {
                    if (!this.active) continue block4;
                    this.doDnsSendDelay();
                    if (!this.doDnsReset()) {
                        this.doDnsRetakeDelay();
                    } else {
                        this.mostRecentDnsRetakeStrategy = this.dnsRetakeStrategy;
                    }
                    this.mostRecentDnsSendNanos = System.nanoTime();
                }
            }
            catch (Exception e) {
                continue;
            }
            assert (null != upAuthority);
            try {
                System.out.printf("Connecting to %s\n", upAuthority);
                Socket socket = this.socketFactory.createSocket(Authority.toInetAddress(upAuthority), upAuthority.port);
                long startNanos = System.nanoTime();
                this.writeGreeting(socket.getOutputStream());
                this.readGreetingResponse(socket.getInputStream());
                System.out.printf("Greeting took %.3fms\n", Float.valueOf((float)((System.nanoTime() - startNanos) / 1000L) / 1000.0f));
                Socket tlsSocket = this.startTls(socket);
                this.state.success(upAuthority);
                return Wires.io(tlsSocket);
            }
            catch (Exception e) {
                this.state.fail(upAuthority);
            }
        }
        throw new NoSuchElementException();
    }

    void doDnsSendDelay() throws InterruptedException {
        if (0L < this.mostRecentDnsSendNanos) {
            long elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.mostRecentDnsSendNanos);
            this.mostRecentDnsSendStrategy = this.mostRecentDnsSendStrategy.retry();
            if (!this.mostRecentDnsSendStrategy.isSend()) {
                this.mostRecentDnsSendStrategy = FAILSAFE_DNS_SEND_STRATEGY.retry();
            }
            assert (this.mostRecentDnsSendStrategy.isSend());
            long delayMs = this.mostRecentDnsSendStrategy.getDelay(TimeUnit.MILLISECONDS);
            if (elapsedMs < delayMs) {
                Thread.sleep(delayMs - elapsedMs);
            }
        }
    }

    void doDnsRetakeDelay() throws InterruptedException {
        this.mostRecentDnsRetakeStrategy = this.mostRecentDnsRetakeStrategy.retry();
        if (!this.mostRecentDnsRetakeStrategy.isSend()) {
            this.mostRecentDnsRetakeStrategy = FAILSAFE_DNS_RETAKE_STRATEGY.retry();
        }
        assert (this.mostRecentDnsRetakeStrategy.isSend());
        long delayMs = this.mostRecentDnsSendStrategy.getDelay(TimeUnit.MILLISECONDS);
        if (0L < delayMs) {
            Thread.sleep(delayMs);
        }
    }

    boolean doDnsReset() {
        Message dnsResponse;
        Message dnsRequest;
        if (!this.config.fixedAuthorities.isEmpty()) {
            this.state.resetDnsAuthorities(this.config.fixedAuthorities);
            return true;
        }
        List<Authority> reportDownAuthorities = this.state.getUnreportedDownAuthorities(this.config.allowedFailsPerAuthority);
        if (reportDownAuthorities.isEmpty()) {
            dnsRequest = Message.newBuilder().setRoute(Route.valueOf("GET http://" + this.config.dnsAuthority + "/$access-key/edge.json")).set("access-key", this.accessKey).build();
        } else {
            ArrayList<String> reportDownAuthorityStrings = new ArrayList<String>(reportDownAuthorities.size());
            for (Authority reportDownAuthority : reportDownAuthorities) {
                reportDownAuthorityStrings.add(reportDownAuthority.toString());
            }
            dnsRequest = Message.newBuilder().setRoute(Route.valueOf("POST http://" + this.config.dnsAuthority + "/$access-key/edge.json")).set("access-key", this.accessKey).set("bad-authorities", WireValue.of(reportDownAuthorityStrings)).build();
        }
        try {
            this.dnsHead.send(dnsRequest);
            dnsResponse = (Message)this.dnsHead.receive(dnsRequest.inboxRoute()).toBlocking().single();
        }
        catch (Exception e) {
            this.dnsHead.cancelSend(dnsRequest.id);
            return false;
        }
        if (200 != dnsResponse.getCode()) {
            return false;
        }
        for (Authority reportDownAuthority : reportDownAuthorities) {
            this.state.setReportedDown(reportDownAuthority);
        }
        try {
            WireValue authoritiesValue;
            WireValue contentValue = dnsResponse.getContent();
            if (null != contentValue && null != (authoritiesValue = contentValue.asMap().get(WireValue.of((Object)"authorities")))) {
                List<WireValue> dnsAuthorityValues = authoritiesValue.asList();
                ArrayList<Authority> dnsAuthorities = new ArrayList<Authority>(dnsAuthorityValues.size());
                for (WireValue dnsAuthorityValue : dnsAuthorityValues) {
                    dnsAuthorities.add(Authority.valueOf(dnsAuthorityValue.toString()));
                }
                this.state.resetDnsAuthorities(dnsAuthorities);
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    void writeGreeting(OutputStream os) throws IOException {
        Message greeting = Message.newBuilder().setRoute(Route.create(Route.Target.valueOf("PUT /greeting"), Route.LOCAL)).set("accessKey", this.accessKey).set("grantKeys", WireValue.of(this.grantKeys)).set("clientId", this.clientId).build();
        ByteBuffer bb = ByteBuffer.wrap(this.greetingBuffer, 2, this.greetingBuffer.length - 2);
        WireValue.of((Object)greeting).toBytes(bb);
        bb.flip();
        int length = bb.remaining();
        this.greetingBuffer[0] = (byte)(length >>> 8);
        this.greetingBuffer[1] = (byte)length;
        os.write(this.greetingBuffer, 0, 2 + bb.remaining());
        os.flush();
    }

    void readGreetingResponse(InputStream is) throws IOException {
        int r;
        int r2;
        int i = 0;
        while (0 < (r2 = is.read(this.greetingBuffer, i, 2 - i))) {
            i += r2;
        }
        if (i < 2) {
            throw new IOException();
        }
        int length = (0xFF & this.greetingBuffer[0]) << 8 | 0xFF & this.greetingBuffer[1];
        if (this.greetingBuffer.length < length) {
            throw new IOException("Greeting response too long.");
        }
        i = 0;
        while (0 < (r = is.read(this.greetingBuffer, i, length - i))) {
            i += r;
        }
        if (i < length) {
            throw new IOException();
        }
        WireValue responseValue = WireValue.valueOf(this.greetingBuffer);
        switch (responseValue.getType()) {
            case MESSAGE: {
                this.handleGreetingResponse(responseValue.asMessage());
                break;
            }
            default: {
                throw new IOException("Bad greeting response.");
            }
        }
    }

    void handleGreetingResponse(Message response) {
    }

    Socket startTls(Socket socket) throws IOException {
        return socket;
    }

    static {
        FAILSAFE_DNS_SEND_STRATEGY = DEFAULT_DNS_SEND_STRATEGY = new SendStrategy.Builder().withUniformRandom(2000L, TimeUnit.MILLISECONDS).repeatIndefinitely().build();
        FAILSAFE_DNS_RETAKE_STRATEGY = DEFAULT_DNS_RETAKE_STRATEGY = new SendStrategy.Builder().init(2000L, TimeUnit.MILLISECONDS).withExponentialRandom(1.1f).repeat(50).withUniformRandom(300L, TimeUnit.SECONDS).repeatIndefinitely().build();
    }

    public static final class State
    implements Serializable {
        List<AuthorityState> authorityStates = Collections.emptyList();
        Map<Authority, AuthorityState> allAuthorityStates = new HashMap<Authority, AuthorityState>(8);

        State() {
        }

        @Nullable
        Authority getFirstUpAuthority(int allowedFailsPerAuthority) {
            for (AuthorityState authorityState : this.authorityStates) {
                if (authorityState.isDown(allowedFailsPerAuthority)) continue;
                return authorityState.authority;
            }
            return null;
        }

        List<Authority> getUnreportedDownAuthorities(int allowedFailsPerAuthority) {
            LinkedList<Authority> unreportedDownAuthorities = new LinkedList<Authority>();
            for (AuthorityState authorityState : this.authorityStates) {
                if (!authorityState.isDown(allowedFailsPerAuthority) || authorityState.reportedDown) continue;
                unreportedDownAuthorities.add(authorityState.authority);
            }
            return unreportedDownAuthorities;
        }

        void resetDnsAuthorities(List<Authority> dnsAuthorities) {
            ArrayList<AuthorityState> dnsAuthorityStates = new ArrayList<AuthorityState>(dnsAuthorities.size());
            for (Authority authority : dnsAuthorities) {
                AuthorityState authorityState = this.allAuthorityStates.get(authority);
                if (null == authorityState) {
                    authorityState = new AuthorityState(authority);
                    this.allAuthorityStates.put(authority, authorityState);
                }
                authorityState.addAttempt(AuthorityState.Attempt.create(AuthorityState.Attempt.Type.DNS_RESET));
                dnsAuthorityStates.add(authorityState);
            }
            this.authorityStates = dnsAuthorityStates;
        }

        void success(Authority authority) {
            AuthorityState authorityState = this.allAuthorityStates.get(authority);
            assert (null != authorityState);
            if (null != authorityState) {
                authorityState.addAttempt(AuthorityState.Attempt.create(AuthorityState.Attempt.Type.SUCCESS));
            }
        }

        void fail(Authority authority) {
            AuthorityState authorityState = this.allAuthorityStates.get(authority);
            assert (null != authorityState);
            if (null != authorityState) {
                authorityState.addAttempt(AuthorityState.Attempt.create(AuthorityState.Attempt.Type.FAIL));
            }
        }

        void setReportedDown(Authority authority) {
            AuthorityState authorityState = this.allAuthorityStates.get(authority);
            assert (null != authorityState);
            if (null != authorityState) {
                authorityState.reportedDown = true;
            }
        }

        static final class AuthorityState {
            final Authority authority;
            final Attempt[] attempts = new Attempt[16];
            int attemptNextIndex = 0;
            int attemptCount = 0;
            boolean reportedDown = false;

            AuthorityState(Authority authority) {
                this.authority = authority;
            }

            void addAttempt(Attempt attempt) {
                int n = this.attempts.length;
                if (this.attemptCount < n) {
                    ++this.attemptCount;
                }
                this.attempts[this.attemptNextIndex] = attempt;
                this.attemptNextIndex = (this.attemptNextIndex + 1) % n;
            }

            boolean isMostRecentlyFailed() {
                int n = this.attempts.length;
                int attemptIndex = (this.attemptNextIndex - 1 + n) % n;
                switch (this.attempts[attemptIndex].type) {
                    case FAIL: {
                        return true;
                    }
                }
                return false;
            }

            boolean isDown(int allowedFails) {
                int n = this.attempts.length;
                if (this.attemptCount < allowedFails) {
                    return false;
                }
                block3: for (int i = 0; i < allowedFails; ++i) {
                    int attemptIndex = (this.attemptNextIndex - 1 - i + n) % n;
                    switch (this.attempts[attemptIndex].type) {
                        case FAIL: {
                            continue block3;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                return true;
            }

            static final class Attempt {
                final Type type;
                final long time;

                static Attempt create(Type type) {
                    return new Attempt(type, System.currentTimeMillis());
                }

                Attempt(Type type, long time) {
                    this.type = type;
                    this.time = time;
                }

                static enum Type {
                    SUCCESS,
                    FAIL,
                    DNS_RESET;

                }
            }
        }
    }

    static final class NextopRemoteWire
    implements Wire {
        final Wire impl;
        final Authority authority;

        NextopRemoteWire(Wire impl, Authority authority) {
            this.impl = impl;
            this.authority = authority;
        }

        @Override
        public void close() throws IOException {
            this.impl.close();
        }

        @Override
        public void read(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            this.impl.read(buffer, offset, length, messageBoundary);
        }

        @Override
        public void skip(long n, int messageBoundary) throws IOException {
            this.impl.skip(n, messageBoundary);
        }

        @Override
        public void write(byte[] buffer, int offset, int n, int messageBoundary) throws IOException {
            this.impl.write(buffer, offset, n, messageBoundary);
        }

        @Override
        public void flush() throws IOException {
            this.impl.flush();
        }
    }

    public static final class Config {
        public final Authority dnsAuthority;
        public final int allowedFailsPerAuthority;
        @Nullable
        public List<Authority> fixedAuthorities;

        public Config(Authority dnsAuthority, int allowedFailsPerAuthority) {
            this(dnsAuthority, allowedFailsPerAuthority, Collections.emptyList());
        }

        public Config(Authority dnsAuthority, int allowedFailsPerAuthority, @Nullable List<Authority> fixedAuthorities) {
            this.dnsAuthority = dnsAuthority;
            this.allowedFailsPerAuthority = allowedFailsPerAuthority;
            this.fixedAuthorities = fixedAuthorities;
        }
    }
}

