/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client.node.log;

import io.nextop.Id;
import io.nextop.Message;
import io.nextop.client.node.Head;
import io.nextop.log.Log;
import io.nextop.log.LogEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import rx.Observer;
import rx.Subscription;

public final class RemoteOut
implements Log.Out {
    private final Head head;
    private final Object mutex = new Object();
    private final Map<String, LogState> mostRecentMessages = new HashMap<String, LogState>(32);

    public RemoteOut(Head head) {
        this.head = head;
    }

    @Override
    public boolean isWrite(Level level, LogEntry.Type type) {
        return false;
    }

    @Override
    public int lineWidth() {
        return 90;
    }

    @Override
    public int keyWidth() {
        return 32;
    }

    @Override
    public int valueWidth() {
        return 8;
    }

    @Override
    public int unitWidth() {
        return 6;
    }

    @Override
    public void write(Level level, LogEntry.Type type, String ... lines) {
    }

    @Override
    public boolean isWriteUp(Level level, LogEntry.Type type) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUp(final LogEntry entry) {
        final Message logMessage = Message.newBuilder().setRoute(Message.logRoute()).setContent(LogEntry.toWireValue(entry)).set(Message.H_PASSIVE, 1).set(Message.H_YIELDABLE, true).setGroupId(Message.LOG_GROUP_ID).setGroupPriority(0).build();
        Subscription s = this.head.receive(logMessage.inboxRoute()).subscribe((Observer)new Observer<Message>(){

            public void onNext(Message message) {
            }

            public void onCompleted() {
                this.endSelf();
            }

            public void onError(Throwable e) {
                this.endSelf();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void endSelf() {
                Object object = RemoteOut.this.mutex;
                synchronized (object) {
                    LogState state = (LogState)RemoteOut.this.mostRecentMessages.get(entry.key);
                    if (null != state && logMessage.id.equals(state.id)) {
                        RemoteOut.this.mostRecentMessages.remove(entry.key);
                        state.subscription.unsubscribe();
                    }
                }
            }
        });
        LogState state = new LogState(logMessage.id, s);
        Object object = this.mutex;
        synchronized (object) {
            LogState previousState = this.mostRecentMessages.put(entry.key, state);
            if (null != previousState) {
                previousState.subscription.unsubscribe();
                this.head.cancelSend(previousState.id);
            }
            this.head.send(logMessage);
        }
    }

    private static final class LogState {
        final Id id;
        final Subscription subscription;

        LogState(Id id, Subscription subscription) {
            this.id = id;
            this.subscription = subscription;
        }
    }
}

