/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client.node.http;

import io.nextop.Id;
import io.nextop.Message;
import io.nextop.Route;
import io.nextop.Wire;
import io.nextop.Wires;
import io.nextop.client.MessageControl;
import io.nextop.client.MessageControlChannel;
import io.nextop.client.MessageControlNode;
import io.nextop.client.MessageControlState;
import io.nextop.client.node.AbstractMessageControlNode;
import io.nextop.client.retry.SendStrategy;
import io.nextop.org.apache.http.ConnectionReuseStrategy;
import io.nextop.org.apache.http.HttpClientConnection;
import io.nextop.org.apache.http.HttpEntity;
import io.nextop.org.apache.http.HttpEntityEnclosingRequest;
import io.nextop.org.apache.http.HttpException;
import io.nextop.org.apache.http.HttpHost;
import io.nextop.org.apache.http.HttpRequest;
import io.nextop.org.apache.http.HttpRequestInterceptor;
import io.nextop.org.apache.http.HttpResponse;
import io.nextop.org.apache.http.ProtocolException;
import io.nextop.org.apache.http.client.HttpRequestRetryHandler;
import io.nextop.org.apache.http.client.config.RequestConfig;
import io.nextop.org.apache.http.client.methods.CloseableHttpResponse;
import io.nextop.org.apache.http.client.methods.Configurable;
import io.nextop.org.apache.http.client.methods.HttpExecutionAware;
import io.nextop.org.apache.http.client.methods.HttpRequestWrapper;
import io.nextop.org.apache.http.client.methods.HttpUriRequest;
import io.nextop.org.apache.http.client.protocol.HttpClientContext;
import io.nextop.org.apache.http.client.protocol.RequestClientConnControl;
import io.nextop.org.apache.http.client.utils.URIUtils;
import io.nextop.org.apache.http.concurrent.Cancellable;
import io.nextop.org.apache.http.config.ConnectionConfig;
import io.nextop.org.apache.http.config.MessageConstraints;
import io.nextop.org.apache.http.conn.ConnectionKeepAliveStrategy;
import io.nextop.org.apache.http.conn.ConnectionRequest;
import io.nextop.org.apache.http.conn.HttpClientConnectionManager;
import io.nextop.org.apache.http.conn.HttpConnectionFactory;
import io.nextop.org.apache.http.conn.ManagedHttpClientConnection;
import io.nextop.org.apache.http.conn.routing.HttpRoute;
import io.nextop.org.apache.http.entity.ContentLengthStrategy;
import io.nextop.org.apache.http.impl.DefaultConnectionReuseStrategy;
import io.nextop.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import io.nextop.org.apache.http.impl.conn.ConnectionShutdownException;
import io.nextop.org.apache.http.impl.conn.DefaultHttpResponseParserFactory;
import io.nextop.org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import io.nextop.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import io.nextop.org.apache.http.impl.entity.LaxContentLengthStrategy;
import io.nextop.org.apache.http.impl.entity.StrictContentLengthStrategy;
import io.nextop.org.apache.http.impl.execchain.ClientExecChain;
import io.nextop.org.apache.http.impl.execchain.NextopConnectionHolder;
import io.nextop.org.apache.http.impl.execchain.NextopHttpResponseProxy;
import io.nextop.org.apache.http.impl.execchain.RequestAbortedException;
import io.nextop.org.apache.http.impl.execchain.RetryExec;
import io.nextop.org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import io.nextop.org.apache.http.io.HttpMessageParserFactory;
import io.nextop.org.apache.http.io.HttpMessageWriterFactory;
import io.nextop.org.apache.http.io.SessionInputBuffer;
import io.nextop.org.apache.http.io.SessionOutputBuffer;
import io.nextop.org.apache.http.protocol.BasicHttpContext;
import io.nextop.org.apache.http.protocol.HttpContext;
import io.nextop.org.apache.http.protocol.HttpProcessor;
import io.nextop.org.apache.http.protocol.HttpRequestExecutor;
import io.nextop.org.apache.http.protocol.ImmutableHttpProcessor;
import io.nextop.org.apache.http.protocol.RequestContent;
import io.nextop.org.apache.http.protocol.RequestTargetHost;
import io.nextop.org.apache.http.protocol.RequestUserAgent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import rx.functions.Func1;

public final class HttpNode
extends AbstractMessageControlNode {
    public static final Config DEFAULT_CONFIG = new Config("Nextop", 2);
    public static final SendStrategy DEFAULT_SEND_STRATEGY = new SendStrategy.Builder().init(0L, TimeUnit.MILLISECONDS).repeat(1).build();
    public static final SendStrategy DEFAULT_RETAKE_STRATEGY;
    static final SendStrategy FALLBACK_RETAKE_STRATEGY;
    static final int DEFAULT_YIELD_Q_BYTES = 4096;
    final Config config;
    final PoolingHttpClientConnectionManager clientConnectionManager = new PoolingHttpClientConnectionManager((HttpConnectionFactory)new NextopHttpClientConnectionFactory());
    volatile boolean active = false;
    @Nullable
    List<Thread> looperThreads = null;
    volatile SendStrategy sendStrategy = DEFAULT_SEND_STRATEGY;
    volatile SendStrategy retakeStrategy = DEFAULT_RETAKE_STRATEGY;
    @Nullable
    volatile Wire.Adapter wireAdapter = null;
    static final Func1<MessageControlState.Entry, Boolean> IS_SENDABLE;

    public HttpNode() {
        this(DEFAULT_CONFIG);
    }

    public HttpNode(Config config) {
        this.config = config;
    }

    public void setSendStrategy(SendStrategy sendStrategy) {
        this.sendStrategy = sendStrategy;
    }

    public void setWireAdapter(Wire.Adapter wireAdapter) {
        this.wireAdapter = wireAdapter;
    }

    @Override
    protected void initSelf(@Nullable MessageControlNode.Bundle savedState) {
        this.upstream.onActive(true);
    }

    @Override
    public void onActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            if (active) {
                int i;
                assert (null == this.looperThreads);
                MessageControlState mcs = this.getMessageControlState();
                SharedLooperState sls = new SharedLooperState();
                int n = this.config.maxConcurrentConnections;
                Thread[] threads = new Thread[n];
                for (i = 0; i < n; ++i) {
                    threads[i] = new RequestLooper(mcs, sls);
                }
                this.looperThreads = Arrays.asList(threads);
                for (i = 0; i < n; ++i) {
                    threads[i].start();
                }
            } else {
                assert (null != this.looperThreads);
                for (Thread t : this.looperThreads) {
                    t.interrupt();
                }
                this.looperThreads = null;
            }
        }
    }

    @Override
    public void onMessageControl(MessageControl mc) {
        MessageControlState mcs;
        assert (MessageControl.Direction.SEND.equals((Object)mc.dir));
        assert (this.active);
        if (this.active && !(mcs = this.getMessageControlState()).onActiveMessageControl(mc, this.upstream)) {
            mcs.add(mc);
        }
    }

    static {
        FALLBACK_RETAKE_STRATEGY = DEFAULT_RETAKE_STRATEGY = new SendStrategy.Builder().withUniformRandom(2000L, TimeUnit.MILLISECONDS).repeatIndefinitely().build();
        IS_SENDABLE = new Func1<MessageControlState.Entry, Boolean>(){

            public Boolean call(MessageControlState.Entry entry) {
                return !Message.isLocal(entry.message.route);
            }
        };
    }

    static class NextopHttpRequestExecutor
    extends HttpRequestExecutor {
        ProgressCallback progressCallback;
        int sendTryCount = 0;
        int receiveTryCount = 0;

        NextopHttpRequestExecutor(ProgressCallback progressCallback) {
            this.progressCallback = progressCallback;
        }

        protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
            ++this.sendTryCount;
            if (null != this.progressCallback) {
                this.progressCallback.onSendStarted(this.sendTryCount);
            }
            return super.doSendRequest(request, conn, context);
        }

        protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
            ++this.receiveTryCount;
            if (null != this.progressCallback) {
                this.progressCallback.onReceiveStarted(this.receiveTryCount);
            }
            return super.doReceiveResponse(request, conn, context);
        }
    }

    static final class NextopHttpClientConnection
    extends DefaultManagedHttpClientConnection {
        final int yieldQBytes = 4096;
        private boolean wireSet = false;
        @Nullable
        private Wire wire = null;

        public NextopHttpClientConnection(String id, int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
            super(id, buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        }

        @Nullable
        private ProgressCallback getProgressCallback() {
            RequestLooper t = (RequestLooper)Thread.currentThread();
            return t.progressCallback;
        }

        @Nullable
        private Wire.Adapter getAdapter() {
            RequestLooper t = (RequestLooper)Thread.currentThread();
            return t.wireAdapter;
        }

        private void setWire(Socket socket) throws IOException {
            if (!this.wireSet) {
                this.wireSet = true;
                Wire.Adapter adapter = this.getAdapter();
                if (null != adapter) {
                    InputStream is = super.getSocketInputStream(socket);
                    OutputStream os = super.getSocketOutputStream(socket);
                    try {
                        this.wire = adapter.adapt(Wires.io(is, os));
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            }
        }

        protected InputStream getSocketInputStream(Socket socket) throws IOException {
            this.setWire(socket);
            if (null != this.wire) {
                return Wires.inputStream(this.wire);
            }
            return super.getSocketInputStream(socket);
        }

        protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
            this.setWire(socket);
            if (null != this.wire) {
                return Wires.outputStream(this.wire);
            }
            return super.getSocketOutputStream(socket);
        }

        protected OutputStream createOutputStream(long len, SessionOutputBuffer outbuffer) {
            final ProgressCallback progressCallback = this.getProgressCallback();
            final long sendTotalBytes = 0L < len ? len : 0L;
            final OutputStream os = super.createOutputStream(len, outbuffer);
            return new OutputStream(){
                long sentBytes = 0L;
                long lastNotificationIndex = -1L;

                private long scaledSendTotalBytes(long b) {
                    long t = sendTotalBytes;
                    while (0L < t && t <= b) {
                        long u = 161L * t / 100L;
                        if (t < u) {
                            t = u;
                            continue;
                        }
                        t *= 2L;
                    }
                    return t;
                }

                private void onSendProgress(long bytes) {
                    long notificationIndex;
                    this.sentBytes += bytes;
                    if (null != progressCallback && this.lastNotificationIndex != (notificationIndex = this.sentBytes / 4096L)) {
                        this.lastNotificationIndex = notificationIndex;
                        progressCallback.onSendProgress(this.sentBytes, this.scaledSendTotalBytes(this.sentBytes));
                    }
                }

                private void onSendCompleted() {
                    if (null != progressCallback) {
                        progressCallback.onSendCompleted(this.sentBytes, this.sentBytes);
                    }
                }

                @Override
                public void write(int b) throws IOException {
                    os.write(b);
                    this.onSendProgress(1L);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    for (int i = 0; i < len; i += 4096) {
                        int c = Math.min(4096, len - i);
                        os.write(b, off + i, c);
                        this.onSendProgress(c);
                    }
                }

                @Override
                public void flush() throws IOException {
                    os.flush();
                }

                @Override
                public void close() throws IOException {
                    os.close();
                    this.onSendCompleted();
                }
            };
        }

        public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
            super.sendRequestEntity(request);
        }

        protected InputStream createInputStream(long len, SessionInputBuffer inbuffer) {
            final ProgressCallback progressCallback = this.getProgressCallback();
            final long receiveTotalBytes = 0L < len ? len : 0L;
            final InputStream is = super.createInputStream(len, inbuffer);
            return new InputStream(){
                long receivedBytes = 0L;
                long lastNotificationIndex = -1L;

                private long scaledReceiveTotalBytes(long b) {
                    long t = receiveTotalBytes;
                    while (0L < t && t <= b) {
                        long u = 161L * t / 100L;
                        if (t < u) {
                            t = u;
                            continue;
                        }
                        t *= 2L;
                    }
                    return t;
                }

                private void onReceiveProgress(long bytes) {
                    long notificationIndex;
                    this.receivedBytes += bytes;
                    if (null != progressCallback && this.lastNotificationIndex != (notificationIndex = this.receivedBytes / 4096L)) {
                        this.lastNotificationIndex = notificationIndex;
                        progressCallback.onReceiveProgress(this.receivedBytes, this.scaledReceiveTotalBytes(this.receivedBytes));
                    }
                }

                private void onReceiveCompleted() {
                    if (null != progressCallback) {
                        progressCallback.onReceiveCompleted(this.receivedBytes, this.receivedBytes);
                    }
                }

                @Override
                public int read() throws IOException {
                    int b = is.read();
                    this.onReceiveProgress(1L);
                    return b;
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    for (int i = 0; i < len; i += 4096) {
                        int c = Math.min(4096, len - i);
                        int r = is.read(b, off + i, c);
                        if (0 < r) {
                            this.onReceiveProgress(r);
                        }
                        if (r >= c) continue;
                        return i + r;
                    }
                    return len;
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    this.onReceiveCompleted();
                }

                @Override
                public long skip(long n) throws IOException {
                    return is.skip(n);
                }

                @Override
                public int available() throws IOException {
                    return is.available();
                }

                @Override
                public boolean markSupported() {
                    return is.markSupported();
                }

                @Override
                public void mark(int readlimit) {
                    is.mark(readlimit);
                }

                @Override
                public void reset() throws IOException {
                    is.reset();
                }
            };
        }
    }

    static final class NextopHttpClientConnectionFactory
    implements HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> {
        private final HttpMessageWriterFactory<HttpRequest> requestWriterFactory;
        private final HttpMessageParserFactory<HttpResponse> responseParserFactory;
        private final ContentLengthStrategy incomingContentStrategy;
        private final ContentLengthStrategy outgoingContentStrategy;
        private final AtomicInteger connectionCounter = new AtomicInteger(0);

        public NextopHttpClientConnectionFactory(@Nullable HttpMessageWriterFactory<HttpRequest> requestWriterFactory, @Nullable HttpMessageParserFactory<HttpResponse> responseParserFactory, @Nullable ContentLengthStrategy incomingContentStrategy, @Nullable ContentLengthStrategy outgoingContentStrategy) {
            this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
            this.responseParserFactory = responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE;
            this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : LaxContentLengthStrategy.INSTANCE;
            this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : StrictContentLengthStrategy.INSTANCE;
        }

        public NextopHttpClientConnectionFactory(@Nullable HttpMessageWriterFactory<HttpRequest> requestWriterFactory, @Nullable HttpMessageParserFactory<HttpResponse> responseParserFactory) {
            this(requestWriterFactory, responseParserFactory, null, null);
        }

        public NextopHttpClientConnectionFactory(@Nullable HttpMessageParserFactory<HttpResponse> responseParserFactory) {
            this(null, responseParserFactory);
        }

        public NextopHttpClientConnectionFactory() {
            this(null, null);
        }

        public NextopHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
            CodingErrorAction unmappableInputAction;
            ConnectionConfig cconfig = config != null ? config : ConnectionConfig.DEFAULT;
            CharsetDecoder chardecoder = null;
            CharsetEncoder charencoder = null;
            Charset charset = cconfig.getCharset();
            CodingErrorAction malformedInputAction = cconfig.getMalformedInputAction() != null ? cconfig.getMalformedInputAction() : CodingErrorAction.REPORT;
            CodingErrorAction codingErrorAction = unmappableInputAction = cconfig.getUnmappableInputAction() != null ? cconfig.getUnmappableInputAction() : CodingErrorAction.REPORT;
            if (charset != null) {
                chardecoder = charset.newDecoder();
                chardecoder.onMalformedInput(malformedInputAction);
                chardecoder.onUnmappableCharacter(unmappableInputAction);
                charencoder = charset.newEncoder();
                charencoder.onMalformedInput(malformedInputAction);
                charencoder.onUnmappableCharacter(unmappableInputAction);
            }
            String id = String.format("nextop-http-%d", this.connectionCounter.getAndIncrement());
            return new NextopHttpClientConnection(id, cconfig.getBufferSize(), cconfig.getFragmentSizeHint(), chardecoder, charencoder, cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
        }
    }

    static final class NextopClientExec
    implements ClientExecChain {
        private final HttpRequestExecutor requestExecutor;
        private final HttpClientConnectionManager connManager;
        private final ConnectionReuseStrategy reuseStrategy;
        private final ConnectionKeepAliveStrategy keepAliveStrategy;
        private final HttpProcessor httpProcessor;

        public NextopClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, String userAgent) {
            this.httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(userAgent)});
            this.requestExecutor = requestExecutor;
            this.connManager = connManager;
            this.reuseStrategy = reuseStrategy;
            this.keepAliveStrategy = keepAliveStrategy;
        }

        static void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route) throws ProtocolException {
            try {
                URI uri = request.getURI();
                if (uri != null) {
                    uri = uri.isAbsolute() ? URIUtils.rewriteURI((URI)uri, null, (boolean)true) : URIUtils.rewriteURI((URI)uri);
                    request.setURI(uri);
                }
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), (Throwable)ex);
            }
        }

        public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
            HttpClientConnection managedConn;
            NextopClientExec.rewriteRequestURI(request, route);
            ConnectionRequest connRequest = this.connManager.requestConnection(route, null);
            if (execAware != null) {
                if (execAware.isAborted()) {
                    connRequest.cancel();
                    throw new RequestAbortedException("Request aborted");
                }
                execAware.setCancellable((Cancellable)connRequest);
            }
            RequestConfig config = context.getRequestConfig();
            try {
                int timeout = config.getConnectionRequestTimeout();
                managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interrupted) {
                Thread.currentThread().interrupt();
                throw new RequestAbortedException("Request aborted", (Throwable)interrupted);
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                throw new RequestAbortedException("Request execution failed", cause);
            }
            NextopConnectionHolder releaseTrigger = new NextopConnectionHolder(this.connManager, managedConn);
            try {
                URI uri;
                int timeout;
                if (execAware != null) {
                    if (execAware.isAborted()) {
                        releaseTrigger.close();
                        throw new RequestAbortedException("Request aborted");
                    }
                    execAware.setCancellable((Cancellable)releaseTrigger);
                }
                if (!managedConn.isOpen()) {
                    timeout = config.getConnectTimeout();
                    this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, (HttpContext)context);
                    this.connManager.routeComplete(managedConn, route, (HttpContext)context);
                }
                if ((timeout = config.getSocketTimeout()) >= 0) {
                    managedConn.setSocketTimeout(timeout);
                }
                HttpHost target = null;
                HttpRequest original = request.getOriginal();
                if (original instanceof HttpUriRequest && (uri = ((HttpUriRequest)original).getURI()).isAbsolute()) {
                    target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                }
                if (target == null) {
                    target = route.getTargetHost();
                }
                context.setAttribute("http.target_host", (Object)target);
                context.setAttribute("http.request", (Object)request);
                context.setAttribute("http.connection", (Object)managedConn);
                context.setAttribute("http.route", (Object)route);
                this.httpProcessor.process((HttpRequest)request, (HttpContext)context);
                HttpResponse response = this.requestExecutor.execute((HttpRequest)request, managedConn, (HttpContext)context);
                this.httpProcessor.process(response, (HttpContext)context);
                if (this.reuseStrategy.keepAlive(response, (HttpContext)context)) {
                    long duration = this.keepAliveStrategy.getKeepAliveDuration(response, (HttpContext)context);
                    releaseTrigger.setValidFor(duration, TimeUnit.MILLISECONDS);
                    releaseTrigger.markReusable();
                } else {
                    releaseTrigger.markNonReusable();
                }
                HttpEntity entity = response.getEntity();
                if (entity == null || !entity.isStreaming()) {
                    releaseTrigger.releaseConnection();
                    return new NextopHttpResponseProxy(response, null);
                }
                return new NextopHttpResponseProxy(response, releaseTrigger);
            }
            catch (ConnectionShutdownException ex) {
                InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
                ioex.initCause(ex);
                throw ioex;
            }
            catch (HttpException ex) {
                releaseTrigger.abortConnection();
                throw ex;
            }
            catch (IOException ex) {
                releaseTrigger.abortConnection();
                throw ex;
            }
            catch (RuntimeException ex) {
                releaseTrigger.abortConnection();
                throw ex;
            }
        }
    }

    static final class NextopHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        private SendStrategy sendStrategy;
        private final MessageControlState.Entry entry;
        private final MessageControlState mcs;

        NextopHttpRequestRetryHandler(SendStrategy sendStrategy, MessageControlState.Entry entry, MessageControlState mcs) {
            this.sendStrategy = sendStrategy;
            this.entry = entry;
            this.mcs = mcs;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            this.sendStrategy = this.sendStrategy.retry();
            if (!this.sendStrategy.isSend()) {
                return false;
            }
            if (null != this.entry.end) {
                return false;
            }
            if (HttpClientContext.adapt((HttpContext)context).isRequestSent() && Message.isIdempotent(this.entry.message)) {
                return false;
            }
            int timeoutMs = (int)this.sendStrategy.getDelay(TimeUnit.MILLISECONDS);
            try {
                return !this.mcs.hasFirstAvailable(this.entry.id, timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }

    static interface ProgressCallback {
        public void onSendStarted(int var1);

        public void onSendProgress(long var1, long var3);

        public void onSendCompleted(long var1, long var3);

        public void onReceiveStarted(int var1);

        public void onReceiveProgress(long var1, long var3);

        public void onReceiveCompleted(long var1, long var3);
    }

    final class ProgressAdapter
    implements ProgressCallback {
        final MessageControlState.Entry entry;
        MessageControlState mcs;

        ProgressAdapter(MessageControlState.Entry entry) {
            this.mcs = HttpNode.this.getMessageControlState();
            this.entry = entry;
        }

        @Override
        public void onSendStarted(int tryCount) {
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    ProgressAdapter.this.mcs.setOutboxTransferProgress(ProgressAdapter.this.entry.id, MessageControlState.TransferProgress.none(ProgressAdapter.this.entry.id));
                }
            });
        }

        @Override
        public void onSendProgress(final long sentBytes, final long sendTotalBytes) {
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    ProgressAdapter.this.mcs.setOutboxTransferProgress(ProgressAdapter.this.entry.id, MessageControlState.TransferProgress.create(ProgressAdapter.this.entry.id, sentBytes, sendTotalBytes));
                }
            });
        }

        @Override
        public void onSendCompleted(final long sentBytes, final long sendTotalBytes) {
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    ProgressAdapter.this.mcs.setOutboxTransferProgress(ProgressAdapter.this.entry.id, MessageControlState.TransferProgress.create(ProgressAdapter.this.entry.id, sentBytes, sendTotalBytes));
                }
            });
        }

        @Override
        public void onReceiveStarted(int tryCount) {
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    ProgressAdapter.this.mcs.setInboxTransferProgress(ProgressAdapter.this.entry.id, MessageControlState.TransferProgress.none(ProgressAdapter.this.entry.id));
                }
            });
        }

        @Override
        public void onReceiveProgress(final long receivedBytes, final long receiveTotalBytes) {
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    ProgressAdapter.this.mcs.setInboxTransferProgress(ProgressAdapter.this.entry.id, MessageControlState.TransferProgress.create(ProgressAdapter.this.entry.id, receivedBytes, receiveTotalBytes));
                }
            });
        }

        @Override
        public void onReceiveCompleted(final long receivedBytes, final long receiveTotalBytes) {
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    ProgressAdapter.this.mcs.setInboxTransferProgress(ProgressAdapter.this.entry.id, MessageControlState.TransferProgress.create(ProgressAdapter.this.entry.id, receivedBytes, receiveTotalBytes));
                }
            });
        }
    }

    final class RequestLooper
    extends Thread {
        final MessageControlState mcs;
        final SharedLooperState sls;
        @Nullable
        ProgressCallback progressCallback = null;
        @Nullable
        Wire.Adapter wireAdapter = null;

        RequestLooper(MessageControlState mcs, SharedLooperState sls) {
            this.mcs = mcs;
            this.sls = sls;
        }

        @Override
        public void run() {
            while (HttpNode.this.active) {
                MessageControlState.Entry entry;
                block19: {
                    try {
                        entry = this.mcs.takeFirstAvailable(IS_SENDABLE, (MessageControlChannel)HttpNode.this, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    if (null == entry) continue;
                    SharedLooperState.MostRecentSend mostRecentSend = this.sls.mostRecentSends.get(entry.id);
                    if (null != mostRecentSend) {
                        int delayMs = (int)mostRecentSend.activeStrategy.getDelay(TimeUnit.MILLISECONDS);
                        int elapsedMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - mostRecentSend.nanos);
                        if (elapsedMs < delayMs) {
                            int remainingMs = delayMs - elapsedMs;
                            if (!Message.isYieldable(entry.message)) {
                                try {
                                    Thread.sleep(remainingMs);
                                    break block19;
                                }
                                catch (InterruptedException e) {
                                    this.mcs.release(entry.id, HttpNode.this);
                                    continue;
                                }
                            }
                            if (elapsedMs < this.sls.retakeYieldQMs) {
                                if (remainingMs < this.sls.retakeYieldQMs) {
                                    try {
                                        Thread.sleep(remainingMs);
                                        break block19;
                                    }
                                    catch (InterruptedException e) {
                                        this.mcs.release(entry.id, HttpNode.this);
                                        continue;
                                    }
                                }
                                try {
                                    this.sls.getClass();
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e) {
                                    this.mcs.release(entry.id, HttpNode.this);
                                    continue;
                                }
                                this.mcs.yield(entry.id);
                                this.mcs.release(entry.id, HttpNode.this);
                                continue;
                            }
                            this.mcs.yield(entry.id);
                            this.mcs.release(entry.id, HttpNode.this);
                            continue;
                        }
                    }
                }
                this.wireAdapter = HttpNode.this.wireAdapter;
                assert (null == entry.end);
                try {
                    this.end(entry, this.execute(entry));
                }
                catch (IOException e) {
                    this.retake(entry);
                }
                catch (HttpException e) {
                    this.retake(entry);
                }
                catch (Throwable t) {
                    this.end(entry, MessageControlState.End.ERROR);
                }
            }
        }

        private void retake(MessageControlState.Entry entry) {
            assert (null == entry.end);
            SharedLooperState.MostRecentSend mostRecentSend = this.sls.mostRecentSends.get(entry.id);
            SendStrategy nextStrategy = null != mostRecentSend ? mostRecentSend.activeStrategy.retry() : HttpNode.this.retakeStrategy.retry();
            if (!nextStrategy.isSend()) {
                nextStrategy = FALLBACK_RETAKE_STRATEGY.retry();
            }
            assert (nextStrategy.isSend());
            this.sls.mostRecentSends.put(entry.id, new SharedLooperState.MostRecentSend(System.nanoTime(), nextStrategy));
            if (Message.isYieldable(entry.message)) {
                this.mcs.yield(entry.id);
            }
            this.mcs.release(entry.id, HttpNode.this);
        }

        private void end(MessageControlState.Entry entry, MessageControlState.End end) {
            assert (null == entry.end);
            this.sls.mostRecentSends.remove(entry.id);
            this.mcs.remove(entry.id, end);
            final Route route = entry.message.inboxRoute();
            switch (end) {
                case COMPLETED: {
                    HttpNode.this.post(new Runnable(){

                        @Override
                        public void run() {
                            HttpNode.this.upstream.onMessageControl(MessageControl.receive(MessageControl.Type.COMPLETE, route));
                        }
                    });
                    break;
                }
                case ERROR: {
                    HttpNode.this.post(new Runnable(){

                        @Override
                        public void run() {
                            HttpNode.this.upstream.onMessageControl(MessageControl.receive(MessageControl.Type.ERROR, route));
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageControlState.End execute(MessageControlState.Entry entry) throws IOException, HttpException {
            Message responseMessage;
            HttpHost target;
            HttpUriRequest request;
            try {
                request = Message.toHttpRequest(entry.message);
            }
            catch (URISyntaxException e) {
                return MessageControlState.End.ERROR;
            }
            try {
                target = Message.toHttpHost(entry.message);
            }
            catch (URISyntaxException e) {
                return MessageControlState.End.ERROR;
            }
            this.progressCallback = new ProgressAdapter(entry);
            try {
                CloseableHttpResponse response = this.doExecute(this.createExecChain(entry), target, (HttpRequest)request, null);
                responseMessage = Message.fromHttpResponse((HttpResponse)response).setRoute(entry.message.inboxRoute()).build();
            }
            finally {
                this.progressCallback = null;
            }
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    HttpNode.this.upstream.onMessageControl(MessageControl.receive(responseMessage));
                }
            });
            return MessageControlState.End.COMPLETED;
        }

        private CloseableHttpResponse doExecute(ClientExecChain execChain, HttpHost target, HttpRequest request, @Nullable HttpContext context) throws IOException, HttpException {
            HttpExecutionAware execAware = null;
            if (request instanceof HttpExecutionAware) {
                execAware = (HttpExecutionAware)request;
            }
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap((HttpRequest)request);
            HttpClientContext localcontext = HttpClientContext.adapt((HttpContext)(null != context ? context : new BasicHttpContext()));
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)request).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return execChain.execute(route, wrapper, localcontext, execAware);
        }

        private ClientExecChain createExecChain(MessageControlState.Entry entry) {
            NextopClientExec nextopExec = new NextopClientExec(new NextopHttpRequestExecutor(this.progressCallback), (HttpClientConnectionManager)HttpNode.this.clientConnectionManager, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, (ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE, HttpNode.this.config.userAgent);
            return new RetryExec((ClientExecChain)nextopExec, (HttpRequestRetryHandler)new NextopHttpRequestRetryHandler(HttpNode.this.sendStrategy, entry, this.mcs));
        }
    }

    private static final class SharedLooperState {
        final Map<Id, MostRecentSend> mostRecentSends = new ConcurrentHashMap<Id, MostRecentSend>(8);
        final int retakeYieldQMs = 50;

        SharedLooperState() {
        }

        static final class MostRecentSend {
            final long nanos;
            final SendStrategy activeStrategy;

            MostRecentSend(long nanos, SendStrategy activeStrategy) {
                this.nanos = nanos;
                this.activeStrategy = activeStrategy;
            }
        }
    }

    public static final class Config {
        public final String userAgent;
        public final int maxConcurrentConnections;

        public Config(String userAgent, int maxConcurrentConnections) {
            this.userAgent = userAgent;
            this.maxConcurrentConnections = maxConcurrentConnections;
        }
    }
}

