/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client.node;

import com.google.common.collect.ImmutableSet;
import io.nextop.Authority;
import io.nextop.client.MessageControl;
import io.nextop.client.MessageControlChannel;
import io.nextop.client.MessageControlNode;
import io.nextop.client.MessageControlState;
import io.nextop.client.node.AbstractMessageControlNode;
import io.nextop.log.NL;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nullable;
import rx.Scheduler;

public class MultiNode
extends AbstractMessageControlNode {
    private final DownstreamState[] downstreamStates;
    private Queue<MessageControl> pendingMessageControls = new LinkedList<MessageControl>();
    private boolean active = false;
    private Collection<Subnet> localSubnets = Collections.emptyList();

    public MultiNode(Downstream ... downstreams) {
        int n = downstreams.length;
        this.downstreamStates = new DownstreamState[n];
        for (int i = 0; i < n; ++i) {
            this.downstreamStates[i] = new DownstreamState(downstreams[i], false);
        }
    }

    @Nullable
    private MessageControlNode getActiveDownstream() {
        for (DownstreamState state : this.downstreamStates) {
            if (!state.downActive) continue;
            assert (state.upActive);
            return state.downstream.node;
        }
        return null;
    }

    private void setActiveDownstream() {
        if (!this.active) {
            this.clearActiveDownstream();
        } else {
            int firstUpActiveIndex = -1;
            int n = this.downstreamStates.length;
            for (int i = 0; i < n; ++i) {
                DownstreamState state = this.downstreamStates[i];
                if (!state.upActive || !state.compatible) continue;
                firstUpActiveIndex = i;
                break;
            }
            if (firstUpActiveIndex < 0) {
                this.clearActiveDownstream();
            } else if (!this.downstreamStates[firstUpActiveIndex].downActive) {
                MessageControl mc;
                this.clearActiveDownstream();
                DownstreamState activeDownstreamState = this.downstreamStates[firstUpActiveIndex];
                activeDownstreamState.downActive = true;
                activeDownstreamState.downstream.node.onActive(true);
                while (null != (mc = this.pendingMessageControls.poll())) {
                    activeDownstreamState.downstream.node.onMessageControl(mc);
                }
            }
        }
    }

    private void clearActiveDownstream() {
        for (DownstreamState state : this.downstreamStates) {
            if (!state.downActive) continue;
            state.downstream.node.onActive(false);
            break;
        }
        assert (null == this.getActiveDownstream());
    }

    @Override
    protected void initSelf(@Nullable MessageControlNode.Bundle savedState) {
        this.upstream.onActive(true);
        try {
            this.localSubnets = MultiNode.findLocalSubnets();
        }
        catch (IOException e) {
            NL.nl.handled("node.multi.init", e);
        }
    }

    @Override
    protected void initDownstream(@Nullable MessageControlNode.Bundle savedState) {
        for (final DownstreamState state : this.downstreamStates) {
            state.downstream.node.init(new MessageControlChannel(){

                @Override
                public void onActive(boolean active) {
                    state.upActive = active;
                    MultiNode.this.setActiveDownstream();
                }

                @Override
                public void onMessageControl(MessageControl mc) {
                    switch (mc.dir) {
                        case SEND: {
                            MultiNode.this.onMessageControl(mc);
                            break;
                        }
                        case RECEIVE: {
                            MultiNode.this.upstream.onMessageControl(mc);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }

                @Override
                public MessageControlState getMessageControlState() {
                    return MultiNode.this.getMessageControlState();
                }

                @Override
                public void post(Runnable r) {
                    MultiNode.this.post(r);
                }

                @Override
                public void postDelayed(Runnable r, int delayMs) {
                    MultiNode.this.postDelayed(r, delayMs);
                }

                @Override
                public Scheduler getScheduler() {
                    return MultiNode.this.getScheduler();
                }
            }, savedState);
        }
    }

    @Override
    public void onActive(boolean active) {
        this.active = active;
        this.setActiveDownstream();
    }

    @Override
    public void onMessageControl(MessageControl mc) {
        MessageControlNode activeDownstream;
        if (MultiNode.contains(this.localSubnets, mc.message.route.via.authority)) {
            boolean modified = false;
            for (DownstreamState state : this.downstreamStates) {
                if (!state.compatible || state.downstream.support.contains((Object)Downstream.Support.LOCAL)) continue;
                state.compatible = false;
                modified = true;
            }
            if (modified) {
                this.setActiveDownstream();
            }
        }
        if (null != (activeDownstream = this.getActiveDownstream())) {
            activeDownstream.onMessageControl(mc);
        } else {
            this.pendingMessageControls.add(mc);
        }
    }

    private static Collection<Subnet> findLocalSubnets() throws IOException {
        NetworkInterface i;
        LinkedList<NetworkInterface> is = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            is.add(e.nextElement());
        }
        ArrayList<Subnet> subnets = new ArrayList<Subnet>(4);
        while (null != (i = (NetworkInterface)is.poll())) {
            for (InterfaceAddress ia : i.getInterfaceAddresses()) {
                subnets.add(Subnet.valueOf(ia));
            }
            NetworkInterface p = i.getParent();
            if (null == p) continue;
            is.offer(p);
        }
        return subnets;
    }

    private static BitSet bits(byte[] bytes) {
        BitSet bits = new BitSet(8 * bytes.length);
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            int b = 0xFF & bytes[i];
            int j = 8 * i;
            for (int k = 0; k < 8; ++k) {
                bits.set(j + k, 0 != b >>> 7 - k);
            }
        }
        return bits;
    }

    static boolean contains(Collection<Subnet> subnets, Authority authority) {
        switch (authority.type) {
            case LOCAL: {
                return false;
            }
            case NAMED: {
                for (Subnet subnet : subnets) {
                    if (!subnet.host.equals(authority.getHost())) continue;
                    return true;
                }
                return false;
            }
            case IP: {
                BitSet address = MultiNode.bits(authority.getIp().getAddress());
                block6: for (Subnet subnet : subnets) {
                    int n = subnet.prefixLength;
                    for (int i = 0; i < n; ++i) {
                        if (address.get(i) != subnet.address.get(i)) continue block6;
                    }
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class Subnet {
        final String host;
        final BitSet address;
        final int prefixLength;

        static Subnet valueOf(InterfaceAddress ia) {
            InetAddress a = ia.getAddress();
            return new Subnet(a.getHostName(), MultiNode.bits(a.getAddress()), ia.getNetworkPrefixLength());
        }

        Subnet(String host, BitSet address, int prefixLength) {
            this.host = host;
            this.address = address;
            this.prefixLength = prefixLength;
        }
    }

    public static final class Downstream {
        public final MessageControlNode node;
        public final ImmutableSet<Support> support;

        public static Downstream create(MessageControlNode node, Support ... support) {
            return new Downstream(node, (ImmutableSet<Support>)ImmutableSet.copyOf((Object[])support));
        }

        Downstream(MessageControlNode node, ImmutableSet<Support> support) {
            this.node = node;
            this.support = support;
        }

        public static enum Support {
            LOCAL;

        }
    }

    private static final class DownstreamState {
        final Downstream downstream;
        boolean upActive;
        boolean downActive = false;
        boolean compatible = true;

        DownstreamState(Downstream downstream, boolean upActive) {
            this.downstream = downstream;
            this.upActive = upActive;
        }
    }
}

