/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client.node;

import io.nextop.client.MessageControlChannel;
import io.nextop.client.MessageControlNode;
import io.nextop.client.MessageControlState;
import javax.annotation.Nullable;
import rx.Scheduler;

public abstract class AbstractMessageControlNode
implements MessageControlNode {
    @Nullable
    protected MessageControlChannel upstream = null;

    private void checkUpstream() {
        if (null == this.upstream) {
            throw new IllegalStateException();
        }
    }

    protected void initSelf(MessageControlNode.Bundle savedState) {
    }

    protected void initDownstream(MessageControlNode.Bundle savedState) {
    }

    @Override
    public final void init(MessageControlChannel upstream, @Nullable MessageControlNode.Bundle savedState) {
        if (null != this.upstream) {
            throw new IllegalStateException();
        }
        this.upstream = upstream;
        this.initSelf(savedState);
        this.initDownstream(savedState);
    }

    @Override
    public void onSaveState(MessageControlNode.Bundle savedState) {
    }

    @Override
    public final MessageControlState getMessageControlState() {
        return this.upstream.getMessageControlState();
    }

    @Override
    public final void post(Runnable r) {
        this.checkUpstream();
        this.upstream.post(r);
    }

    @Override
    public final void postDelayed(Runnable r, int delayMs) {
        this.checkUpstream();
        this.upstream.postDelayed(r, delayMs);
    }

    @Override
    public final Scheduler getScheduler() {
        this.checkUpstream();
        return this.upstream.getScheduler();
    }
}

