/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import io.nextop.Id;
import io.nextop.Message;
import io.nextop.Route;
import io.nextop.WireValue;
import io.nextop.client.MessageContext;
import io.nextop.client.MessageControl;
import io.nextop.client.MessageControlChannel;
import io.nextop.sortedlist.SortedList;
import io.nextop.sortedlist.SplaySortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.subjects.BehaviorSubject;

public final class MessageControlState {
    private final MessageContext context;
    private final Object mutex = new Object();
    private int headIndex = 0;
    private final Map<Id, Entry> entries;
    private final Set<Id> pending;
    private final Multimap<Id, Subscriber<? super Entry>> pendingSubscribers;
    private final Map<Id, Group> groups;
    private final SortedList<Group> groupsByPriority;
    private final BehaviorSubject<MessageControlState> publish;
    private static final Comparator<Group> COMPARATOR_GROUP_AVAILABLE = new Comparator<Group>(){

        @Override
        public int compare(Group a, Group b) {
            if (a == b) {
                return 0;
            }
            boolean aEmpty = a.entries.isEmpty();
            boolean bEmpty = b.entries.isEmpty();
            if (aEmpty && bEmpty) {
                return a.groupId.compareTo(b.groupId);
            }
            if (aEmpty) {
                return 1;
            }
            if (bEmpty) {
                return -1;
            }
            int aMaxGroupPriority = a.entriesByPriority.peek().groupPriority;
            int bMaxGroupPriority = b.entriesByPriority.peek().groupPriority;
            if (aMaxGroupPriority < bMaxGroupPriority) {
                return 1;
            }
            if (bMaxGroupPriority < aMaxGroupPriority) {
                return -1;
            }
            int aIndex = ((Entry)a.entries.get((int)0)).index;
            int bIndex = ((Entry)b.entries.get((int)0)).index;
            if (aIndex < bIndex) {
                return -1;
            }
            if (bIndex < aIndex) {
                return 1;
            }
            throw new IllegalStateException();
        }
    };
    private static final Comparator<Entry> COMPARATOR_ENTRY_AVAILABLE = new Comparator<Entry>(){

        @Override
        public int compare(Entry a, Entry b) {
            boolean bOwned;
            if (a == b) {
                return 0;
            }
            boolean aOwned = null != a.owner;
            boolean bl = bOwned = null != b.owner;
            if (aOwned != bOwned) {
                if (aOwned) {
                    return -1;
                }
                return 1;
            }
            int aIndex = a.index;
            int bIndex = b.index;
            if (aIndex < bIndex) {
                return -1;
            }
            if (bIndex < aIndex) {
                return 1;
            }
            throw new IllegalStateException();
        }
    };
    private static final Comparator<Entry> COMPARATOR_ENTRY_DESCENDING_PRIORITY = new Comparator<Entry>(){

        @Override
        public int compare(Entry a, Entry b) {
            if (a.groupPriority < b.groupPriority) {
                return 1;
            }
            if (b.groupPriority < a.groupPriority) {
                return -1;
            }
            return 0;
        }
    };

    public MessageControlState(MessageContext context) {
        this.context = context;
        this.entries = new HashMap<Id, Entry>(32);
        this.groups = new HashMap<Id, Group>(8);
        this.groupsByPriority = new SplaySortedList<Group>(COMPARATOR_GROUP_AVAILABLE);
        this.pending = new HashSet<Id>(4);
        this.pendingSubscribers = HashMultimap.create((int)4, (int)4);
        this.publish = BehaviorSubject.create((Object)this);
    }

    @Nullable
    public Entry takeFirstAvailable(MessageControlChannel owner) {
        return this.takeFirstAvailable(null, null, owner);
    }

    public Entry takeFirstAvailable(Id minExclusive, MessageControlChannel owner) {
        if (null == minExclusive) {
            throw new IllegalArgumentException();
        }
        return this.takeFirstAvailable(null, minExclusive, owner);
    }

    public Entry takeFirstAvailable(Func1<Entry, Boolean> predicate, MessageControlChannel owner) {
        if (null == predicate) {
            throw new IllegalArgumentException();
        }
        return this.takeFirstAvailable(predicate, null, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entry takeFirstAvailable(@Nullable Func1<Entry, Boolean> predicate, @Nullable Id minExclusive, MessageControlChannel owner) {
        Object object = this.mutex;
        synchronized (object) {
            for (Group group : this.groupsByPriority) {
                if (group.entries.isEmpty()) continue;
                Entry first = (Entry)group.entries.get(0);
                if (null != minExclusive && minExclusive.equals(first.id)) {
                    return null;
                }
                if (null != first.owner || null != predicate && !((Boolean)predicate.call((Object)first)).booleanValue()) continue;
                this.take(first.id, owner);
                return first;
            }
            return null;
        }
    }

    @Nullable
    public Entry takeFirstAvailable(MessageControlChannel owner, long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.takeFirstAvailable(null, null, owner, timeout, timeUnit);
    }

    @Nullable
    public Entry takeFirstAvailable(Id minExclusive, MessageControlChannel owner, long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.takeFirstAvailable(null, minExclusive, owner, timeout, timeUnit);
    }

    @Nullable
    public Entry takeFirstAvailable(Func1<Entry, Boolean> predicate, MessageControlChannel owner, long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.takeFirstAvailable(predicate, null, owner, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entry takeFirstAvailable(@Nullable Func1<Entry, Boolean> predicate, @Nullable Id minExclusive, MessageControlChannel owner, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long nanosPerMillis = TimeUnit.MILLISECONDS.toNanos(1L);
        Object object = this.mutex;
        synchronized (object) {
            Entry entry;
            long nanos;
            for (long timeoutNanos = timeUnit.toNanos(timeout); null == (entry = this.takeFirstAvailable(predicate, minExclusive, owner)) && 0L < timeoutNanos; timeoutNanos -= System.nanoTime() - nanos) {
                nanos = System.nanoTime();
                this.mutex.wait(timeoutNanos / nanosPerMillis, (int)(timeoutNanos % nanosPerMillis));
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public boolean hasFirstAvailable() {
        Object object = this.mutex;
        synchronized (object) {
            for (Group group : this.groupsByPriority) {
                if (group.entries.isEmpty()) continue;
                Entry first = (Entry)group.entries.get(0);
                if (null != first.owner) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFirstAvailable(Id min) {
        if (null == min) {
            throw new IllegalArgumentException();
        }
        Object object = this.mutex;
        synchronized (object) {
            for (Group group : this.groupsByPriority) {
                if (group.entries.isEmpty()) continue;
                Entry first = (Entry)group.entries.get(0);
                if (min.equals(first.id)) {
                    return false;
                }
                if (null != first.owner) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFirstAvailable(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long nanosPerMillis = TimeUnit.MILLISECONDS.toNanos(1L);
        Object object = this.mutex;
        synchronized (object) {
            boolean a;
            long nanos;
            for (long timeoutNanos = timeUnit.toNanos(timeout); !(a = this.hasFirstAvailable()) && 0L < timeoutNanos; timeoutNanos -= System.nanoTime() - nanos) {
                nanos = System.nanoTime();
                this.mutex.wait(timeoutNanos / nanosPerMillis, (int)(timeoutNanos % nanosPerMillis));
            }
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFirstAvailable(Id min, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long nanosPerMillis = TimeUnit.MILLISECONDS.toNanos(1L);
        Object object = this.mutex;
        synchronized (object) {
            boolean a;
            long nanos;
            for (long timeoutNanos = timeUnit.toNanos(timeout); !(a = this.hasFirstAvailable(min)) && 0L < timeoutNanos; timeoutNanos -= System.nanoTime() - nanos) {
                nanos = System.nanoTime();
                this.mutex.wait(timeoutNanos / nanosPerMillis, (int)(timeoutNanos % nanosPerMillis));
            }
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(Id id) {
        Object object = this.mutex;
        synchronized (object) {
            Entry entry = this.entries.get(id);
            if (null == entry) {
                return false;
            }
            if (null != entry.owner) {
                return false;
            }
            Group group = entry.group;
            assert (null != group);
            if (group.entries.isEmpty()) {
                return false;
            }
            Entry first = (Entry)group.entries.get(0);
            return id.equals(first.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take(Id id, MessageControlChannel owner) {
        Object object = this.mutex;
        synchronized (object) {
            Entry entry = this.entries.get(id);
            if (null == entry) {
                throw new IllegalArgumentException();
            }
            if (null != entry.owner) {
                throw new IllegalArgumentException();
            }
            Group group = entry.group;
            assert (null != group);
            this.groupsByPriority.remove(group);
            try {
                group.take(entry, owner);
            }
            finally {
                this.groupsByPriority.insert(group);
            }
            this.mutex.notifyAll();
        }
        this.publish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Id id, MessageControlChannel owner) {
        Object object = this.mutex;
        synchronized (object) {
            Entry entry = this.entries.get(id);
            if (null == entry) {
                throw new IllegalArgumentException();
            }
            if (owner != entry.owner) {
                throw new IllegalArgumentException();
            }
            Group group = entry.group;
            assert (null != group);
            this.groupsByPriority.remove(group);
            try {
                group.release(entry, owner);
            }
            finally {
                this.groupsByPriority.insert(group);
            }
            this.mutex.notifyAll();
        }
        this.publish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPending(Id id) {
        Object object = this.mutex;
        synchronized (object) {
            this.pending.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(MessageControl mc) {
        Collection subscribers;
        Entry entry;
        Iterator iterator = this.mutex;
        synchronized (iterator) {
            if (this.entries.containsKey(mc.message.id)) {
                return false;
            }
            entry = new Entry(this.headIndex++, mc);
            this.entries.put(entry.id, entry);
            this.pending.remove(entry.id);
            subscribers = this.pendingSubscribers.removeAll((Object)entry.id);
            Group group = this.groups.get(entry.groupId);
            if (null == group) {
                Id groupId = entry.groupId;
                group = new Group(groupId);
                this.groups.put(groupId, group);
            } else {
                this.groupsByPriority.remove(group);
            }
            group.add(entry);
            this.groupsByPriority.insert(group);
            this.mutex.notifyAll();
        }
        for (Subscriber subscriber : subscribers) {
            entry.publish.subscribe(subscriber);
        }
        this.publish();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MessageControl remove(Id id, End end) {
        Entry entry;
        Object object = this.mutex;
        synchronized (object) {
            entry = this.entries.remove(id);
            if (null == entry) {
                return null;
            }
            assert (null == entry.end);
            Group group = entry.group;
            assert (null != group);
            this.groupsByPriority.remove(group);
            group.remove(entry);
            if (!group.entries.isEmpty()) {
                this.groupsByPriority.insert(group);
            }
            entry.end = end;
            this.mutex.notifyAll();
        }
        entry.publish();
        entry.publishComplete();
        this.publish();
        return entry.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean yield(Id id) {
        Entry entry;
        Object object = this.mutex;
        synchronized (object) {
            entry = this.entries.get(id);
            if (null == entry) {
                return false;
            }
            assert (null == entry.end);
            Group group = entry.group;
            assert (null != group);
            this.groupsByPriority.remove(group);
            group.yield(entry);
            this.groupsByPriority.insert(group);
            this.mutex.notifyAll();
        }
        entry.publish();
        this.publish();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInboxTransferProgress(Id id, TransferProgress transferProgress) {
        Entry entry;
        Object object = this.mutex;
        synchronized (object) {
            entry = this.entries.get(id);
            if (null == entry) {
                return false;
            }
            if (null != entry.end) {
                return false;
            }
            entry.inboxTransferProgress = transferProgress;
        }
        entry.publish();
        this.publish();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOutboxTransferProgress(Id id, TransferProgress transferProgress) {
        Entry entry;
        Object object = this.mutex;
        synchronized (object) {
            entry = this.entries.get(id);
            if (null == entry) {
                return false;
            }
            if (null != entry.end) {
                return false;
            }
            entry.outboxTransferProgress = transferProgress;
        }
        entry.publish();
        this.publish();
        return true;
    }

    public Observable<MessageControlState> getObservable() {
        return this.publish;
    }

    private void publish() {
        this.publish.onNext((Object)this);
    }

    public Observable<Entry> getObservable(Id id) {
        return this.getObservable(id, 0L, TimeUnit.MILLISECONDS);
    }

    public Observable<Entry> getObservable(final Id id, final long timeout, final TimeUnit timeUnit) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Entry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(final Subscriber<? super Entry> subscriber) {
                Entry entry;
                Object object = MessageControlState.this.mutex;
                synchronized (object) {
                    entry = (Entry)MessageControlState.this.entries.get(id);
                    if (null == entry) {
                        if (0L < timeout && MessageControlState.this.pending.contains(id)) {
                            MessageControlState.this.pendingSubscribers.put((Object)id, subscriber);
                            subscriber.add(MessageControlState.this.context.getScheduler().createWorker().schedule(new Action0(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void call() {
                                    Object object = MessageControlState.this.mutex;
                                    synchronized (object) {
                                        if (MessageControlState.this.pendingSubscribers.containsEntry((Object)id, (Object)subscriber)) {
                                            MessageControlState.this.pendingSubscribers.remove((Object)id, (Object)subscriber);
                                            subscriber.onCompleted();
                                            subscriber.unsubscribe();
                                        }
                                    }
                                }
                            }, timeout, timeUnit));
                        } else {
                            subscriber.onCompleted();
                            subscriber.unsubscribe();
                        }
                    }
                }
                if (null != entry) {
                    entry.publish.subscribe(subscriber);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            int c = 0;
            for (Group g : this.groupsByPriority) {
                c += g.entries.size();
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Id id) {
        Object object = this.mutex;
        synchronized (object) {
            Group g;
            Entry entry = this.entries.get(id);
            if (null == entry) {
                return -1;
            }
            Group group = this.groups.get(entry.message.groupId);
            if (null == group) {
                return -1;
            }
            int c = 0;
            Iterator iterator = this.groupsByPriority.iterator();
            while (iterator.hasNext() && group != (g = (Group)iterator.next())) {
                c += g.entries.size();
            }
            return c + group.entries.indexOf(entry);
        }
    }

    public Entry get(int index) {
        Object object = this.mutex;
        synchronized (object) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            int c = index;
            for (Group g : this.groupsByPriority) {
                int n = g.entries.size();
                if (c < n) {
                    return (Entry)g.entries.get(c);
                }
                c -= n;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupSnapshot> getGroups() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<GroupSnapshot> groupSnapshots = new ArrayList<GroupSnapshot>(this.groupsByPriority.size());
            for (Group g : this.groupsByPriority) {
                groupSnapshots.add(new GroupSnapshot(g.groupId, (List<Entry>)ImmutableList.copyOf(g.entries)));
            }
            return Collections.unmodifiableList(groupSnapshots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(Id groupId, int index) {
        Object object = this.mutex;
        synchronized (object) {
            Group group = this.groups.get(groupId);
            if (null == group) {
                throw new IndexOutOfBoundsException();
            }
            int n = group.entries.size();
            if (index < 0 || n <= index) {
                throw new IndexOutOfBoundsException();
            }
            return (Entry)group.entries.get(index);
        }
    }

    public boolean onActiveMessageControl(MessageControl mc, MessageControlChannel upstream) {
        Id id;
        Message message = mc.message;
        Route route = message.route;
        if (Message.isLocal(route) && null != (id = Message.getLocalId(route))) {
            if (MessageControl.Type.ERROR.equals((Object)mc.type) && Message.outboxRoute(id).equals(route)) {
                if (null != this.remove(id, End.ERROR)) {
                    upstream.onMessageControl(MessageControl.receive(MessageControl.Type.ERROR, Message.inboxRoute(id)));
                }
            } else if (MessageControl.Type.MESSAGE.equals((Object)mc.type) && Message.echoRoute(id).equals(route)) {
                MessageControl rmc = this.createRedirect(id, message.inboxRoute());
                if (null != rmc) {
                    upstream.onMessageControl(rmc);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private MessageControl createRedirect(Id id, Route newRoute) {
        Entry entry;
        Object object = this.mutex;
        synchronized (object) {
            entry = this.entries.get(id);
        }
        if (null == entry) {
            return null;
        }
        Message message = entry.message;
        return MessageControl.receive(MessageControl.Type.MESSAGE, message.toBuilder().setHeader(Message.H_REDIRECT, WireValue.of(Collections.singletonList(message.route.toString()))).setRoute(newRoute).build());
    }

    private final class Group {
        final Id groupId;
        final PriorityQueue<Entry> entriesByPriority;
        final SortedList<Entry> entries;

        Group(Id groupId) {
            this.groupId = groupId;
            this.entriesByPriority = new PriorityQueue(8, COMPARATOR_ENTRY_DESCENDING_PRIORITY);
            this.entries = new SplaySortedList<Entry>(COMPARATOR_ENTRY_AVAILABLE);
        }

        void add(Entry entry) {
            if (null != entry.group) {
                throw new IllegalArgumentException();
            }
            entry.group = this;
            this.entriesByPriority.add(entry);
            this.entries.insert(entry);
        }

        void remove(Entry entry) {
            if (this != entry.group) {
                throw new IllegalArgumentException();
            }
            this.entries.remove(entry);
            this.entriesByPriority.remove(entry);
            entry.group = null;
        }

        void yield(Entry entry) {
            if (this != entry.group) {
                throw new IllegalArgumentException();
            }
            this.entries.remove(entry);
            this.entriesByPriority.remove(entry);
            entry.index = MessageControlState.this.headIndex++;
            this.entriesByPriority.add(entry);
            this.entries.insert(entry);
        }

        void take(Entry entry, MessageControlChannel owner) {
            if (this != entry.group) {
                throw new IllegalArgumentException();
            }
            assert (null == entry.owner);
            this.entries.remove(entry);
            try {
                entry.owner = owner;
            }
            finally {
                this.entries.insert(entry);
            }
        }

        void release(Entry entry, MessageControlChannel owner) {
            if (this != entry.group) {
                throw new IllegalArgumentException();
            }
            assert (owner == entry.owner);
            this.entries.remove(entry);
            try {
                entry.owner = null;
            }
            finally {
                this.entries.insert(entry);
            }
        }
    }

    public static final class GroupSnapshot {
        public final Id groupId;
        public final List<Entry> entries;

        GroupSnapshot(Id groupId, List<Entry> entries) {
            this.groupId = groupId;
            this.entries = entries;
        }
    }

    public static final class TransferProgress {
        public final Id id;
        public final long completedBytes;
        public final long totalBytes;

        public static TransferProgress none(Id id) {
            return TransferProgress.create(id, 0L, 0L);
        }

        public static TransferProgress create(Id id, long completedBytes, long totalBytes) {
            if (totalBytes < 0L) {
                throw new IllegalArgumentException(String.format("%d", totalBytes));
            }
            if (completedBytes < 0L || 0L < totalBytes && totalBytes < completedBytes) {
                throw new IllegalArgumentException(String.format("%d %d", completedBytes, totalBytes));
            }
            return new TransferProgress(id, completedBytes, totalBytes);
        }

        TransferProgress(Id id, long completedBytes, long totalBytes) {
            this.id = id;
            this.completedBytes = completedBytes;
            this.totalBytes = totalBytes;
        }

        public boolean isNone() {
            return 0L == this.completedBytes && 0L == this.totalBytes;
        }

        public float asFloat() {
            int q = 1000;
            return 0L < this.totalBytes ? (float)(1000L * this.completedBytes / this.totalBytes) / 1000.0f : 0.0f;
        }

        public String toString() {
            if (this.isNone()) {
                return "-";
            }
            return String.format("%s %d/%d (%.2f%%)", this.id, this.completedBytes, this.totalBytes, Float.valueOf(this.asFloat()));
        }

        public int hashCode() {
            int c = this.id.hashCode();
            c = 31 * c + (int)(this.completedBytes ^ this.completedBytes >>> 32);
            c = 31 * c + (int)(this.totalBytes ^ this.totalBytes >>> 32);
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TransferProgress)) {
                return false;
            }
            TransferProgress p = (TransferProgress)obj;
            return this.completedBytes == p.completedBytes && this.totalBytes == p.totalBytes && this.id.equals(p.id);
        }
    }

    public static final class Entry {
        int index;
        public final Id id;
        public final Id groupId;
        public final int groupPriority;
        public final Message message;
        public final MessageControl mc;
        @Nullable
        public volatile MessageControlChannel owner = null;
        public volatile TransferProgress outboxTransferProgress;
        public volatile TransferProgress inboxTransferProgress;
        @Nullable
        public volatile End end = null;
        final BehaviorSubject<Entry> publish;
        @Nullable
        Group group = null;

        Entry(int index, MessageControl mc) {
            this.index = index;
            this.mc = mc;
            this.message = mc.message;
            this.groupId = mc.message.groupId;
            this.id = mc.message.id;
            this.groupPriority = mc.message.groupPriority;
            this.publish = BehaviorSubject.create((Object)this);
            this.outboxTransferProgress = TransferProgress.none(this.id);
            this.inboxTransferProgress = TransferProgress.none(this.id);
        }

        private void publish() {
            this.publish.onNext((Object)this);
        }

        private void publishComplete() {
            this.publish.onCompleted();
        }
    }

    public static enum End {
        COMPLETED,
        ERROR;

    }
}

