/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client;

import io.nextop.Message;
import io.nextop.Route;
import io.nextop.WireValue;
import java.util.HashMap;
import java.util.Map;

public final class MessageControl {
    private static final int S_VERSION = 1;
    private static final String S_KEY_VERSION = "version";
    private static final String S_KEY_DIR = "dir";
    private static final String S_KEY_TYPE = "type";
    private static final String S_KEY_MESSAGE = "message";
    public final Direction dir;
    public final Type type;
    public final Message message;

    public static MessageControl send(Message message) {
        return MessageControl.send(Type.MESSAGE, message);
    }

    public static MessageControl send(Type type, Route route) {
        Message spec = Message.newBuilder().setRoute(route).build();
        return MessageControl.send(type, spec);
    }

    public static MessageControl send(Type type, Message message) {
        return MessageControl.create(Direction.SEND, type, message);
    }

    public static MessageControl receive(Message message) {
        return MessageControl.receive(Type.MESSAGE, message);
    }

    public static MessageControl receive(Type type, Route route) {
        Message spec = Message.newBuilder().setRoute(route).build();
        return MessageControl.receive(type, spec);
    }

    public static MessageControl receive(Type type, Message message) {
        return MessageControl.create(Direction.RECEIVE, type, message);
    }

    public static MessageControl create(Direction dir, Type type, Message message) {
        if (null == dir) {
            throw new IllegalArgumentException();
        }
        if (null == type) {
            throw new IllegalArgumentException();
        }
        if (null == message) {
            throw new IllegalArgumentException();
        }
        return new MessageControl(dir, type, message);
    }

    public static WireValue toWireValue(MessageControl mc) {
        HashMap<String, Object> map = new HashMap<String, Object>(32);
        map.put(S_KEY_VERSION, 1);
        map.put(S_KEY_DIR, mc.dir.toString());
        map.put(S_KEY_TYPE, mc.type.toString());
        map.put(S_KEY_MESSAGE, mc.message);
        return WireValue.of(map);
    }

    public static MessageControl fromWireValue(WireValue value) {
        Map<WireValue, WireValue> map = value.asMap();
        int version = map.get(S_KEY_VERSION).asInt();
        switch (version) {
            default: {
                if (version >= 1) break;
                throw new IllegalArgumentException();
            }
            case 1: 
        }
        Direction dir = Direction.valueOf(map.get(S_KEY_DIR).asString());
        Type type = Type.valueOf(map.get(S_KEY_TYPE).asString());
        Message message = map.get(S_KEY_MESSAGE).asMessage();
        return new MessageControl(dir, type, message);
    }

    MessageControl(Direction dir, Type type, Message message) {
        this.dir = dir;
        this.type = type;
        this.message = message;
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{this.dir, this.type, this.message});
    }

    public int hashCode() {
        int c = this.dir.hashCode();
        c = 31 * c + this.type.hashCode();
        c = 31 * c + this.message.hashCode();
        return c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MessageControl)) {
            return false;
        }
        MessageControl b = (MessageControl)o;
        return this.dir.equals((Object)b.dir) && this.type.equals((Object)b.type) && this.message.equals(b.message);
    }

    public static enum Type {
        MESSAGE,
        ERROR,
        COMPLETE;

    }

    public static enum Direction {
        SEND,
        RECEIVE;

    }
}

