/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client;

import io.nextop.client.MessageContext;
import io.nextop.rx.MoreSchedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action0;

public final class MessageContexts {
    public static MessageContext create(Executor executor) {
        return SchedulerMessageContext.create(MoreSchedulers.serial(executor));
    }

    public static MessageContext create(Scheduler scheduler) {
        return SchedulerMessageContext.create(scheduler);
    }

    public static MessageContext create() {
        return SchedulerMessageContext.create(MoreSchedulers.serial());
    }

    private static final class SchedulerMessageContext
    implements MessageContext {
        private final Scheduler.Worker worker;
        private final Scheduler scheduler;

        static SchedulerMessageContext create(Scheduler scheduler) {
            return new SchedulerMessageContext(scheduler.createWorker());
        }

        SchedulerMessageContext(Scheduler.Worker worker) {
            this.worker = worker;
            this.scheduler = MoreSchedulers.from(worker);
        }

        @Override
        public void post(final Runnable r) {
            this.worker.schedule(new Action0(){

                public void call() {
                    r.run();
                }
            });
        }

        @Override
        public void postDelayed(final Runnable r, int delayMs) {
            this.worker.schedule(new Action0(){

                public void call() {
                    r.run();
                }
            }, (long)delayMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public Scheduler getScheduler() {
            return this.scheduler;
        }
    }
}

