/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import io.nextop.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public final class Wires {
    public static Wire io(Socket socket) throws IOException {
        socket.setTcpNoDelay(false);
        return Wires.io(socket.getInputStream(), socket.getOutputStream());
    }

    public static Wire io(@Nullable InputStream is, @Nullable OutputStream os) {
        return new IoWire(is, os);
    }

    public static InputStream inputStream(Wire wire) {
        return new WireInputStream(wire);
    }

    public static OutputStream outputStream(Wire wire) {
        return new WireOutputStream(wire);
    }

    public static Wire transfer() {
        return Wires.transfer(65536);
    }

    public static Wire transfer(int size) {
        return new TransferBuffer(size);
    }

    public static Wire.Adapter composeAdapters(Wire.Adapter ... adapters) {
        return new CompositeAdapter(adapters);
    }

    private Wires() {
    }

    private static final class CompositeAdapter
    implements Wire.Adapter {
        final Wire.Adapter[] adapters;

        CompositeAdapter(Wire.Adapter ... adapters) {
            this.adapters = adapters;
        }

        @Override
        public Wire adapt(Wire wire) throws InterruptedException, NoSuchElementException {
            Wire w = wire;
            for (Wire.Adapter adapter : this.adapters) {
                w = adapter.adapt(w);
            }
            return w;
        }
    }

    private static final class TransferBuffer
    implements Wire {
        private final byte[] tb;
        private int writeIndex = 0;
        private int readIndex = 0;
        private int available = 0;
        private boolean closed = false;

        TransferBuffer(int size) {
            this.tb = new byte[size];
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                throw new IOException();
            }
            this.closed = true;
        }

        @Override
        public synchronized void read(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            int i = 0;
            while (!this.closed && i < length) {
                int a = Math.min(length - i, this.available);
                if (0 < a) {
                    for (int j = 0; j < a; ++j) {
                        buffer[offset + i + j] = this.tb[(this.readIndex + j) % this.tb.length];
                    }
                    this.readIndex += a;
                    this.available -= a;
                    this.notifyAll();
                    if (length <= (i += a)) break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.closed) {
                throw new IOException();
            }
        }

        @Override
        public synchronized void skip(long n, int messageBoundary) throws IOException {
            long i = 0L;
            while (!this.closed && i < n) {
                long a = Math.min(n - i, (long)this.available);
                if (0L < a) {
                    this.readIndex = (int)((long)this.readIndex + a);
                    this.available = (int)((long)this.available - a);
                    this.notifyAll();
                    if (n <= (i += a)) break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.closed) {
                throw new IOException();
            }
        }

        @Override
        public synchronized void write(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            int i = 0;
            while (!this.closed && i < length) {
                int a = Math.min(length - i, this.tb.length - this.available);
                if (0 < a) {
                    for (int j = 0; j < a; ++j) {
                        this.tb[(this.writeIndex + j) % this.tb.length] = buffer[offset + i + j];
                    }
                    this.writeIndex += a;
                    this.available += a;
                    this.notifyAll();
                    if (length <= (i += a)) break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.closed) {
                throw new IOException();
            }
        }

        @Override
        public synchronized void flush() throws IOException {
        }
    }

    private static final class WireOutputStream
    extends OutputStream {
        private final Wire wire;
        private final byte[] one = new byte[1];

        WireOutputStream(Wire wire) {
            this.wire = wire;
        }

        @Override
        public void write(int b) throws IOException {
            this.one[0] = (byte)b;
            this.write(this.one, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.wire.write(b, off, len, 0);
        }

        @Override
        public void flush() throws IOException {
            this.wire.flush();
        }

        @Override
        public void close() throws IOException {
            this.wire.close();
        }
    }

    private static final class WireInputStream
    extends InputStream {
        private final Wire wire;
        private final byte[] one = new byte[1];

        WireInputStream(Wire wire) {
            this.wire = wire;
        }

        @Override
        public int read() throws IOException {
            int c = this.read(this.one, 0, 1);
            if (0 < c) {
                assert (1 == c);
                return 0xFF & this.one[0];
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int length) throws IOException {
            this.wire.read(b, off, length, 0);
            return length;
        }

        @Override
        public long skip(long n) throws IOException {
            this.wire.skip(n, 0);
            return n;
        }

        @Override
        public void close() throws IOException {
            this.wire.close();
        }
    }

    private static final class IoWire
    implements Wire {
        @Nullable
        private final InputStream is;
        @Nullable
        private final OutputStream os;
        private boolean closed = false;

        IoWire(@Nullable InputStream is, @Nullable OutputStream os) {
            this.is = is;
            this.os = os;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                throw new IOException();
            }
            this.closed = true;
            try {
                this.is.close();
            }
            finally {
                this.os.close();
            }
        }

        @Override
        public void read(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            block6: {
                if (this.closed) {
                    throw new IOException();
                }
                try {
                    if (null != this.is) {
                        int i;
                        int r;
                        for (i = 0; i < length && 0 < (r = this.is.read(buffer, offset + i, length - i)); i += r) {
                        }
                        if (i != length) {
                            throw new IOException();
                        }
                        break block6;
                    }
                    throw new IOException("No input.");
                }
                catch (IOException e) {
                    this.close();
                    throw e;
                }
            }
        }

        @Override
        public void skip(long n, int messageBoundary) throws IOException {
            block6: {
                if (this.closed) {
                    throw new IOException();
                }
                try {
                    if (null != this.is) {
                        long i;
                        long r;
                        for (i = 0L; i < n && 0L < (r = this.is.skip(n - i)); i += r) {
                        }
                        if (i != n) {
                            throw new IOException();
                        }
                        break block6;
                    }
                    throw new IOException("No input.");
                }
                catch (IOException e) {
                    this.close();
                    throw e;
                }
            }
        }

        @Override
        public void write(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            if (this.closed) {
                throw new IOException();
            }
            try {
                if (null == this.os) {
                    throw new IOException("No output.");
                }
                this.os.write(buffer, offset, length);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                if (null == this.os) {
                    throw new IOException("No output.");
                }
                this.os.flush();
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }
}

