/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.nextop.EncodedImage;
import io.nextop.Id;
import io.nextop.Message;
import io.nextop.Route;
import io.nextop.org.apache.commons.codec.binary.Base64OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class WireValue {
    final Type type;
    boolean hashCodeSet = false;
    int hashCode;
    static final int H_COMPRESSED = 128;
    static final int H_UTF8 = 1;
    static final int H_BLOB = 2;
    static final int H_INT32 = 3;
    static final int H_INT64 = 4;
    static final int H_FLOAT32 = 5;
    static final int H_FLOAT64 = 6;
    static final int H_TRUE_BOOLEAN = 7;
    static final int H_FALSE_BOOLEAN = 8;
    static final int H_MAP = 9;
    static final int H_LIST = 10;
    static final int H_INT32_LIST = 11;
    static final int H_INT64_LIST = 12;
    static final int H_FLOAT32_LIST = 13;
    static final int H_FLOAT64_LIST = 14;
    static final int H_NULL = 15;
    static final int H_MESSAGE = 16;
    static final int H_IMAGE = 17;
    static final Comparator<WireValue> COMPARATOR_STABLE = new StableComparator();
    private static final boolean WV_MAP_STRICT_TYPES = false;

    public static WireValue valueOf(ByteBuffer bb) {
        int n = bb.remaining();
        byte[] bytes = new byte[n];
        bb.get(bytes, 0, n);
        return WireValue.valueOf(bytes, 0);
    }

    public static WireValue valueOf(byte[] bytes) {
        return WireValue.valueOf(bytes, 0);
    }

    public static WireValue valueOf(byte[] bytes, int offset) {
        int h = 0xFF & bytes[offset];
        if ((h & 0x80) == 128) {
            int nb = h & 0xFFFFFF7F;
            int size = WireValue.getint(bytes, offset + 1);
            int[] offsets = new int[size + 1];
            offsets[0] = offset + 9;
            if (0 < size) {
                for (int i = 1; i <= size; ++i) {
                    offsets[i] = offsets[i - 1] + WireValue._byteSize(bytes, offsets[i - 1]);
                }
            }
            CompressionState cs = new CompressionState(bytes, offset, offsets, nb);
            return WireValue.valueOf(bytes, offsets[size], cs);
        }
        return WireValue.valueOf(bytes, offset, null);
    }

    static WireValue valueOf(byte[] bytes, int offset, CompressionState cs) {
        int h = 0xFF & bytes[offset];
        if ((h & 0x80) == 128) {
            int luti = h & 0xFFFFFF7F;
            for (int i = 1; i < cs.nb; ++i) {
                luti = luti << 8 | 0xFF & bytes[offset + i];
            }
            return WireValue.valueOf(cs.header, cs.offsets[luti], cs);
        }
        switch (h) {
            case 1: {
                return new CUtf8WireValue(bytes, offset, cs);
            }
            case 2: {
                return new CBlobWireValue(bytes, offset, cs);
            }
            case 3: {
                return new CInt32WireValue(bytes, offset, cs);
            }
            case 4: {
                return new CInt64WireValue(bytes, offset, cs);
            }
            case 5: {
                return new CFloat32WireValue(bytes, offset, cs);
            }
            case 6: {
                return new CFloat64WireValue(bytes, offset, cs);
            }
            case 7: {
                return new BooleanWireValue(true);
            }
            case 8: {
                return new BooleanWireValue(false);
            }
            case 9: {
                return new CMapWireValue(bytes, offset, cs);
            }
            case 10: {
                return new CListWireValue(bytes, offset, cs);
            }
            case 11: {
                throw new IllegalArgumentException();
            }
            case 12: {
                throw new IllegalArgumentException();
            }
            case 13: {
                throw new IllegalArgumentException();
            }
            case 14: {
                throw new IllegalArgumentException();
            }
            case 15: {
                return new NullWireValue();
            }
            case 16: {
                return new CMessageWireValue(bytes, offset, cs);
            }
            case 17: {
                return new CImageWireValue(bytes, offset, cs);
            }
        }
        throw new IllegalArgumentException("" + h);
    }

    public static WireValue of(JsonElement e) {
        if (e.isJsonPrimitive()) {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isBoolean()) {
                return WireValue.of(p.getAsBoolean());
            }
            if (p.isNumber()) {
                try {
                    long n = p.getAsLong();
                    if ((long)((int)n) == n) {
                        return WireValue.of((int)n);
                    }
                    return WireValue.of(n);
                }
                catch (NumberFormatException x) {
                    double d = p.getAsDouble();
                    if ((double)((float)d) == d) {
                        return WireValue.of((float)d);
                    }
                    return WireValue.of(d);
                }
            }
            if (p.isString()) {
                return WireValue.of(p.getAsString());
            }
            throw new IllegalArgumentException();
        }
        if (e.isJsonObject()) {
            JsonObject object = e.getAsJsonObject();
            HashMap<WireValue, WireValue> m = new HashMap<WireValue, WireValue>(4);
            for (Map.Entry oe : object.entrySet()) {
                m.put(WireValue.of((String)oe.getKey()), WireValue.of((JsonElement)oe.getValue()));
            }
            return WireValue.of(m);
        }
        if (e.isJsonArray()) {
            JsonArray array = e.getAsJsonArray();
            ArrayList<WireValue> list = new ArrayList<WireValue>(4);
            for (JsonElement ae : array) {
                list.add(WireValue.of(ae));
            }
            return WireValue.of(list);
        }
        throw new IllegalArgumentException();
    }

    public static WireValue valueOfJson(String json) {
        try {
            return WireValue.valueOfJson(new StringReader(json));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static WireValue valueOfJson(Reader jsonIn) throws IOException {
        JsonReader r = new JsonReader(jsonIn);
        try {
            WireValue wireValue = WireValue.parseJson(r);
            return wireValue;
        }
        finally {
            r.close();
        }
    }

    private static WireValue parseJson(JsonReader r) throws IOException {
        switch (r.peek()) {
            case BEGIN_OBJECT: {
                HashMap<WireValue, WireValue> map = new HashMap<WireValue, WireValue>(4);
                r.beginObject();
                while (!JsonToken.END_OBJECT.equals((Object)r.peek())) {
                    WireValue key = WireValue.of(r.nextName());
                    WireValue value = WireValue.parseJson(r);
                    map.put(key, value);
                }
                r.endObject();
                return WireValue.of(map);
            }
            case BEGIN_ARRAY: {
                ArrayList<WireValue> list = new ArrayList<WireValue>(4);
                r.beginArray();
                while (!JsonToken.END_ARRAY.equals((Object)r.peek())) {
                    WireValue value = WireValue.parseJson(r);
                    list.add(value);
                }
                r.endArray();
                return WireValue.of(list);
            }
            case STRING: {
                return WireValue.of(r.nextString());
            }
            case NUMBER: {
                try {
                    long n = r.nextLong();
                    if ((long)((int)n) == n) {
                        return WireValue.of((int)n);
                    }
                    return WireValue.of(n);
                }
                catch (NumberFormatException e) {
                    double d = r.nextDouble();
                    if ((double)((float)d) == d) {
                        return WireValue.of((float)d);
                    }
                    return WireValue.of(d);
                }
            }
            case BOOLEAN: {
                return WireValue.of(r.nextBoolean());
            }
            case NULL: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public static WireValue of(@Nullable Object value) {
        if (null == value) {
            return WireValue.of();
        }
        if (value instanceof WireValue) {
            return (WireValue)value;
        }
        if (value instanceof CharSequence) {
            return WireValue.of(value.toString());
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return WireValue.of((Integer)value);
            }
            if (value instanceof Long) {
                return WireValue.of((Long)value);
            }
            if (value instanceof Float) {
                return WireValue.of(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return WireValue.of((Double)value);
            }
            return WireValue.of(((Number)value).intValue());
        }
        if (value instanceof Boolean) {
            return WireValue.of((Boolean)value);
        }
        if (value instanceof byte[]) {
            return WireValue.of((byte[])value);
        }
        if (value instanceof Map) {
            return WireValue.of(WireValue.asWireValueMap((Map)value));
        }
        if (value instanceof Collection) {
            if (value instanceof List) {
                return WireValue.of(WireValue.asWireValueList((List)value));
            }
            return WireValue.of(WireValue.asWireValueList((Collection)value));
        }
        if (value instanceof Message) {
            return WireValue.of((Message)value);
        }
        if (value instanceof EncodedImage) {
            return WireValue.of((EncodedImage)value);
        }
        if (value instanceof JsonElement) {
            return WireValue.of((JsonElement)value);
        }
        if (value instanceof Id) {
            return WireValue.of(value.toString());
        }
        throw new IllegalArgumentException();
    }

    static WireValue of(byte[] value) {
        return WireValue.of(value, 0, value.length);
    }

    static WireValue of(byte[] value, int offset, int length) {
        return new BlobWireValue(value, offset, length);
    }

    static WireValue of(String value) {
        return new Utf8WireValue(value);
    }

    static WireValue of(int value) {
        return new NumberWireValue(value);
    }

    static WireValue of(long value) {
        return new NumberWireValue(value);
    }

    static WireValue of(float value) {
        return new NumberWireValue(Float.valueOf(value));
    }

    static WireValue of(double value) {
        return new NumberWireValue(value);
    }

    static WireValue of(boolean value) {
        return new BooleanWireValue(value);
    }

    static WireValue of(Map<WireValue, WireValue> m) {
        return new MapWireValue(m);
    }

    static WireValue of(List<WireValue> list) {
        return new ListWireValue(list);
    }

    static WireValue of(Message m) {
        return new MessageWireValue(m);
    }

    static WireValue of(EncodedImage image) {
        return new ImageWireValue(image);
    }

    static WireValue of() {
        return new NullWireValue();
    }

    WireValue(Type type) {
        this.type = type;
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = WireValue._hashCode(this);
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    static int _hashCode(WireValue value) {
        switch (value.type) {
            case UTF8: {
                return value.asString().hashCode();
            }
            case BLOB: {
                return value.asBlob().hashCode();
            }
            case INT32: {
                return value.asInt();
            }
            case INT64: {
                long n = value.asLong();
                return (int)(n ^ n >>> 32);
            }
            case FLOAT32: {
                return Float.floatToIntBits(value.asFloat());
            }
            case FLOAT64: {
                long dn = Double.doubleToLongBits(value.asDouble());
                return (int)(dn ^ dn >>> 32);
            }
            case BOOLEAN: {
                return value.asBoolean() ? 1231 : 1237;
            }
            case MAP: {
                Map<WireValue, WireValue> map = value.asMap();
                int c = 0;
                for (Map.Entry<WireValue, WireValue> e : map.entrySet()) {
                    c += WireValue._hashCode(e.getKey());
                    c += WireValue._hashCode(e.getValue());
                }
                return c;
            }
            case LIST: {
                int c = 0;
                for (WireValue v : value.asList()) {
                    c = 31 * c + WireValue._hashCode(v);
                }
                return c;
            }
            case MESSAGE: {
                return value.asMessage().hashCode();
            }
            case IMAGE: {
                return value.asImage().hashCode();
            }
            case NULL: {
                return 0;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)value.type));
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof WireValue)) {
            return false;
        }
        WireValue b = (WireValue)obj;
        return WireValue._equals(this, b);
    }

    static boolean _equals(WireValue a, WireValue b) {
        if (!a.type.equals((Object)b.type) || a.hashCode() != b.hashCode()) {
            return false;
        }
        switch (a.type) {
            case UTF8: {
                return a.asString().equals(b.asString());
            }
            case BLOB: {
                return a.asBlob().equals(b.asBlob());
            }
            case INT32: {
                return a.asInt() == b.asInt();
            }
            case INT64: {
                return a.asLong() == b.asLong();
            }
            case FLOAT32: {
                return a.asFloat() == b.asFloat();
            }
            case FLOAT64: {
                return a.asDouble() == b.asDouble();
            }
            case BOOLEAN: {
                return a.asBoolean() == b.asBoolean();
            }
            case MAP: {
                return a.asMap().equals(b.asMap());
            }
            case LIST: {
                return a.asList().equals(b.asList());
            }
            case MESSAGE: {
                return a.asMessage().equals(b.asMessage());
            }
            case IMAGE: {
                return a.asImage().equals(b.asImage());
            }
            case NULL: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.toText();
    }

    public String toDebugString() {
        return String.format("%s %s", new Object[]{this.type, this.toString()});
    }

    public String toText() {
        switch (this.type) {
            case UTF8: {
                return this.asString();
            }
            case BLOB: {
                return WireValue.base64(this.asBlob());
            }
            case INT32: {
                return String.valueOf(this.asInt());
            }
            case INT64: {
                return String.valueOf(this.asLong());
            }
            case FLOAT32: {
                return String.valueOf(this.asFloat());
            }
            case FLOAT64: {
                return String.valueOf(this.asDouble());
            }
            case BOOLEAN: {
                return String.valueOf(this.asBoolean());
            }
            case MAP: {
                return this.toJson();
            }
            case LIST: {
                return this.toJson();
            }
            case MESSAGE: {
                return "[message]";
            }
            case IMAGE: {
                return WireValue.base64(this.asImage().toBuffer());
            }
            case NULL: {
                return "";
            }
        }
        throw new IllegalArgumentException();
    }

    public String toJson() {
        StringWriter sw = new StringWriter();
        try {
            this.toJson(sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void toJson(Writer jsonOut) throws IOException {
        JsonWriter w = new JsonWriter(jsonOut);
        try {
            WireValue.toJson(this, w);
        }
        finally {
            w.close();
        }
    }

    static void toJson(WireValue value, JsonWriter w) throws IOException {
        switch (value.getType()) {
            case UTF8: {
                w.value(value.asString());
                break;
            }
            case BLOB: {
                w.value(WireValue.base64(value.asBlob()));
                break;
            }
            case INT32: {
                w.value((long)value.asInt());
                break;
            }
            case INT64: {
                w.value(value.asLong());
                break;
            }
            case FLOAT32: {
                w.value((double)value.asFloat());
                break;
            }
            case FLOAT64: {
                w.value(value.asDouble());
                break;
            }
            case BOOLEAN: {
                w.value(value.asBoolean());
                break;
            }
            case MAP: {
                w.beginObject();
                Map<WireValue, WireValue> map = value.asMap();
                for (WireValue key : WireValue.stableKeys(map)) {
                    w.name(key.toText());
                    WireValue.toJson(map.get(key), w);
                }
                w.endObject();
                break;
            }
            case LIST: {
                w.beginArray();
                for (WireValue v : value.asList()) {
                    WireValue.toJson(v, w);
                }
                w.endArray();
                break;
            }
            case MESSAGE: {
                w.value("[message]");
                break;
            }
            case IMAGE: {
                w.value("[image]");
                break;
            }
            case NULL: {
                w.nullValue();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    static String base64(ByteBuffer bytes) {
        byte[] b64;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.remaining() * 4 / 3);
            Base64OutputStream b64os = new Base64OutputStream((OutputStream)baos, true, 0, null);
            WritableByteChannel channel = Channels.newChannel((OutputStream)b64os);
            channel.write(bytes);
            channel.close();
            b64 = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new String(b64, Charsets.UTF_8);
    }

    static byte[] header(int nb, int v) {
        switch (nb) {
            case 1: {
                return new byte[]{(byte)(v & 0xFF)};
            }
            case 2: {
                return new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
            }
            case 3: {
                return new byte[]{(byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
            }
        }
        throw new IllegalArgumentException();
    }

    static int listh(List<WireValue> list) {
        return 10;
    }

    static int byteSize(byte[] bytes, int offset, CompressionState cs) {
        int h = 0xFF & bytes[offset];
        if ((h & 0x80) == 128) {
            return cs.nb;
        }
        return WireValue._byteSize(bytes, offset);
    }

    static int _byteSize(byte[] bytes, int offset) {
        int h = 0xFF & bytes[offset];
        switch (h) {
            case 1: {
                return 5 + WireValue.getint(bytes, offset + 1);
            }
            case 2: {
                return 5 + WireValue.getint(bytes, offset + 1);
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 9;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 5 + WireValue.getint(bytes, offset + 1);
            }
            case 10: {
                return 9 + WireValue.getint(bytes, offset + 5);
            }
            case 11: {
                throw new IllegalArgumentException();
            }
            case 12: {
                throw new IllegalArgumentException();
            }
            case 13: {
                throw new IllegalArgumentException();
            }
            case 14: {
                throw new IllegalArgumentException();
            }
            case 16: {
                return 5 + WireValue.getint(bytes, offset + 1);
            }
            case 17: {
                return 5 + WireValue.getint(bytes, offset + 1);
            }
            case 15: {
                return 1;
            }
        }
        throw new IllegalArgumentException("" + h);
    }

    public void toBytes(ByteBuffer bb) {
        int bytes;
        int i;
        Lb lb = new Lb();
        lb.init(this);
        if (lb.opt()) {
            bb.put((byte)(0x80 | lb.lutNb));
            bb.putInt(lb.lut.size());
            bb.putInt(0);
            i = bb.position();
            for (Lb.S s : lb.lut) {
                WireValue._toBytes(s.value, lb, bb);
            }
            bytes = bb.position() - i;
            bb.putInt(i - 4, bytes);
        }
        i = bb.position();
        WireValue.toBytes(this, lb, bb);
        bytes = bb.position() - i;
    }

    private static void toBytes(WireValue value, Lb lb, ByteBuffer bb) {
        int luti = lb.luti(value);
        if (0 <= luti) {
            byte[] header = WireValue.header(lb.lutNb, luti);
            header[0] = (byte)(header[0] | 0x80);
            bb.put(header);
        } else {
            WireValue._toBytes(value, lb, bb);
        }
    }

    private static void _toBytes(WireValue value, Lb lb, ByteBuffer bb) {
        switch (value.getType()) {
            case MAP: {
                bb.put((byte)9);
                bb.putInt(0);
                int i = bb.position();
                Map<WireValue, WireValue> m = value.asMap();
                List<WireValue> keys = WireValue.stableKeys(m);
                WireValue.toBytes(WireValue.of(keys), lb, bb);
                List<WireValue> values = WireValue.stableValues(m, keys);
                WireValue.toBytes(WireValue.of(values), lb, bb);
                int bytes = bb.position() - i;
                bb.putInt(i - 4, bytes);
                break;
            }
            case LIST: {
                List<WireValue> list = value.asList();
                int listh = WireValue.listh(list);
                if (10 == listh) {
                    bb.put((byte)10);
                    bb.putInt(list.size());
                    bb.putInt(0);
                    int i = bb.position();
                    for (WireValue v : value.asList()) {
                        WireValue.toBytes(v, lb, bb);
                    }
                    int bytes = bb.position() - i;
                    bb.putInt(i - 4, bytes);
                    break;
                }
                bb.put((byte)listh);
                bb.putInt(list.size());
                bb.putInt(0);
                int i = bb.position();
                switch (listh) {
                    case 11: {
                        for (WireValue v : value.asList()) {
                            bb.putInt(v.asInt());
                        }
                        break;
                    }
                    case 12: {
                        for (WireValue v : value.asList()) {
                            bb.putLong(v.asLong());
                        }
                        break;
                    }
                    case 13: {
                        for (WireValue v : value.asList()) {
                            bb.putFloat(v.asFloat());
                        }
                        break;
                    }
                    case 14: {
                        for (WireValue v : value.asList()) {
                            bb.putDouble(v.asDouble());
                        }
                        break;
                    }
                }
                int bytes = bb.position() - i;
                bb.putInt(i - 4, bytes);
                break;
            }
            case BLOB: {
                ByteBuffer b = value.asBlob();
                bb.put((byte)2);
                bb.putInt(b.remaining());
                bb.put(b);
                break;
            }
            case UTF8: {
                byte[] b = value.asString().getBytes(Charsets.UTF_8);
                bb.put((byte)1);
                bb.putInt(b.length);
                bb.put(b);
                break;
            }
            case INT32: {
                bb.put((byte)3);
                bb.putInt(value.asInt());
                break;
            }
            case INT64: {
                bb.put((byte)4);
                bb.putLong(value.asLong());
                break;
            }
            case FLOAT32: {
                bb.put((byte)5);
                bb.putFloat(value.asFloat());
                break;
            }
            case FLOAT64: {
                bb.put((byte)6);
                bb.putDouble(value.asDouble());
                break;
            }
            case BOOLEAN: {
                bb.put((byte)(value.asBoolean() ? 7 : 8));
                break;
            }
            case MESSAGE: {
                bb.put((byte)16);
                MessageCodec.toBytes(value.asMessage(), lb, bb);
                break;
            }
            case IMAGE: {
                bb.put((byte)17);
                ImageCodec.toBytes(value.asImage(), lb, bb);
                break;
            }
            case NULL: {
                bb.put((byte)15);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    static List<WireValue> stableKeys(Map<WireValue, WireValue> m) {
        ArrayList<WireValue> keys = new ArrayList<WireValue>(m.keySet());
        Collections.sort(keys, COMPARATOR_STABLE);
        return keys;
    }

    static List<WireValue> stableValues(Map<WireValue, WireValue> m, List<WireValue> keys) {
        ArrayList<WireValue> values = new ArrayList<WireValue>(keys.size());
        for (WireValue key : keys) {
            values.add(m.get(key));
        }
        return values;
    }

    public Id asId() {
        return Id.valueOf(this.asString());
    }

    public abstract String asString();

    public abstract int asInt();

    public abstract long asLong();

    public abstract float asFloat();

    public abstract double asDouble();

    public abstract boolean asBoolean();

    public abstract List<WireValue> asList();

    public abstract Map<WireValue, WireValue> asMap();

    public abstract ByteBuffer asBlob();

    public abstract Message asMessage();

    public abstract EncodedImage asImage();

    public static boolean isWireValues(Collection<?> values) {
        for (Object value : values) {
            if (value instanceof WireValue) continue;
            return false;
        }
        return true;
    }

    private static Map<WireValue, WireValue> asWireValueMap(Map<?, ?> map) {
        if (WireValue.isWireValues(map.keySet())) {
            return Maps.transformValues(map, (Function)new Function<Object, WireValue>(){

                public WireValue apply(@Nullable Object input) {
                    return WireValue.of(input);
                }
            });
        }
        HashMap<WireValue, WireValue> t = new HashMap<WireValue, WireValue>(map.size());
        for (Map.Entry<?, ?> e : map.entrySet()) {
            WireValue j = t.put(WireValue.of(e.getKey()), WireValue.of(e.getValue()));
            if (null == j) continue;
            throw new IllegalStateException("Map to WireValue is not a bijection.");
        }
        return t;
    }

    private static List<WireValue> asWireValueList(List<?> list) {
        return Lists.transform(list, (Function)new Function<Object, WireValue>(){

            public WireValue apply(@Nullable Object input) {
                return WireValue.of(input);
            }
        });
    }

    private static List<WireValue> asWireValueList(Collection<?> collection) {
        ArrayList<WireValue> wireValueList = new ArrayList<WireValue>(collection.size());
        for (Object value : collection) {
            wireValueList.add(WireValue.of(value));
        }
        return wireValueList;
    }

    private static Collection<WireValue> asWireValueCollection(Collection<?> collection) {
        return Collections2.transform(collection, (Function)new Function<Object, WireValue>(){

            public WireValue apply(@Nullable Object input) {
                return WireValue.of(input);
            }
        });
    }

    private static WireValue duckCoerce(@Nullable Object arg) {
        WireValue value = WireValue.of(arg);
        if (value != arg) {
            // empty if block
        }
        return value;
    }

    private static Map<WireValue, WireValue> duckMap(final Map<WireValue, WireValue> map) {
        return new ForwardingMap<WireValue, WireValue>(){

            protected Map<WireValue, WireValue> delegate() {
                return map;
            }

            public WireValue get(@Nullable Object key) {
                return (WireValue)super.get((Object)WireValue.duckCoerce(key));
            }

            public WireValue remove(Object object) {
                return (WireValue)super.remove((Object)WireValue.duckCoerce(object));
            }

            public boolean containsKey(@Nullable Object key) {
                return super.containsKey((Object)WireValue.duckCoerce(key));
            }

            public boolean containsValue(@Nullable Object value) {
                return super.containsValue((Object)WireValue.duckCoerce(value));
            }
        };
    }

    private static List<WireValue> duckList(final List<WireValue> list) {
        return new ForwardingList<WireValue>(){

            protected List<WireValue> delegate() {
                return list;
            }

            public boolean remove(Object object) {
                return super.remove((Object)WireValue.duckCoerce(object));
            }

            public boolean removeAll(Collection<?> collection) {
                return super.removeAll(WireValue.asWireValueCollection(collection));
            }

            public boolean contains(Object object) {
                return super.contains((Object)WireValue.duckCoerce(object));
            }

            public boolean containsAll(Collection<?> collection) {
                return super.containsAll(WireValue.asWireValueCollection(collection));
            }

            public int indexOf(Object element) {
                return super.indexOf((Object)WireValue.duckCoerce(element));
            }

            public int lastIndexOf(Object element) {
                return super.lastIndexOf((Object)WireValue.duckCoerce(element));
            }
        };
    }

    public static int getint(byte[] bytes, int offset) {
        return (0xFF & bytes[offset]) << 24 | (0xFF & bytes[offset + 1]) << 16 | (0xFF & bytes[offset + 2]) << 8 | 0xFF & bytes[offset + 3];
    }

    public static long getlong(byte[] bytes, int offset) {
        return (0xFFL & (long)bytes[offset]) << 56 | (0xFFL & (long)bytes[offset + 1]) << 48 | (0xFFL & (long)bytes[offset + 2]) << 40 | (0xFFL & (long)bytes[offset + 3]) << 32 | (0xFFL & (long)bytes[offset + 4]) << 24 | (0xFFL & (long)bytes[offset + 5]) << 16 | (0xFFL & (long)bytes[offset + 6]) << 8 | 0xFFL & (long)bytes[offset + 7];
    }

    public static void putint(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)(value >>> 24);
        bytes[offset + 1] = (byte)(value >>> 16);
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static void putlong(byte[] bytes, int offset, long value) {
        bytes[offset] = (byte)(value >>> 56);
        bytes[offset + 1] = (byte)(value >>> 48);
        bytes[offset + 2] = (byte)(value >>> 40);
        bytes[offset + 3] = (byte)(value >>> 32);
        bytes[offset + 4] = (byte)(value >>> 24);
        bytes[offset + 5] = (byte)(value >>> 16);
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
    }

    private static final class MessageCodec {
        private MessageCodec() {
        }

        public static Message valueOf(byte[] bytes, int offset, CompressionState cs) {
            int c = offset;
            Id id = IdCodec.valueOf(bytes, c += 4);
            Id groupId = IdCodec.valueOf(bytes, c += 32);
            int groupPriority = WireValue.getint(bytes, c += 32);
            Route route = Route.valueOf(WireValue.valueOf(bytes, c += 4, cs).asString());
            c += 5 + WireValue.getint(bytes, c + 1);
            Map<WireValue, WireValue> headers = WireValue.valueOf(bytes, c, cs).asMap();
            c += 5 + WireValue.getint(bytes, c + 1);
            Map<WireValue, WireValue> parameters = WireValue.valueOf(bytes, c, cs).asMap();
            return new Message(id, groupId, groupPriority, route, headers, parameters);
        }

        public static void toBytes(Message message, Lb lb, ByteBuffer bb) {
            bb.putInt(0);
            int i = bb.position();
            IdCodec.toBytes(message.id, bb);
            IdCodec.toBytes(message.groupId, bb);
            bb.putInt(message.groupPriority);
            WireValue._toBytes(WireValue.of(message.route.toString()), lb, bb);
            WireValue._toBytes(WireValue.of(message.headers), lb, bb);
            WireValue._toBytes(WireValue.of(message.parameters), lb, bb);
            int bytes = bb.position() - i;
            bb.putInt(i - 4, bytes);
        }
    }

    private static final class ImageCodec {
        static final int H_F_WEBP = 1;
        static final int H_F_JPEG = 2;
        static final int H_F_PNG = 3;
        static final int H_O_REAR_FACING = 1;
        static final int H_O_FRONT_FACING = 2;

        private ImageCodec() {
        }

        public static EncodedImage valueOf(byte[] bytes, int offset) {
            EncodedImage.Orientation orientation;
            EncodedImage.Format format;
            int c = offset;
            switch (0xFF & bytes[c += 4]) {
                case 1: {
                    format = EncodedImage.Format.WEBP;
                    break;
                }
                case 2: {
                    format = EncodedImage.Format.JPEG;
                    break;
                }
                case 3: {
                    format = EncodedImage.Format.PNG;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (0xFF & bytes[++c]) {
                case 1: {
                    orientation = EncodedImage.Orientation.REAR_FACING;
                    break;
                }
                case 2: {
                    orientation = EncodedImage.Orientation.FRONT_FACING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            int width = WireValue.getint(bytes, ++c);
            int height = WireValue.getint(bytes, c += 4);
            int length = WireValue.getint(bytes, c += 4);
            return new EncodedImage(format, orientation, width, height, bytes, c += 4, length);
        }

        public static void toBytes(EncodedImage image, Lb lb, ByteBuffer bb) {
            bb.putInt(0);
            int i = bb.position();
            switch (image.format) {
                case WEBP: {
                    bb.put((byte)1);
                    break;
                }
                case JPEG: {
                    bb.put((byte)2);
                    break;
                }
                case PNG: {
                    bb.put((byte)3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (image.orientation) {
                case REAR_FACING: {
                    bb.put((byte)1);
                    break;
                }
                case FRONT_FACING: {
                    bb.put((byte)2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            bb.putInt(image.width);
            bb.putInt(image.height);
            bb.putInt(image.length);
            bb.put(image.bytes, image.offset, image.length);
            int bytes = bb.position() - i;
            bb.putInt(i - 4, bytes);
        }
    }

    private static final class IdCodec {
        static final int LENGTH = 32;

        private IdCodec() {
        }

        public static Id valueOf(byte[] bytes, int offset) {
            return new Id(bytes, offset);
        }

        public static void toBytes(Id id, ByteBuffer bb) {
            bb.put(id.bytes, id.offset, 32);
        }
    }

    private static class NullWireValue
    extends WireValue {
        NullWireValue() {
            super(Type.NULL);
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImageWireValue
    extends WireValue {
        final EncodedImage image;

        ImageWireValue(EncodedImage image) {
            super(Type.IMAGE);
            this.image = image;
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            return this.image;
        }
    }

    private static class MessageWireValue
    extends WireValue {
        final Message message;

        MessageWireValue(Message message) {
            super(Type.MESSAGE);
            this.message = message;
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            return this.message;
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MapWireValue
    extends WireValue {
        final Map<WireValue, WireValue> value;

        MapWireValue(Map<WireValue, WireValue> value) {
            super(Type.MAP);
            this.value = WireValue.duckMap(value);
        }

        @Override
        public String asString() {
            return this.value.toString();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            return this.value;
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ListWireValue
    extends WireValue {
        final List<WireValue> value;

        ListWireValue(List<WireValue> value) {
            super(Type.LIST);
            this.value = WireValue.duckList(value);
        }

        @Override
        public String asString() {
            return this.value.toString();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            return this.value;
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BooleanWireValue
    extends WireValue {
        final boolean value;

        BooleanWireValue(boolean value) {
            super(Type.BOOLEAN);
            this.value = value;
        }

        @Override
        public String asString() {
            return String.valueOf(this.value);
        }

        @Override
        public int asInt() {
            return this.value ? 1 : 0;
        }

        @Override
        public long asLong() {
            return this.value ? 1L : 0L;
        }

        @Override
        public float asFloat() {
            return this.value ? 1.0f : 0.0f;
        }

        @Override
        public double asDouble() {
            return this.value ? 1.0 : 0.0;
        }

        @Override
        public boolean asBoolean() {
            return this.value;
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NumberWireValue
    extends WireValue {
        final Number value;

        static Type type(Number n) {
            if (n instanceof Integer) {
                return Type.INT32;
            }
            if (n instanceof Long) {
                return Type.INT64;
            }
            if (n instanceof Float) {
                return Type.FLOAT32;
            }
            if (n instanceof Double) {
                return Type.FLOAT64;
            }
            throw new IllegalArgumentException();
        }

        NumberWireValue(Number value) {
            super(NumberWireValue.type(value));
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value.toString();
        }

        @Override
        public int asInt() {
            return this.value.intValue();
        }

        @Override
        public long asLong() {
            return this.value.longValue();
        }

        @Override
        public float asFloat() {
            return this.value.floatValue();
        }

        @Override
        public double asDouble() {
            return this.value.doubleValue();
        }

        @Override
        public boolean asBoolean() {
            return 0.0f != this.value.floatValue();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Utf8WireValue
    extends WireValue {
        final String value;

        Utf8WireValue(String value) {
            super(Type.UTF8);
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value;
        }

        @Override
        public int asInt() {
            return Integer.parseInt(this.value);
        }

        @Override
        public long asLong() {
            return Long.parseLong(this.value);
        }

        @Override
        public float asFloat() {
            return Float.parseFloat(this.value);
        }

        @Override
        public double asDouble() {
            return Double.parseDouble(this.value);
        }

        @Override
        public boolean asBoolean() {
            return Boolean.parseBoolean(this.value);
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            return ByteBuffer.wrap(this.value.getBytes(Charsets.UTF_8));
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BlobWireValue
    extends WireValue {
        final byte[] value;
        final int offset;
        final int length;

        BlobWireValue(byte[] value, int offset, int length) {
            super(Type.BLOB);
            this.value = value;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public String asString() {
            return BlobWireValue.base64(ByteBuffer.wrap(this.value, this.offset, this.length));
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            return ByteBuffer.wrap(this.value, this.offset, this.length);
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    static final class StableComparator
    implements Comparator<WireValue> {
        StableComparator() {
        }

        @Override
        public int compare(WireValue a, WireValue b) {
            Type ta = a.getType();
            Type tb = b.getType();
            int d = ta.ordinal() - tb.ordinal();
            if (0 != d) {
                return d;
            }
            assert (ta.equals((Object)tb));
            switch (ta) {
                case MAP: {
                    Map<WireValue, WireValue> amap = a.asMap();
                    Map<WireValue, WireValue> bmap = b.asMap();
                    d = amap.size() - bmap.size();
                    if (0 != d) {
                        return d;
                    }
                    List<WireValue> akeys = WireValue.stableKeys(amap);
                    List<WireValue> bkeys = WireValue.stableKeys(bmap);
                    d = this.compare(WireValue.of(akeys), WireValue.of(bkeys));
                    if (0 != d) {
                        return d;
                    }
                    return this.compare(WireValue.of(WireValue.stableValues(amap, akeys)), WireValue.of(WireValue.stableValues(bmap, bkeys)));
                }
                case LIST: {
                    List<WireValue> alist = a.asList();
                    List<WireValue> blist = b.asList();
                    int n = alist.size();
                    int m = blist.size();
                    d = n - m;
                    if (0 != d) {
                        return d;
                    }
                    for (int i = 0; i < n; ++i) {
                        d = this.compare(alist.get(i), blist.get(i));
                        if (0 == d) continue;
                        return d;
                    }
                    return 0;
                }
                case BLOB: {
                    ByteBuffer abytes = a.asBlob();
                    ByteBuffer bbytes = b.asBlob();
                    int n = abytes.remaining();
                    int m = bbytes.remaining();
                    d = n - m;
                    if (0 != d) {
                        return d;
                    }
                    for (int i = 0; i < n; ++i) {
                        d = (0xFF & abytes.get(i)) - (0xFF & bbytes.get(i));
                        if (0 == d) continue;
                        return d;
                    }
                    return 0;
                }
                case UTF8: {
                    return a.asString().compareTo(b.asString());
                }
                case INT32: {
                    int ai = a.asInt();
                    int bi = b.asInt();
                    if (ai < bi) {
                        return -1;
                    }
                    if (bi < ai) {
                        return 1;
                    }
                    return 0;
                }
                case INT64: {
                    long an = a.asLong();
                    long bn = b.asLong();
                    if (an < bn) {
                        return -1;
                    }
                    if (bn < an) {
                        return 1;
                    }
                    return 0;
                }
                case FLOAT32: {
                    return Float.compare(a.asFloat(), b.asFloat());
                }
                case FLOAT64: {
                    return Double.compare(a.asDouble(), b.asDouble());
                }
                case MESSAGE: {
                    return a.asMessage().id.compareTo(b.asMessage().id);
                }
                case IMAGE: {
                    ByteBuffer abytes = a.asImage().toBuffer();
                    ByteBuffer bbytes = b.asImage().toBuffer();
                    int n = abytes.remaining();
                    int m = bbytes.remaining();
                    d = n - m;
                    if (0 != d) {
                        return d;
                    }
                    for (int i = 0; i < n; ++i) {
                        d = (0xFF & abytes.get(i)) - (0xFF & bbytes.get(i));
                        if (0 == d) continue;
                        return d;
                    }
                    return 0;
                }
                case NULL: {
                    return 0;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    static class Lb {
        Map<WireValue, S> stats = new HashMap<WireValue, S>(4);
        List<S> lut = new ArrayList<S>(4);
        int lutNb = 0;
        int[] sizes = new int[]{0, 16, 256, 65536, 0x1000000};

        Lb() {
        }

        int luti(WireValue value) {
            S s = this.stats.get(value);
            if (null != s) {
                return s.luti;
            }
            return -1;
        }

        void init(WireValue value) {
            this.expand(value, 0, 0);
        }

        int expand(WireValue value, int d, int i) {
            switch (value.getType()) {
                case MAP: {
                    this.expandOne(value, d, i);
                    ++i;
                    Map<WireValue, WireValue> m = value.asMap();
                    List<WireValue> keys = WireValue.stableKeys(m);
                    i = this.expand(WireValue.of(keys), d + 1, i);
                    List<WireValue> values = WireValue.stableValues(m, keys);
                    i = this.expand(WireValue.of(values), d + 1, i);
                    break;
                }
                case LIST: {
                    this.expandOne(value, d, i);
                    ++i;
                    for (WireValue v : value.asList()) {
                        i = this.expand(v, d + 1, i);
                    }
                    break;
                }
                default: {
                    this.expandOne(value, d, i);
                    ++i;
                }
            }
            return i;
        }

        void expandOne(WireValue value, int d, int i) {
            S s = this.stats.get(value);
            if (null == s) {
                s = new S();
                s.value = value;
                this.stats.put(value, s);
            }
            ++s.count;
            s.maxd = Math.max(s.maxd, d);
            s.maxi = Math.max(s.maxi, i);
        }

        boolean opt() {
            int nb = this.estimateLutNb();
            if (nb <= 0) {
                return false;
            }
            ArrayList<S> rs = new ArrayList<S>(this.stats.values());
            Collections.sort(rs, new Comparator<S>(){

                @Override
                public int compare(S a, S b) {
                    if (a == b) {
                        return 0;
                    }
                    if (a.maxd < b.maxd) {
                        return -1;
                    }
                    if (b.maxd < a.maxd) {
                        return 1;
                    }
                    if (a.maxi < b.maxi) {
                        return -1;
                    }
                    if (b.maxi < a.maxi) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (S s : rs) {
                if (!this.include(s, nb)) continue;
                s.luti = this.lut.size();
                this.lut.add(s);
                this.collapse(s.value);
            }
            this.lutNb = this.nb(this.lut.size());
            return true;
        }

        void collapse(WireValue value) {
            switch (value.getType()) {
                case MAP: {
                    this.collapseOne(value);
                    Map<WireValue, WireValue> m = value.asMap();
                    List<WireValue> keys = WireValue.stableKeys(m);
                    this.collapse(WireValue.of(keys));
                    List<WireValue> values = WireValue.stableValues(m, keys);
                    this.collapse(WireValue.of(values));
                    break;
                }
                case LIST: {
                    this.collapseOne(value);
                    for (WireValue v : value.asList()) {
                        this.collapse(v);
                    }
                    break;
                }
                default: {
                    this.collapseOne(value);
                }
            }
        }

        void collapseOne(WireValue value) {
            S s = this.stats.get(value);
            assert (null != s);
            --s.count;
        }

        int nb(int c) {
            int nb = 0;
            while (this.sizes[nb] < c) {
                ++nb;
            }
            return nb;
        }

        int estimateLutNb() {
            int pnb;
            int nb = this.nb(this.count(1));
            if (nb == this.sizes.length) {
                return -1;
            }
            do {
                pnb = nb;
            } while ((nb = this.nb(this.count(nb))) < pnb);
            return pnb;
        }

        int count(int nb) {
            int c = 0;
            for (S s : this.stats.values()) {
                if (!this.include(s, nb)) continue;
                ++c;
            }
            return c;
        }

        boolean include(S s, int nb) {
            int b = this.quickLowerSize(s.value.getType());
            return nb * s.count + b < s.count * b;
        }

        int quickLowerSize(Type type) {
            switch (type) {
                case MAP: {
                    return 12;
                }
                case LIST: {
                    return 8;
                }
                case BLOB: {
                    return 8;
                }
                case UTF8: {
                    return 8;
                }
                case INT32: {
                    return 4;
                }
                case INT64: {
                    return 8;
                }
                case FLOAT32: {
                    return 4;
                }
                case FLOAT64: {
                    return 8;
                }
                case BOOLEAN: {
                    return 1;
                }
                case MESSAGE: {
                    return 1;
                }
                case IMAGE: {
                    return 1;
                }
                case NULL: {
                    return 1;
                }
            }
            throw new IllegalArgumentException();
        }

        static class S {
            WireValue value;
            int count;
            int maxd = -1;
            int maxi = -1;
            int luti = -1;

            S() {
            }
        }
    }

    private static class CompressionState {
        byte[] header;
        int offset;
        int[] offsets;
        int nb;

        CompressionState(byte[] header, int offset, int[] offsets, int nb) {
            this.header = header;
            this.offset = offset;
            this.offsets = offsets;
            this.nb = nb;
        }
    }

    private static class CImageWireValue
    extends CompressedWireValue {
        CImageWireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.IMAGE, bytes, offset, cs);
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            return ImageCodec.valueOf(this.bytes, this.offset + 1);
        }
    }

    private static class CMessageWireValue
    extends CompressedWireValue {
        CMessageWireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.MESSAGE, bytes, offset, cs);
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            return MessageCodec.valueOf(this.bytes, this.offset + 1, this.cs);
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CFloat64WireValue
    extends CompressedWireValue {
        CFloat64WireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.FLOAT64, bytes, offset, cs);
        }

        @Override
        public String asString() {
            return String.valueOf(this.asDouble());
        }

        @Override
        public int asInt() {
            return (int)this.asDouble();
        }

        @Override
        public long asLong() {
            return (long)this.asDouble();
        }

        @Override
        public float asFloat() {
            return (float)this.asDouble();
        }

        @Override
        public double asDouble() {
            return Double.longBitsToDouble(CFloat64WireValue.getlong(this.bytes, this.offset + 1));
        }

        @Override
        public boolean asBoolean() {
            return 0.0 != this.asDouble();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CFloat32WireValue
    extends CompressedWireValue {
        CFloat32WireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.FLOAT32, bytes, offset, cs);
        }

        @Override
        public String asString() {
            return String.valueOf(this.asFloat());
        }

        @Override
        public int asInt() {
            return (int)this.asFloat();
        }

        @Override
        public long asLong() {
            return (long)this.asFloat();
        }

        @Override
        public float asFloat() {
            return Float.intBitsToFloat(CFloat32WireValue.getint(this.bytes, this.offset + 1));
        }

        @Override
        public double asDouble() {
            return this.asFloat();
        }

        @Override
        public boolean asBoolean() {
            return 0.0f != this.asFloat();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CInt64WireValue
    extends CompressedWireValue {
        CInt64WireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.INT64, bytes, offset, cs);
        }

        @Override
        public String asString() {
            return String.valueOf(this.asLong());
        }

        @Override
        public int asInt() {
            return (int)this.asLong();
        }

        @Override
        public long asLong() {
            return CInt64WireValue.getlong(this.bytes, this.offset + 1);
        }

        @Override
        public float asFloat() {
            return this.asLong();
        }

        @Override
        public double asDouble() {
            return this.asLong();
        }

        @Override
        public boolean asBoolean() {
            return 0L != this.asLong();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CInt32WireValue
    extends CompressedWireValue {
        CInt32WireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.INT32, bytes, offset, cs);
        }

        @Override
        public String asString() {
            return String.valueOf(this.asInt());
        }

        @Override
        public int asInt() {
            return CInt32WireValue.getint(this.bytes, this.offset + 1);
        }

        @Override
        public long asLong() {
            return this.asInt();
        }

        @Override
        public float asFloat() {
            return this.asInt();
        }

        @Override
        public double asDouble() {
            return this.asInt();
        }

        @Override
        public boolean asBoolean() {
            return 0 != this.asInt();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CListWireValue
    extends CompressedWireValue {
        CListWireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.LIST, bytes, offset, cs);
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            AbstractList<WireValue> list = new AbstractList<WireValue>(){
                int n;
                int[] offsets;
                int offseti;
                {
                    this.n = WireValue.getint(CListWireValue.this.bytes, CListWireValue.this.offset + 1);
                    this.offsets = null;
                    this.offseti = 0;
                }

                @Override
                public int size() {
                    return this.n;
                }

                @Override
                public WireValue get(int index) {
                    if (index < 0 || this.n <= index) {
                        throw new IndexOutOfBoundsException();
                    }
                    this.fillOffsets(index);
                    return WireValue.valueOf(CListWireValue.this.bytes, this.offsets[index], CListWireValue.this.cs);
                }

                void fillOffsets(int j) {
                    if (this.offseti <= j) {
                        int i;
                        if (null == this.offsets) {
                            this.offsets = new int[this.n];
                            this.offsets[0] = CListWireValue.this.offset + 9;
                            this.offseti = 1;
                        }
                        for (i = this.offseti; i <= j; ++i) {
                            this.offsets[i] = this.offsets[i - 1] + WireValue.byteSize(CListWireValue.this.bytes, this.offsets[i - 1], CListWireValue.this.cs);
                        }
                        this.offseti = i;
                    }
                }
            };
            return WireValue.duckList(list);
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CMapWireValue
    extends CompressedWireValue {
        CMapWireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.MAP, bytes, offset, cs);
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            AbstractMap<WireValue, WireValue> map = new AbstractMap<WireValue, WireValue>(){
                int ds;
                List<WireValue> keys;
                List<WireValue> values;
                int n;
                {
                    this.ds = CMapWireValue.this.offset + 5;
                    this.keys = WireValue.valueOf(CMapWireValue.this.bytes, this.ds, CMapWireValue.this.cs).asList();
                    this.values = WireValue.valueOf(CMapWireValue.this.bytes, this.ds + WireValue.byteSize(CMapWireValue.this.bytes, this.ds, CMapWireValue.this.cs), CMapWireValue.this.cs).asList();
                    this.n = this.keys.size();
                }

                @Override
                public Set<Map.Entry<WireValue, WireValue>> entrySet() {
                    return new AbstractSet<Map.Entry<WireValue, WireValue>>(){

                        @Override
                        public int size() {
                            return n;
                        }

                        @Override
                        public Iterator<Map.Entry<WireValue, WireValue>> iterator() {
                            return new Iterator<Map.Entry<WireValue, WireValue>>(){
                                int i = 0;

                                @Override
                                public boolean hasNext() {
                                    return this.i < n;
                                }

                                @Override
                                public Map.Entry<WireValue, WireValue> next() {
                                    int j = this.i++;
                                    return new AbstractMap.SimpleImmutableEntry<WireValue, WireValue>(keys.get(j), values.get(j));
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                    };
                }
            };
            return WireValue.duckMap(map);
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CBlobWireValue
    extends CompressedWireValue {
        CBlobWireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.BLOB, bytes, offset, cs);
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            int length = CBlobWireValue.getint(this.bytes, this.offset + 1);
            return ByteBuffer.wrap(this.bytes, this.offset + 5, length);
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CUtf8WireValue
    extends CompressedWireValue {
        CUtf8WireValue(byte[] bytes, int offset, CompressionState cs) {
            super(Type.UTF8, bytes, offset, cs);
        }

        @Override
        public String asString() {
            int length = CUtf8WireValue.getint(this.bytes, this.offset + 1);
            return new String(this.bytes, this.offset + 5, length, Charsets.UTF_8);
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WireValue> asList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<WireValue, WireValue> asMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer asBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Message asMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncodedImage asImage() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class CompressedWireValue
    extends WireValue {
        byte[] bytes;
        int offset;
        CompressionState cs;

        CompressedWireValue(Type type, byte[] bytes, int offset, CompressionState cs) {
            super(type);
            this.bytes = bytes;
            this.offset = offset;
            this.cs = cs;
        }
    }

    public static enum Type {
        UTF8,
        BLOB,
        INT32,
        INT64,
        FLOAT32,
        FLOAT64,
        BOOLEAN,
        MAP,
        LIST,
        MESSAGE,
        IMAGE,
        NULL;

    }
}

