/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.net.HttpHeaders;
import com.google.common.net.MediaType;
import io.nextop.EncodedImage;
import io.nextop.Id;
import io.nextop.Path;
import io.nextop.Route;
import io.nextop.WireValue;
import io.nextop.org.apache.http.Header;
import io.nextop.org.apache.http.HttpEntity;
import io.nextop.org.apache.http.HttpHost;
import io.nextop.org.apache.http.HttpRequest;
import io.nextop.org.apache.http.HttpResponse;
import io.nextop.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import io.nextop.org.apache.http.client.methods.HttpGet;
import io.nextop.org.apache.http.client.methods.HttpPost;
import io.nextop.org.apache.http.client.methods.HttpPut;
import io.nextop.org.apache.http.client.methods.HttpUriRequest;
import io.nextop.org.apache.http.client.utils.URIBuilder;
import io.nextop.org.apache.http.entity.ByteArrayEntity;
import io.nextop.org.apache.http.entity.StringEntity;
import io.nextop.util.NoCopyByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import rx.functions.Func1;

public class Message {
    public static final WireValue P_CONTENT = WireValue.of("$content");
    public static final WireValue P_FRAGMENT = WireValue.of("$fragment");
    public static final WireValue P_CODE = WireValue.of("$code");
    public static final WireValue P_REASON = WireValue.of("$reason");
    public static final WireValue H_REDIRECT = WireValue.of("$redirect");
    public static final WireValue H_IDEMPOTENT = WireValue.of("$idempotent");
    public static final WireValue H_NULLIPOTENT = WireValue.of("$nullopotent");
    public static final WireValue H_YIELDABLE = WireValue.of("$yieldable");
    public static final WireValue H_PASSIVE = WireValue.of("$passive");
    public static final int V_PASSIVE_HOLD_FOR_ACTIVE_RADIO = 1;
    public static final Id DEFAULT_GROUP_ID = Id.create(0L, 0L, 0L, 0L);
    public static final int DEFAULT_GROUP_PRIORITY = 10;
    public static final Id LOG_GROUP_ID = Id.create(0L, 0L, 0L, 1L);
    public static final int LOG_GROUP_PRIORITY = 0;
    private static final Path P_MESSAGE_PREFIX = Path.valueOf("/m");
    public final Id id;
    public final Id groupId;
    public final int groupPriority;
    public final Route route;
    public final Map<WireValue, WireValue> headers;
    public final Map<WireValue, WireValue> parameters;
    private static final String H_PRAGMA_ID_PREFIX = "nextop-id";
    private static final String H_PRAGMA_PREFIX = "nextop-header";
    private static final String H_PRAGMA_IMAGE_SIZE_PREFIX = "image-size";
    private static final Set<String> ALL_HTTP_HEADERS;
    public static final WireValue H_LAYERS;

    public static Route outboxRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.PUT, P_MESSAGE_PREFIX.append(id.toString())));
    }

    public static Route inboxRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.POST, P_MESSAGE_PREFIX.append(id.toString())));
    }

    public static Route echoRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.GET, P_MESSAGE_PREFIX.append("/" + id)));
    }

    public static Route echoHeadRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.HEAD, P_MESSAGE_PREFIX.append("/" + id)));
    }

    public static Route logRoute() {
        return Route.local(Route.Target.create(Route.Method.POST, Path.valueOf("/log")));
    }

    public static boolean isLocal(Route route) {
        return route.via.isLocal();
    }

    @Nullable
    public static Id getLocalId(Route route) {
        if (Message.isLocal(route) && route.target.path.isFixed() && route.target.path.startsWith(P_MESSAGE_PREFIX) && 2 <= route.target.path.segments.size()) {
            Path.Segment first = route.target.path.segments.get(0);
            assert (Path.Segment.Type.FIXED.equals((Object)first.type));
            try {
                return Id.valueOf(first.value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isIdempotent(Message message) {
        WireValue idempotentValue = message.headers.get(H_IDEMPOTENT);
        if (null != idempotentValue) {
            return idempotentValue.asBoolean();
        }
        return Message.isNullipotent(message);
    }

    public static boolean isNullipotent(Message message) {
        WireValue nullipotentValue = message.headers.get(H_NULLIPOTENT);
        if (null != nullipotentValue) {
            return nullipotentValue.asBoolean();
        }
        switch (message.route.target.method) {
            case GET: 
            case HEAD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isYieldable(Message message) {
        WireValue yieldableValue = message.headers.get(H_YIELDABLE);
        if (null != yieldableValue) {
            return yieldableValue.asBoolean();
        }
        return Message.isNullipotent(message);
    }

    public static Message valueOf(Route.Method method, URL url) {
        try {
            return Message.valueOf(method, url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Message valueOf(Route.Method method, URI uri) {
        return Message.newBuilder().setRoute(Route.valueOf(String.format("%s %s", new Object[]{method, uri}))).build();
    }

    Message(Id id, Id groupId, int groupPriority, Route route, Map<WireValue, WireValue> headers, Map<WireValue, WireValue> parameters) {
        if (null == id) {
            throw new IllegalArgumentException();
        }
        if (null == groupId) {
            throw new IllegalArgumentException();
        }
        if (null == route) {
            throw new IllegalArgumentException();
        }
        if (null == headers) {
            throw new IllegalArgumentException();
        }
        if (null == parameters) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.groupId = groupId;
        this.groupPriority = groupPriority;
        this.route = route;
        this.headers = headers;
        this.parameters = parameters;
    }

    public Route outboxRoute() {
        return Message.outboxRoute(this.id);
    }

    public Route inboxRoute() {
        return Message.inboxRoute(this.id);
    }

    public Route echoRoute() {
        return Message.echoRoute(this.id);
    }

    public Route echoHeadRoute() {
        return Message.echoHeadRoute(this.id);
    }

    @Nullable
    public WireValue getContent() {
        return this.parameters.get(P_CONTENT);
    }

    public int getCode() {
        WireValue codeValue = this.parameters.get(P_CODE);
        return null != codeValue ? codeValue.asInt() : -1;
    }

    @Nullable
    public String getReason() {
        WireValue reasonValue = this.parameters.get(P_REASON);
        return null != reasonValue ? reasonValue.asString() : null;
    }

    public URI toUri() throws URISyntaxException {
        return Message.toUri(this);
    }

    public String toUriString() {
        try {
            return Message.toUri(this).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException();
        }
    }

    public Builder buildOn() {
        return this.toBuilder(false);
    }

    public Builder toBuilder() {
        return this.toBuilder(true);
    }

    private Builder toBuilder(boolean newId) {
        Builder b = (newId ? Message.newBuilder() : Message.newBuilder(this.id)).setGroupId(this.groupId).setGroupPriority(this.groupPriority).setRoute(this.route);
        for (Map.Entry<WireValue, WireValue> e : this.headers.entrySet()) {
            b = b.setHeader(e.getKey(), e.getValue());
        }
        for (Map.Entry<WireValue, WireValue> e : this.parameters.entrySet()) {
            b = b.set(e.getKey(), e.getValue());
        }
        return b;
    }

    public static Builder newBuilder() {
        return Message.newBuilder(Id.create());
    }

    public static Builder newBuilder(Id id) {
        return new Builder(id);
    }

    public String toString() {
        try {
            return String.format("%s", this.toUri());
        }
        catch (URISyntaxException e) {
            return String.format("<%s>", this.route);
        }
    }

    public int hashCode() {
        int c = this.id.hashCode();
        c = 31 * c + this.groupId.hashCode();
        c = 31 * c + this.groupPriority;
        c = 31 * c + this.route.hashCode();
        c = 31 * c + this.headers.hashCode();
        c = 31 * c + this.parameters.hashCode();
        return c;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message)) {
            return false;
        }
        Message b = (Message)obj;
        return this.id.equals(b.id) && this.groupId.equals(b.groupId) && this.groupPriority == b.groupPriority && this.route.equals(b.route) && this.headers.equals(b.headers) && this.parameters.equals(b.parameters);
    }

    public static URI toUri(final Message message) throws URISyntaxException {
        Path fixedPath = message.route.target.path.fix(new Func1<String, Object>(){

            public Object call(String s) {
                return message.parameters.get(WireValue.of(s));
            }
        });
        HashSet<String> pathVariableNames = new HashSet<String>(4);
        for (Path.Segment segment : message.route.target.path.segments) {
            if (!Path.Segment.Type.VARIABLE.equals((Object)segment.type)) continue;
            pathVariableNames.add(segment.value);
        }
        URIBuilder builder = new URIBuilder();
        builder.setScheme(message.route.via.scheme.toString().toLowerCase());
        if (null != message.route.via.authority.getHost()) {
            builder.setHost(message.route.via.authority.getHost());
            if (0 < message.route.via.authority.port) {
                builder.setPort(message.route.via.authority.port);
            }
        }
        builder.setPath(fixedPath.toString());
        for (Map.Entry<WireValue, WireValue> e : message.parameters.entrySet()) {
            WireValue key = e.getKey();
            WireValue value = e.getValue();
            if (P_CONTENT.equals(key) || pathVariableNames.contains(key.toText())) continue;
            builder.addParameter(key.toText(), value.toText());
        }
        return builder.build();
    }

    public static HttpHost toHttpHost(Message message) throws URISyntaxException {
        switch (message.route.via.scheme) {
            case HTTP: 
            case HTTPS: {
                break;
            }
            default: {
                throw new URISyntaxException(message.route.toString(), "Bad scheme");
            }
        }
        String host = message.route.via.authority.getHost();
        if (null == host) {
            throw new URISyntaxException(message.route.toString(), "Bad host");
        }
        int port = message.route.via.authority.port;
        if (port <= 0) {
            switch (message.route.via.scheme) {
                case HTTP: {
                    port = 80;
                    break;
                }
                case HTTPS: {
                    port = 443;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return new HttpHost(host, port, message.route.via.scheme.toString().toLowerCase());
    }

    public static HttpUriRequest toHttpRequest(Message message) throws URISyntaxException {
        switch (message.route.target.method) {
            case GET: {
                HttpGet get = new HttpGet();
                get.setURI(message.toUri());
                Message.attachHeaders(message, (HttpRequest)get);
                return get;
            }
            case POST: {
                HttpPost post = new HttpPost();
                post.setURI(message.toUri());
                Message.attachHeaders(message, (HttpRequest)post);
                Message.attachContent(message, (HttpEntityEnclosingRequestBase)post);
                return post;
            }
            case PUT: {
                HttpPut put = new HttpPut();
                put.setURI(message.toUri());
                Message.attachHeaders(message, (HttpRequest)put);
                Message.attachContent(message, (HttpEntityEnclosingRequestBase)put);
                return put;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Builder fromHttpResponse(HttpResponse response) {
        Builder builder = Message.newBuilder();
        builder.setCode(response.getStatusLine().getStatusCode());
        builder.setReason(response.getStatusLine().getReasonPhrase());
        Message.attachHeaders(response, builder);
        Message.attachContent(response, builder);
        return builder;
    }

    public static Message fromHttpRequest(HttpUriRequest request) {
        return null;
    }

    public static HttpResponse toHttpResponse(Message message) {
        return null;
    }

    private static void attachHeaders(Message message, HttpRequest request) {
        request.addHeader("Pragma", String.format("%s %s", H_PRAGMA_ID_PREFIX, message.id));
        for (Map.Entry<WireValue, WireValue> e : message.headers.entrySet()) {
            WireValue key = e.getKey();
            WireValue value = e.getValue();
            String keyString = key.toString();
            if (ALL_HTTP_HEADERS.contains(keyString)) {
                request.setHeader(keyString, value.toText());
                continue;
            }
            request.addHeader("Pragma", String.format("%s %s", H_PRAGMA_PREFIX, WireValue.of(Arrays.asList(key, value)).toJson()));
        }
    }

    private static void attachContent(Message message, HttpEntityEnclosingRequestBase request) {
        block11: {
            StringEntity entity;
            block13: {
                WireValue content;
                block12: {
                    content = message.parameters.get(P_CONTENT);
                    if (null == content) break block11;
                    MediaType contentType = Message.getContentType(message, content);
                    if (!request.containsHeader("Content-Type")) {
                        request.setHeader("Content-Type", contentType.toString());
                    }
                    if (contentType.is(MediaType.JSON_UTF_8)) {
                        try {
                            entity = new StringEntity(content.toJson());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    if (contentType.is(MediaType.ANY_TEXT_TYPE)) {
                        try {
                            entity = new StringEntity(content.toText());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    if (!contentType.is(MediaType.ANY_IMAGE_TYPE)) break block12;
                    switch (content.getType()) {
                        case IMAGE: {
                            EncodedImage image = content.asImage();
                            entity = new ByteArrayEntity(Arrays.copyOfRange(image.bytes, image.offset, image.length));
                            if (0 < image.width || 0 < image.height) {
                                request.addHeader("Pragma", String.format("%s %d %d", H_PRAGMA_IMAGE_SIZE_PREFIX, image.width, image.height));
                                break;
                            }
                            break block13;
                        }
                        default: {
                            ByteBuffer bb = content.asBlob();
                            byte[] bytes = new byte[bb.remaining()];
                            bb.get(bytes);
                            entity = new ByteArrayEntity(bytes);
                            break;
                        }
                    }
                    break block13;
                }
                ByteBuffer bb = content.asBlob();
                byte[] bytes = new byte[bb.remaining()];
                bb.get(bytes);
                entity = new ByteArrayEntity(bytes);
            }
            request.setEntity((HttpEntity)entity);
        }
    }

    private static MediaType getContentType(Message message, WireValue content) {
        WireValue contentTypeValue = message.headers.get(WireValue.of("Content-Type"));
        if (null != contentTypeValue) {
            return MediaType.parse((String)contentTypeValue.asString());
        }
        switch (content.getType()) {
            case IMAGE: {
                switch (content.asImage().format) {
                    case WEBP: {
                        return MediaType.WEBP;
                    }
                    case JPEG: {
                        return MediaType.JPEG;
                    }
                    case PNG: {
                        return MediaType.PNG;
                    }
                }
                throw new IllegalArgumentException();
            }
            case BLOB: {
                return MediaType.APPLICATION_BINARY;
            }
            case UTF8: {
                return MediaType.PLAIN_TEXT_UTF_8;
            }
        }
        return MediaType.JSON_UTF_8;
    }

    private static void attachHeaders(HttpResponse response, Builder builder) {
        for (Header header : response.getAllHeaders()) {
            builder.setHeader(WireValue.of(header.getName()), WireValue.of(header.getValue()));
        }
    }

    private static void attachContent(HttpResponse response, Builder builder) {
        HttpEntity entity = response.getEntity();
        if (null != entity) {
            builder.setContent(Message.createContent(response, entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WireValue createContent(HttpResponse response, HttpEntity entity) {
        WireValue value;
        block22: {
            MediaType contentType;
            Header contentTypeHeader = entity.getContentType();
            if (null == contentTypeHeader) {
                contentTypeHeader = response.getFirstHeader("Content-Type");
            }
            if ((contentType = null != contentTypeHeader ? MediaType.parse((String)contentTypeHeader.getValue()) : MediaType.APPLICATION_BINARY).is(MediaType.JSON_UTF_8)) {
                RepetableEntity re = RepetableEntity.create(entity);
                try {
                    value = WireValue.valueOfJson(new InputStreamReader(re.entity.getContent(), Charsets.UTF_8));
                }
                catch (IOException e) {
                    WireValue wireValue;
                    InputStreamReader r = new InputStreamReader(re.entity.getContent(), Charsets.UTF_8);
                    try {
                        wireValue = WireValue.of(CharStreams.toString((Readable)r));
                    }
                    catch (Throwable throwable) {
                        try {
                            ((Reader)r).close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            throw new IllegalArgumentException(e2);
                        }
                    }
                    ((Reader)r).close();
                    return wireValue;
                }
            }
            if (contentType.is(MediaType.ANY_TEXT_TYPE)) {
                try {
                    InputStreamReader r = new InputStreamReader(entity.getContent(), Charsets.UTF_8);
                    try {
                        value = WireValue.of(CharStreams.toString((Readable)r));
                        break block22;
                    }
                    finally {
                        ((Reader)r).close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (contentType.is(MediaType.ANY_IMAGE_TYPE)) {
                EncodedImage.Format format;
                RepetableEntity re = RepetableEntity.create(entity);
                re.setBytes();
                EncodedImage.Orientation orientation = EncodedImage.Orientation.REAR_FACING;
                if (contentType.is(MediaType.JPEG)) {
                    format = EncodedImage.Format.JPEG;
                } else if (contentType.is(MediaType.WEBP)) {
                    format = EncodedImage.Format.WEBP;
                } else if (contentType.is(MediaType.PNG)) {
                    format = EncodedImage.Format.PNG;
                } else {
                    return WireValue.of(re.bytes, re.offset, re.length);
                }
                int width = -1;
                int height = -1;
                return WireValue.of(EncodedImage.create(format, orientation, width, height, re.bytes, re.offset, re.length));
            }
            RepetableEntity re = RepetableEntity.create(entity);
            re.setBytes();
            return WireValue.of(re.bytes, re.offset, re.length);
        }
        return value;
    }

    @Nullable
    public static LayerInfo[] getLayers(Message message) {
        WireValue layersValue = message.headers.get(H_LAYERS);
        if (null == layersValue) {
            return null;
        }
        switch (layersValue.getType()) {
            case UTF8: {
                String s = layersValue.asString();
                String[] parts = s.split(";");
                int n = parts.length;
                LayerInfo[] layers = new LayerInfo[n];
                for (int i = 0; i < n; ++i) {
                    layers[i] = LayerInfo.valueOf(parts[i]);
                }
                return layers;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void setLayers(Builder builder, LayerInfo ... layers) {
        int n = layers.length;
        if (n <= 0) {
            builder.setHeader(H_LAYERS, null);
        } else {
            StringBuilder sb = new StringBuilder(128);
            sb.append(layers[0].toString());
            for (int i = 1; i < n; ++i) {
                sb.append(";").append(layers[i].toString());
            }
            builder.setHeader(H_LAYERS, WireValue.of(sb.toString()));
        }
    }

    static {
        HashSet<String> httpHeaders = new HashSet<String>(256);
        for (Field f : HttpHeaders.class.getFields()) {
            int m = f.getModifiers();
            try {
                if (!Modifier.isPublic(m) || !Modifier.isStatic(m)) continue;
                httpHeaders.add(f.get(null).toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        ALL_HTTP_HEADERS = ImmutableSet.copyOf(httpHeaders);
        H_LAYERS = WireValue.of("$layers");
    }

    public static final class LayerInfo {
        public final Quality quality;
        public final EncodedImage.Format format;
        public final int width;
        public final int height;
        @Nullable
        public final Id groupId;
        public final int groupPriority;

        public LayerInfo(Quality quality, EncodedImage.Format format, int width, int height, @Nullable Id groupId, int groupPriority) {
            this.quality = quality;
            this.format = format;
            this.width = width;
            this.height = height;
            this.groupId = groupId;
            this.groupPriority = groupPriority;
        }

        public boolean isTransform() {
            return 0 < this.width || 0 < this.height || !Quality.HIGH.equals((Object)this.quality);
        }

        public int scaleWidth(int w, int h) {
            if (0 < this.width) {
                return this.width;
            }
            if (0 < this.height) {
                return w * this.height / h;
            }
            return w;
        }

        public int scaleHeight(int w, int h) {
            if (0 < this.height) {
                return this.height;
            }
            if (0 < this.width) {
                return h * this.width / w;
            }
            return h;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append(this.quality.toString().toLowerCase()).append(" ").append(this.format.toString().toLowerCase()).append(" ").append(0 < this.width ? this.width : 0).append(":").append(0 < this.height ? this.height : 0);
            if (null != this.groupId) {
                sb.append(" ").append(this.groupId).append(":").append(this.groupPriority);
            }
            return sb.toString();
        }

        public static LayerInfo valueOf(String s) {
            int groupPriority;
            Id groupId;
            String[] parts = s.split(" ");
            if (parts.length < 3) {
                throw new IllegalArgumentException();
            }
            Quality quality = Quality.valueOf(parts[0].toUpperCase());
            EncodedImage.Format format = EncodedImage.Format.valueOf(parts[1].toUpperCase());
            String[] sizeParts = parts[2].split(":");
            if (2 != sizeParts.length) {
                throw new IllegalArgumentException();
            }
            int width = Integer.parseInt(sizeParts[0]);
            int height = Integer.parseInt(sizeParts[1]);
            if (4 <= parts.length) {
                String[] groupParts = parts[3].split(":");
                if (2 != groupParts.length) {
                    throw new IllegalArgumentException();
                }
                groupId = Id.valueOf(groupParts[0]);
                groupPriority = Integer.parseInt(groupParts[1]);
            } else {
                groupId = null;
                groupPriority = 0;
            }
            return new LayerInfo(quality, format, width, height, groupId, groupPriority);
        }

        public static enum Quality {
            HIGH,
            LOW;

        }
    }

    static final class RepetableEntity {
        final HttpEntity entity;
        @Nullable
        byte[] bytes;
        int offset;
        int length;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RepetableEntity create(HttpEntity entity) {
            HttpEntity repeatableEntity;
            byte[] bytes = null;
            int offset = 0;
            int length = 0;
            if (entity.isRepeatable()) {
                repeatableEntity = entity;
            } else {
                int contentLength = (int)entity.getContentLength();
                if (contentLength < 0) {
                    contentLength = 1024;
                }
                NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream(contentLength);
                try {
                    try {
                        InputStream is = entity.getContent();
                        try {
                            ByteStreams.copy((InputStream)is, (OutputStream)out);
                        }
                        finally {
                            is.close();
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                bytes = out.getBytes();
                offset = out.getOffset();
                length = out.getLength();
                repeatableEntity = new ByteArrayEntity(bytes, offset, length);
            }
            if (!repeatableEntity.isRepeatable()) {
                throw new IllegalStateException();
            }
            return new RepetableEntity(repeatableEntity, bytes, offset, length);
        }

        RepetableEntity(HttpEntity entity, @Nullable byte[] bytes, int offset, int length) {
            this.entity = entity;
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        void setBytes() {
            if (null == this.bytes) {
                try {
                    InputStream is = this.entity.getContent();
                    try {
                        this.bytes = ByteStreams.toByteArray((InputStream)is);
                        this.offset = 0;
                        this.length = this.bytes.length;
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public static final class Builder {
        private final Id id;
        private Id groupId = DEFAULT_GROUP_ID;
        private int groupPriority = 10;
        @Nullable
        private Route.Target target = null;
        @Nullable
        private Route.Via via = null;
        private Map<WireValue, WireValue> headers = new HashMap<WireValue, WireValue>(8);
        private Map<WireValue, WireValue> parameters = new HashMap<WireValue, WireValue>(8);

        private Builder(Id id) {
            this.id = id;
        }

        public Builder setGroupId(Id groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder setGroupPriority(int groupPriority) {
            this.groupPriority = groupPriority;
            return this;
        }

        public Builder setTarget(@Nullable Route.Target target) {
            this.target = target;
            return this;
        }

        public Builder setTarget(@Nullable String target) {
            this.target = null != target ? Route.Target.valueOf(target) : null;
            return this;
        }

        public Builder setVia(@Nullable Route.Via via) {
            this.via = via;
            return this;
        }

        public Builder setVia(@Nullable String via) {
            this.via = null != via ? Route.Via.valueOf(via) : null;
            return this;
        }

        public Builder setRoute(@Nullable Route route) {
            if (null != route) {
                this.target = route.target;
                this.via = route.via;
            } else {
                this.target = null;
                this.via = null;
            }
            return this;
        }

        public Builder setRoute(@Nullable String s) {
            if (null != s) {
                Route route = Route.valueOf(s);
                this.target = route.target;
                this.via = route.via;
            } else {
                this.target = null;
                this.via = null;
            }
            return this;
        }

        public Builder setHeader(Object name, @Nullable Object value) {
            if (null != value) {
                this.headers.put(WireValue.of(name), WireValue.of(value));
            } else {
                this.headers.remove(WireValue.of(name));
            }
            return this;
        }

        public Builder setContent(@Nullable Object value) {
            return this.set(P_CONTENT, value);
        }

        public Builder setCode(@Nullable Integer code) {
            return this.set(P_CODE, code);
        }

        public Builder setReason(@Nullable String reason) {
            return this.set(P_REASON, reason);
        }

        public Builder set(Object name, @Nullable Object value) {
            if (null != value) {
                this.parameters.put(WireValue.of(name), WireValue.of(value));
            } else {
                this.parameters.remove(WireValue.of(name));
            }
            return this;
        }

        public Message build() {
            if (null == this.target) {
                throw new IllegalStateException();
            }
            Route route = null != this.via ? Route.create(this.target, this.via) : Route.local(this.target);
            return new Message(this.id, this.groupId, this.groupPriority, route, (Map<WireValue, WireValue>)ImmutableMap.copyOf(this.headers), (Map<WireValue, WireValue>)ImmutableMap.copyOf(this.parameters));
        }
    }
}

