/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import io.nextop.util.HexBytes;
import java.net.InetAddress;
import java.nio.CharBuffer;
import java.util.Arrays;

public abstract class Ip {
    protected final byte[] bytes;
    private final int hashCode;

    public static Ip valueOf(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            switch (s.charAt(i)) {
                case '.': {
                    return V4.valueOf(s);
                }
                case ':': {
                    return V6.valueOfV6(s);
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static Ip valueOf(InetAddress address) {
        return Ip.create(address.getAddress());
    }

    public static Ip create(byte[] address) {
        switch (address.length) {
            case 4: {
                return V4.create(address);
            }
            case 16: {
                return V6.create(address);
            }
        }
        throw new IllegalArgumentException();
    }

    protected Ip(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public byte[] getAddress() {
        return (byte[])this.bytes.clone();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ip)) {
            return false;
        }
        Ip b = (Ip)obj;
        return this.hashCode == b.hashCode && Arrays.equals(this.bytes, b.bytes);
    }

    public static class V6
    extends Ip {
        public static Ip valueOfV6(String s) {
            if (39 != s.length()) {
                throw new IllegalArgumentException();
            }
            byte[] bytes = new byte[16];
            int i = 0;
            int n = s.length();
            int m = 0;
            for (int j = 0; m < 16 && j <= n; ++j) {
                if (n != j && ':' != s.charAt(j)) continue;
                if (i == j) {
                    if (n - 1 == j) {
                        while (m < 16) {
                            bytes[m] = 0;
                            ++m;
                        }
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                byte[] b2 = HexBytes.valueOf(s.substring(i, j));
                if (2 != b2.length) {
                    throw new IllegalArgumentException();
                }
                bytes[m] = b2[0];
                bytes[m + 1] = b2[1];
                m += 2;
                i = j + 1;
            }
            if (16 != m) {
                throw new IllegalArgumentException();
            }
            return new V6(bytes);
        }

        public static V6 create(byte[] bytes) {
            if (16 != bytes.length) {
                throw new IllegalArgumentException();
            }
            return new V6(bytes);
        }

        private V6(byte[] bytes) {
            super(bytes);
        }

        public String toString() {
            CharBuffer cb = CharBuffer.allocate(39);
            for (int i = 0; i < 8; ++i) {
                if (0 < i) {
                    cb.put(':');
                }
                HexBytes.toString(this.bytes, 2 * i, 2, cb);
            }
            return new String(cb.array());
        }
    }

    public static class V4
    extends Ip {
        public static Ip valueOf(String s) {
            byte[] bytes = new byte[4];
            int i = 0;
            int n = s.length();
            int m = 0;
            for (int j = 0; m < 4 && j <= n; ++j) {
                if (n != j && '.' != s.charAt(j)) continue;
                if (i == j) {
                    throw new IllegalArgumentException();
                }
                int b = Integer.parseInt(s.substring(i, j));
                if (b < 0 || 255 < b) {
                    throw new IllegalArgumentException();
                }
                bytes[m] = (byte)b;
                ++m;
                i = j + 1;
            }
            if (4 != m) {
                throw new IllegalArgumentException();
            }
            return new V4(bytes);
        }

        public static V4 create(byte[] bytes) {
            if (4 != bytes.length) {
                throw new IllegalArgumentException();
            }
            return new V4(bytes);
        }

        private V4(byte[] bytes) {
            super(bytes);
        }

        public String toString() {
            return String.format("%d.%d.%d.%d", 0xFF & this.bytes[0], 0xFF & this.bytes[1], 0xFF & this.bytes[2], 0xFF & this.bytes[3]);
        }
    }
}

