/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import com.google.common.hash.Hashing;
import io.nextop.util.HexBytes;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.UUID;

public final class Id
implements Comparable<Id> {
    private static final SecureRandom sr = new SecureRandom();
    public static final int LENGTH = 32;
    final byte[] bytes;
    final int offset;
    final long hashCode;

    public static Id create() {
        UUID uuid16 = UUID.randomUUID();
        byte[] rand16 = new byte[16];
        sr.nextBytes(rand16);
        return new Id(ByteBuffer.allocate(32).putLong(uuid16.getMostSignificantBits()).putLong(uuid16.getLeastSignificantBits()).put(rand16).array());
    }

    public static Id create(long a, long b, long c, long d) {
        return new Id(ByteBuffer.allocate(32).putLong(a).putLong(b).putLong(c).putLong(d).array());
    }

    public static Id valueOf(String s) throws IllegalArgumentException {
        if (64 != s.length()) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = HexBytes.valueOf(s);
        if (32 != bytes.length) {
            throw new IllegalArgumentException();
        }
        Id id = new Id(bytes);
        assert (id.toString().equals(s));
        return id;
    }

    public static void toBytes(Id id, byte[] buffer, int offset) {
        if (offset < 0 || buffer.length < offset + 32) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(id.bytes, id.offset, buffer, offset, 32);
    }

    public static Id fromBytes(byte[] buffer, int offset) {
        if (offset < 0 || buffer.length < offset + 32) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = Arrays.copyOfRange(buffer, offset, offset + 32);
        return new Id(bytes, 0);
    }

    Id(byte[] bytes) {
        this(bytes, 0);
    }

    Id(byte[] bytes, int offset) {
        this.bytes = bytes;
        this.offset = offset;
        this.hashCode = Hashing.murmur3_128().hashBytes(bytes, offset, 32).asLong();
    }

    public String toString() {
        return HexBytes.toString(this.bytes, this.offset, 32);
    }

    public int hashCode() {
        return (int)this.hashCode;
    }

    public long longHashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Id)) {
            return false;
        }
        Id b = (Id)obj;
        if (this.hashCode != b.hashCode) {
            return false;
        }
        for (int i = 0; i < 32; ++i) {
            if (this.bytes[this.offset + i] == b.bytes[b.offset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Id b) {
        for (int i = 0; i < 32; ++i) {
            int d = (0xFF & this.bytes[this.offset + i]) - (0xFF & b.bytes[b.offset + i]);
            if (0 == d) continue;
            return d;
        }
        return 0;
    }
}

