/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class EncodedImage {
    public static final Orientation DEFAULT_ORIENTATION = Orientation.REAR_FACING;
    public static final int UNKNOWN_WIDTH = -1;
    public static final int UNKNOWN_HEIGHT = -1;
    public final Format format;
    public final Orientation orientation;
    public final int width;
    public final int height;
    protected final byte[] bytes;
    protected final int offset;
    protected final int length;

    public static EncodedImage webp(byte[] bytes) {
        return EncodedImage.webp(-1, -1, bytes);
    }

    public static EncodedImage webp(int width, int height, byte[] bytes) {
        return EncodedImage.create(Format.WEBP, Orientation.REAR_FACING, width, height, bytes, 0, bytes.length);
    }

    public static EncodedImage jpeg(byte[] bytes) {
        return EncodedImage.jpeg(-1, -1, bytes);
    }

    public static EncodedImage jpeg(int width, int height, byte[] bytes) {
        return EncodedImage.create(Format.JPEG, Orientation.REAR_FACING, width, height, bytes, 0, bytes.length);
    }

    public static EncodedImage png(byte[] bytes) {
        return EncodedImage.jpeg(-1, -1, bytes);
    }

    public static EncodedImage png(int width, int height, byte[] bytes) {
        return EncodedImage.create(Format.PNG, Orientation.REAR_FACING, width, height, bytes, 0, bytes.length);
    }

    public static EncodedImage create(Format format, Orientation orientation, int width, int height, byte[] bytes, int offset, int length) {
        return new EncodedImage(format, orientation, width, height, bytes, offset, length);
    }

    protected EncodedImage(Format format, Orientation orientation, int width, int height, byte[] bytes, int offset, int length) {
        this.format = format;
        this.orientation = orientation;
        this.width = width;
        this.height = height;
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    protected ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.bytes, this.offset, this.length);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        int c = this.format.hashCode();
        c = 31 * c + this.orientation.hashCode();
        c = 31 * c + this.width;
        c = 31 * c + this.height;
        c = 31 * c + this.length;
        for (int i = 0; i < this.length; ++i) {
            c = 31 * c + this.bytes[this.offset + i];
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EncodedImage)) {
            return false;
        }
        EncodedImage b = (EncodedImage)obj;
        if (!this.format.equals((Object)b.format) || !this.orientation.equals((Object)b.orientation) || this.width != b.width || this.height != b.height || this.length != b.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[this.offset + i] == b.bytes[b.offset + i]) continue;
            return false;
        }
        return true;
    }

    public static enum Orientation {
        REAR_FACING,
        FRONT_FACING;

    }

    public static enum Format {
        WEBP,
        JPEG,
        PNG;

    }
}

