/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public final class DomainName {
    public final List<String> labels;
    private static final Pattern M_LABEL = Pattern.compile("[a-z0-9]+(?:[a-z0-9-]+[a-z0-9]+)?");

    public static DomainName valueOf(String s) {
        int n = s.length();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        LinkedList<String> labels = new LinkedList<String>();
        int j = n;
        for (int i = n - 1; 0 <= i; --i) {
            if ('.' != s.charAt(i)) continue;
            if (i + 1 == j) {
                throw new IllegalArgumentException();
            }
            labels.add(s.substring(i + 1, j).toLowerCase());
            j = i;
        }
        if (0 == j) {
            throw new IllegalArgumentException();
        }
        labels.add(s.substring(0, j).toLowerCase());
        for (String label : labels) {
            if (M_LABEL.matcher(label).matches()) continue;
            throw new IllegalArgumentException();
        }
        return new DomainName((List<String>)ImmutableList.copyOf(labels));
    }

    private DomainName(List<String> labels) {
        this.labels = labels;
    }

    public String toString() {
        return Joiner.on((char)'.').join((Iterable)Lists.reverse(this.labels));
    }

    public int hashCode() {
        return this.labels.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DomainName)) {
            return false;
        }
        DomainName b = (DomainName)obj;
        return this.labels.equals(b.labels);
    }
}

