/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.stream;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.stream.ChunkedInput;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class ChunkedWriteHandler
implements ChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<PendingWrite> queue = new ArrayDeque<PendingWrite>();
    private volatile ChannelHandlerContext ctx;

    public ChunkedWriteHandler() {
    }

    @Deprecated
    public ChunkedWriteHandler(int maxPendingWrites) {
        ObjectUtil.checkPositive((int)maxPendingWrites, (String)"maxPendingWrites");
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void resumeTransfer() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        if (ctx.executor().inEventLoop()) {
            this.resumeTransfer0(ctx);
        } else {
            ctx.executor().execute(() -> this.resumeTransfer0(ctx));
        }
    }

    private void resumeTransfer0(ChannelHandlerContext ctx) {
        try {
            this.doFlush(ctx);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while sending chunks.", (Throwable)e);
        }
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        Promise promise = ctx.newPromise();
        this.queue.add(new PendingWrite(msg, (Promise<Void>)promise));
        return promise.asFuture();
    }

    public void flush(ChannelHandlerContext ctx) {
        this.doFlush(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doFlush(ctx);
        ctx.fireChannelInactive();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    private void discard(Throwable cause) {
        PendingWrite currentWrite;
        while ((currentWrite = this.queue.poll()) != null) {
            Object message = currentWrite.msg;
            if (message instanceof ChunkedInput) {
                boolean endOfInput;
                ChunkedInput in = (ChunkedInput)message;
                try {
                    endOfInput = in.isEndOfInput();
                    ChunkedWriteHandler.closeInput(in);
                }
                catch (Exception e) {
                    ChunkedWriteHandler.closeInput(in);
                    currentWrite.fail(e);
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(ChunkedInput.class.getSimpleName() + " failed", (Throwable)e);
                    continue;
                }
                if (!endOfInput) {
                    if (cause == null) {
                        cause = new ClosedChannelException();
                    }
                    currentWrite.fail(cause);
                    continue;
                }
                currentWrite.success();
                continue;
            }
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            currentWrite.fail(cause);
        }
    }

    private void doFlush(ChannelHandlerContext ctx) {
        PendingWrite currentWrite;
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.discard(null);
            return;
        }
        boolean requiresFlush = true;
        BufferAllocator allocator = ctx.bufferAllocator();
        while (channel.isWritable() && (currentWrite = this.queue.peek()) != null) {
            if (currentWrite.promise.isDone()) {
                this.queue.remove();
                continue;
            }
            Object pendingMessage = currentWrite.msg;
            if (pendingMessage instanceof ChunkedInput) {
                boolean suspend;
                boolean endOfInput;
                ChunkedInput chunks = (ChunkedInput)pendingMessage;
                Buffer message = null;
                try {
                    message = (Buffer)chunks.readChunk(allocator);
                    endOfInput = chunks.isEndOfInput();
                    suspend = message == null ? !endOfInput : false;
                }
                catch (Throwable t) {
                    this.queue.remove();
                    if (message != null) {
                        Resource.dispose(message);
                    }
                    ChunkedWriteHandler.closeInput(chunks);
                    currentWrite.fail(t);
                    break;
                }
                if (suspend) break;
                if (message == null) {
                    message = allocator.allocate(0);
                }
                if (endOfInput) {
                    this.queue.remove();
                }
                Future f = ctx.writeAndFlush((Object)message);
                if (endOfInput) {
                    if (f.isDone()) {
                        ChunkedWriteHandler.handleEndOfInputFuture(f, currentWrite);
                    } else {
                        f.addListener(future -> ChunkedWriteHandler.handleEndOfInputFuture(future, currentWrite));
                    }
                } else {
                    boolean resume;
                    boolean bl = resume = !channel.isWritable();
                    if (f.isDone()) {
                        this.handleFuture(channel, f, currentWrite, resume);
                    } else {
                        f.addListener(future -> this.handleFuture(channel, future, currentWrite, resume));
                    }
                }
                requiresFlush = false;
            } else {
                this.queue.remove();
                ctx.write(pendingMessage).cascadeTo(currentWrite.promise);
                requiresFlush = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (requiresFlush) {
            ctx.flush();
        }
    }

    private static void handleEndOfInputFuture(Future<?> future, PendingWrite currentWrite) {
        ChunkedInput input = (ChunkedInput)currentWrite.msg;
        ChunkedWriteHandler.closeInput(input);
        if (future.isFailed()) {
            currentWrite.fail(future.cause());
        } else {
            currentWrite.success();
        }
    }

    private void handleFuture(Channel channel, Future<?> future, PendingWrite currentWrite, boolean resume) {
        ChunkedInput input = (ChunkedInput)currentWrite.msg;
        if (future.isFailed()) {
            ChunkedWriteHandler.closeInput(input);
            currentWrite.fail(future.cause());
        } else if (resume && channel.isWritable()) {
            this.resumeTransfer();
        }
    }

    private static void closeInput(ChunkedInput<?> chunks) {
        block2: {
            try {
                chunks.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a chunked input.", t);
            }
        }
    }

    private static final class PendingWrite {
        final Object msg;
        final Promise<Void> promise;

        PendingWrite(Object msg, Promise<Void> promise) {
            this.msg = msg;
            this.promise = promise;
        }

        void fail(Throwable cause) {
            this.promise.tryFailure(cause);
            if (Resource.isAccessible((Object)this.msg, (boolean)false)) {
                SilentDispose.dispose((Object)this.msg, (InternalLogger)logger);
            }
        }

        void success() {
            if (this.promise.isDone()) {
                return;
            }
            this.promise.trySuccess(null);
        }
    }
}

