/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferUtil;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.buffer.StandardAllocationTypes;
import io.netty5.channel.AbstractCoalescingBufferQueue;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.codec.UnsupportedMessageTypeException;
import io.netty5.handler.ssl.ApplicationProtocolAccessor;
import io.netty5.handler.ssl.AsyncRunnable;
import io.netty5.handler.ssl.ConscryptAlpnSslEngine;
import io.netty5.handler.ssl.EngineWrapper;
import io.netty5.handler.ssl.NotSslRecordException;
import io.netty5.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty5.handler.ssl.SslCloseCompletionEvent;
import io.netty5.handler.ssl.SslClosedEngineException;
import io.netty5.handler.ssl.SslHandshakeCompletionEvent;
import io.netty5.handler.ssl.SslHandshakeTimeoutException;
import io.netty5.handler.ssl.SslUtils;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.ImmediateEventExecutor;
import io.netty5.util.concurrent.ImmediateExecutor;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;

public class SslHandler
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final int STATE_SENT_FIRST_MESSAGE = 1;
    private static final int STATE_FLUSHED_BEFORE_HANDSHAKE = 2;
    private static final int STATE_READ_DURING_HANDSHAKE = 4;
    private static final int STATE_HANDSHAKE_STARTED = 8;
    private static final int STATE_NEEDS_FLUSH = 16;
    private static final int STATE_OUTBOUND_CLOSED = 32;
    private static final int STATE_CLOSE_NOTIFY = 64;
    private static final int STATE_PROCESS_TASK = 128;
    private static final int STATE_FIRE_CHANNEL_READ = 256;
    private static final int STATE_UNWRAP_REENTRY = 512;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslEngineType engineType;
    private final Executor delegatedTaskExecutor;
    private final boolean jdkCompatibilityMode;
    private final EngineWrapper engineWrapper;
    private final boolean startTls;
    private final SslTasksRunner sslTaskRunnerForUnwrap = new SslTasksRunner(true);
    private final SslTasksRunner sslTaskRunner = new SslTasksRunner(false);
    private SslHandlerCoalescingBufferQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new LazyPromise();
    private final Promise<Channel> sslClosePromise = new LazyPromise();
    private int packetLength;
    private short state;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyFlushTimeoutMillis = 3000L;
    private volatile long closeNotifyReadTimeoutMillis;
    volatile int wrapDataSize = 16384;

    public SslHandler(SSLEngine engine) {
        this(engine, false);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, startTls, (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this(engine, false, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        super(SslEngineType.forEngine((SSLEngine)engine).cumulator);
        Objects.requireNonNull(engine, "engine");
        Objects.requireNonNull(delegatedTaskExecutor, "delegatedTaskExecutor");
        this.engine = engine;
        this.engineType = SslEngineType.forEngine(engine);
        this.delegatedTaskExecutor = delegatedTaskExecutor;
        this.startTls = startTls;
        this.engineWrapper = new EngineWrapper(engine, this.engineType.wantsDirectBuffer);
        this.jdkCompatibilityMode = this.engineType.jdkCompatibilityMode(engine);
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long handshakeTimeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        this.setHandshakeTimeoutMillis(unit.toMillis(handshakeTimeout));
    }

    public void setHandshakeTimeoutMillis(long handshakeTimeoutMillis) {
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)handshakeTimeoutMillis, (String)"handshakeTimeoutMillis");
    }

    @UnstableApi
    public final void setWrapDataSize(int wrapDataSize) {
        this.wrapDataSize = wrapDataSize;
    }

    @Deprecated
    public long getCloseNotifyTimeoutMillis() {
        return this.getCloseNotifyFlushTimeoutMillis();
    }

    @Deprecated
    public void setCloseNotifyTimeout(long closeNotifyTimeout, TimeUnit unit) {
        this.setCloseNotifyFlushTimeout(closeNotifyTimeout, unit);
    }

    @Deprecated
    public void setCloseNotifyTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
        this.setCloseNotifyFlushTimeoutMillis(closeNotifyFlushTimeoutMillis);
    }

    public final long getCloseNotifyFlushTimeoutMillis() {
        return this.closeNotifyFlushTimeoutMillis;
    }

    public final void setCloseNotifyFlushTimeout(long closeNotifyFlushTimeout, TimeUnit unit) {
        this.setCloseNotifyFlushTimeoutMillis(unit.toMillis(closeNotifyFlushTimeout));
    }

    public final void setCloseNotifyFlushTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
        this.closeNotifyFlushTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)closeNotifyFlushTimeoutMillis, (String)"closeNotifyFlushTimeoutMillis");
    }

    public final long getCloseNotifyReadTimeoutMillis() {
        return this.closeNotifyReadTimeoutMillis;
    }

    public final void setCloseNotifyReadTimeout(long closeNotifyReadTimeout, TimeUnit unit) {
        this.setCloseNotifyReadTimeoutMillis(unit.toMillis(closeNotifyReadTimeout));
    }

    public final void setCloseNotifyReadTimeoutMillis(long closeNotifyReadTimeoutMillis) {
        this.closeNotifyReadTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)closeNotifyReadTimeoutMillis, (String)"closeNotifyReadTimeoutMillis");
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLEngine engine = this.engine();
        if (!(engine instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)engine)).getNegotiatedApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise.asFuture();
    }

    public Future<Void> closeOutbound() {
        ChannelHandlerContext ctx = this.ctx;
        Promise promise = ctx.newPromise();
        if (ctx.executor().inEventLoop()) {
            this.closeOutbound0((Promise<Void>)promise);
        } else {
            ctx.executor().execute(() -> this.closeOutbound0((Promise<Void>)promise));
        }
        return promise.asFuture();
    }

    private void closeOutbound0(Promise<Void> promise) {
        block2: {
            this.setState(32);
            this.engine.closeOutbound();
            try {
                this.flush(this.ctx, promise);
            }
            catch (Exception e) {
                if (promise.tryFailure((Throwable)e)) break block2;
                logger.warn("{} flush() raised a masked exception.", (Object)this.ctx.channel(), (Object)e);
            }
        }
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslClosePromise.asFuture();
    }

    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try (AutoCloseable ignore = SilentDispose.autoClosing((Object)this.engine);){
            if (this.pendingUnencryptedWrites != null && !this.pendingUnencryptedWrites.isEmpty()) {
                this.pendingUnencryptedWrites.releaseAndFailAll((ChannelOutboundInvoker)ctx, (Throwable)new ChannelException("Pending write on removal of SslHandler"));
            }
            this.pendingUnencryptedWrites = null;
            SSLException cause = null;
            if (!this.handshakePromise.isDone() && this.handshakePromise.tryFailure((Throwable)(cause = new SSLHandshakeException("SslHandler removed before handshake completed")))) {
                ctx.fireChannelInboundEvent((Object)new SslHandshakeCompletionEvent(this.engine().getSession(), this.applicationProtocol(), cause));
            }
            if (!this.sslClosePromise.isDone()) {
                if (cause == null) {
                    cause = new SSLException("SslHandler removed before SSLEngine was closed");
                }
                this.notifyClosePromise(cause);
            }
        }
    }

    public Future<Void> disconnect(ChannelHandlerContext ctx) {
        return this.closeOutboundAndChannel(ctx, true);
    }

    public Future<Void> close(ChannelHandlerContext ctx) {
        return this.closeOutboundAndChannel(ctx, false);
    }

    public void read(ChannelHandlerContext ctx, ReadBufferAllocator readBufferAllocator) {
        if (!this.handshakePromise.isDone()) {
            this.setState(4);
        }
        ctx.read(readBufferAllocator);
    }

    private static IllegalStateException newPendingWritesNullException() {
        return new IllegalStateException("pendingUnencryptedWrites is null, handlerRemoved0 called?");
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof Buffer)) {
            UnsupportedMessageTypeException exception = new UnsupportedMessageTypeException(msg, new Class[]{Buffer.class});
            logger.warn((Throwable)exception);
            SilentDispose.dispose((Object)msg, (InternalLogger)logger);
            return ctx.newFailedFuture((Throwable)exception);
        }
        if (this.pendingUnencryptedWrites == null) {
            IllegalStateException exception = SslHandler.newPendingWritesNullException();
            try {
                Resource.dispose((Object)msg);
            }
            catch (Exception e) {
                exception.addSuppressed(e);
            }
            return ctx.newFailedFuture((Throwable)exception);
        }
        Promise promise = ctx.newPromise();
        this.pendingUnencryptedWrites.add((Buffer)msg, promise);
        return promise.asFuture();
    }

    public void flush(ChannelHandlerContext ctx) {
        if (this.startTls && !this.isStateSet(1)) {
            this.setState(1);
            this.pendingUnencryptedWrites.writeAndRemoveAll(ctx);
            this.forceFlush(ctx);
            this.startHandshakeProcessing(true);
            return;
        }
        if (this.isStateSet(128)) {
            return;
        }
        try {
            this.wrapAndFlush(ctx);
        }
        catch (Throwable cause) {
            this.setHandshakeFailure(ctx, cause);
        }
    }

    private void wrapAndFlush(ChannelHandlerContext ctx) throws SSLException {
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(ctx.bufferAllocator().allocate(0), ctx.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.setState(2);
        }
        try {
            this.wrap(ctx, false);
        }
        finally {
            this.forceFlush(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrap(ChannelHandlerContext ctx, boolean inUnwrap) throws SSLException {
        block26: {
            Buffer out = null;
            BufferAllocator alloc = ctx.bufferAllocator();
            try {
                int wrapDataSize = this.wrapDataSize;
                block11: while (!ctx.isRemoved()) {
                    Buffer buf;
                    Promise promise = ctx.newPromise();
                    Buffer buffer = buf = wrapDataSize > 0 ? this.pendingUnencryptedWrites.remove(alloc, wrapDataSize, promise) : this.pendingUnencryptedWrites.removeFirst(promise);
                    if (buf == null) {
                        break;
                    }
                    if (out == null) {
                        out = this.allocateOutNetBuf(ctx, buf.readableBytes(), buf.countReadableComponents());
                    }
                    SSLEngineResult result = this.wrap(this.engine, buf, out);
                    if (buf.readableBytes() > 0) {
                        this.pendingUnencryptedWrites.addFirst(buf, promise);
                        promise = null;
                    } else {
                        buf.close();
                    }
                    if (out.readableBytes() > 0) {
                        Buffer b = out;
                        out = null;
                        if (promise != null) {
                            ctx.write((Object)b).cascadeTo(promise);
                        } else {
                            ctx.write((Object)b);
                        }
                    } else if (promise != null) {
                        ctx.write((Object)alloc.allocate(0)).cascadeTo(promise);
                    }
                    if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                        Throwable exception;
                        Throwable throwable = exception = this.handshakePromise.isDone() ? this.handshakePromise.cause() : null;
                        if (exception == null) {
                            Throwable throwable2 = exception = this.sslClosePromise.isDone() ? this.sslClosePromise.cause() : null;
                            if (exception == null) {
                                exception = new SslClosedEngineException("SSLEngine closed already");
                            }
                        }
                        this.pendingUnencryptedWrites.releaseAndFailAll((ChannelOutboundInvoker)ctx, exception);
                        return;
                    }
                    switch (result.getHandshakeStatus()) {
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(inUnwrap)) continue block11;
                            break block26;
                        }
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            this.setHandshakeSuccess();
                            break;
                        }
                        case NEED_WRAP: {
                            if (result.bytesProduced() <= 0 || !this.pendingUnencryptedWrites.isEmpty()) continue block11;
                            this.pendingUnencryptedWrites.add(alloc.allocate(0));
                            break;
                        }
                        case NEED_UNWRAP: {
                            this.readIfNeeded(ctx);
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + result.getHandshakeStatus());
                        }
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (inUnwrap) {
                    this.setState(16);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wrapNonAppData(ChannelHandlerContext ctx, boolean inUnwrap) throws SSLException {
        block23: {
            try (Buffer out = null;){
                while (!ctx.isRemoved()) {
                    SSLEngineResult result;
                    if (out == null) {
                        out = this.allocateOutNetBuf(ctx, 2048, 1);
                    }
                    if ((result = this.wrap(this.engine, null, out)).bytesProduced() > 0) {
                        ctx.write((Object)out).addListener(future -> {
                            Throwable cause = future.cause();
                            if (cause != null) {
                                this.setHandshakeFailureTransportFailure(ctx, cause);
                            }
                        });
                        if (inUnwrap) {
                            this.setState(16);
                        }
                        out = null;
                    }
                    SSLEngineResult.HandshakeStatus status = result.getHandshakeStatus();
                    switch (status) {
                        case FINISHED: {
                            if (this.setHandshakeSuccess() && inUnwrap && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(ctx, true);
                            }
                            boolean bl = false;
                            return bl;
                        }
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(inUnwrap)) break;
                            break block23;
                        }
                        case NEED_UNWRAP: {
                            if (!inUnwrap && this.unwrapNonAppData(ctx) > 0) break;
                            boolean bl = false;
                            return bl;
                        }
                        case NEED_WRAP: {
                            break;
                        }
                        case NOT_HANDSHAKING: {
                            if (this.setHandshakeSuccess() && inUnwrap && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(ctx, true);
                            }
                            if (!inUnwrap) {
                                this.unwrapNonAppData(ctx);
                            }
                            boolean bl = true;
                            return bl;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + result.getHandshakeStatus());
                        }
                    }
                    if (result.bytesProduced() == 0 && status != SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    } else if (result.bytesConsumed() != 0 || result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                    break;
                }
            }
        }
        return false;
    }

    private SSLEngineResult wrap(SSLEngine engine, Buffer in, Buffer out) throws SSLException {
        SSLEngineResult result;
        while ((result = this.engineWrapper.wrap(in, out)).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            out.ensureWritable(engine.getSession().getPacketBufferSize());
        }
        return result;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        block2: {
            boolean handshakeFailed = this.handshakePromise.isFailed();
            ClosedChannelException exception = new ClosedChannelException();
            this.setHandshakeFailure(ctx, exception, !this.isStateSet(32), this.isStateSet(8), false);
            this.notifyClosePromise(exception);
            try {
                super.channelInactive(ctx);
            }
            catch (DecoderException e) {
                if (handshakeFailed && e.getCause() instanceof SSLException) break block2;
                throw e;
            }
        }
    }

    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.ignoreException(cause)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)ctx.channel(), (Object)cause);
            }
            if (ctx.channel().isActive()) {
                ctx.close();
            }
        } else {
            ctx.fireChannelExceptionCaught(cause);
            if (cause instanceof SSLException || cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
                ctx.close();
            }
        }
    }

    private boolean ignoreException(Throwable t) {
        if (!(t instanceof SSLException) && t instanceof IOException && this.sslClosePromise.isDone()) {
            StackTraceElement[] elements;
            String message = t.getMessage();
            if (message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                return true;
            }
            for (StackTraceElement element : elements = t.getStackTrace()) {
                String classname = element.getClassName();
                String methodname = element.getMethodName();
                if (classname.startsWith("io.netty5.") || !"read".equals(methodname)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = PlatformDependent.getClassLoader(((Object)((Object)this)).getClass()).loadClass(classname);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                }
                catch (Throwable cause) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Unexpected exception while loading class {} classname {}", new Object[]{((Object)((Object)this)).getClass(), classname, cause});
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(Buffer buffer) {
        if (buffer.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        return SslUtils.getEncryptedPacketLength(buffer, buffer.readerOffset()) != -2;
    }

    private void decodeJdkCompatible(ChannelHandlerContext ctx, Buffer in) throws NotSslRecordException {
        int packetLength = this.packetLength;
        if (packetLength > 0) {
            if (in.readableBytes() < packetLength) {
                return;
            }
        } else {
            int readableBytes = in.readableBytes();
            if (readableBytes < 5) {
                return;
            }
            packetLength = SslUtils.getEncryptedPacketLength(in, in.readerOffset());
            if (packetLength == -2) {
                NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + BufferUtil.hexDump((Buffer)in));
                in.skipReadableBytes(in.readableBytes());
                this.setHandshakeFailure(ctx, e);
                throw e;
            }
            assert (packetLength > 0);
            if (packetLength > readableBytes) {
                this.packetLength = packetLength;
                return;
            }
        }
        this.packetLength = 0;
        try {
            int bytesConsumed = this.unwrap(ctx, in, packetLength);
            assert (bytesConsumed == packetLength || this.engine.isInboundDone()) : "we feed the SSLEngine a packets worth of data: " + packetLength + " but it only consumed: " + bytesConsumed;
        }
        catch (Throwable cause) {
            this.handleUnwrapThrowable(ctx, cause);
        }
    }

    private void decodeNonJdkCompatible(ChannelHandlerContext ctx, Buffer in) {
        try {
            this.unwrap(ctx, in, in.readableBytes());
        }
        catch (Throwable cause) {
            this.handleUnwrapThrowable(ctx, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnwrapThrowable(ChannelHandlerContext ctx, Throwable cause) {
        try {
            if (this.handshakePromise.tryFailure(cause)) {
                ctx.fireChannelInboundEvent((Object)new SslHandshakeCompletionEvent(this.engine().getSession(), this.applicationProtocol(), cause));
            }
            this.wrapAndFlush(ctx);
        }
        catch (SSLException ex) {
            logger.debug("SSLException during trying to call SSLEngine.wrap(...) because of an previous SSLException, ignoring...", (Throwable)ex);
        }
        finally {
            this.setHandshakeFailure(ctx, cause, true, false, true);
        }
        PlatformDependent.throwException((Throwable)cause);
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws SSLException {
        if (this.isStateSet(128)) {
            return;
        }
        if (this.jdkCompatibilityMode) {
            this.decodeJdkCompatible(ctx, in);
        } else {
            this.decodeNonJdkCompatible(ctx, in);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.channelReadComplete0(ctx);
    }

    private void channelReadComplete0(ChannelHandlerContext ctx) {
        this.discardSomeReadBytes();
        this.flushIfNeeded(ctx);
        this.readIfNeeded(ctx);
        this.clearState(256);
        ctx.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext ctx) {
        if (!(((Boolean)ctx.channel().getOption(ChannelOption.AUTO_READ)).booleanValue() || this.isStateSet(256) && this.handshakePromise.isDone())) {
            ctx.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext ctx) {
        if (this.isStateSet(16)) {
            this.forceFlush(ctx);
        }
    }

    private int unwrapNonAppData(ChannelHandlerContext ctx) throws SSLException {
        return this.unwrap(ctx, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unwrap(ChannelHandlerContext ctx, Buffer packet, int length) throws SSLException {
        int originalLength = length;
        boolean wrapLater = false;
        boolean notifyClosure = false;
        boolean executedRead = false;
        Buffer decodeOut = this.allocate(ctx, length);
        try {
            do {
                SSLEngineResult result = this.engineWrapper.unwrap(packet, length, decodeOut);
                SSLEngineResult.Status status = result.getStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                int produced = result.bytesProduced();
                int consumed = result.bytesConsumed();
                length -= consumed;
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    wrapLater |= (decodeOut.readableBytes() <= 0 ? this.setHandshakeSuccess() : this.setHandshakeSuccessUnwrapMarkReentry()) || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED;
                }
                if (decodeOut.readableBytes() > 0) {
                    this.setState(256);
                    if (this.isStateSet(512)) {
                        executedRead = true;
                        SslHandler.executeChannelRead(ctx, decodeOut);
                    } else {
                        ctx.fireChannelRead((Object)decodeOut);
                    }
                    decodeOut = null;
                }
                if (status == SSLEngineResult.Status.CLOSED) {
                    notifyClosure = true;
                } else if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    int applicationBufferSize;
                    if (decodeOut != null) {
                        decodeOut.close();
                    }
                    decodeOut = this.allocate(ctx, this.engineType.calculatePendingData(this, (applicationBufferSize = this.engine.getSession().getApplicationBufferSize()) < produced ? applicationBufferSize : applicationBufferSize - produced));
                    continue;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    boolean pending = this.runDelegatedTasks(true);
                    if (!pending) {
                        wrapLater = false;
                        break;
                    }
                } else if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && this.wrapNonAppData(ctx, true) && length == 0) break;
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW || handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && (consumed == 0 && produced == 0 || length == 0 && handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                    if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                    this.readIfNeeded(ctx);
                    break;
                }
                if (decodeOut != null) continue;
                decodeOut = this.allocate(ctx, length);
            } while (!ctx.isRemoved());
            if (this.isStateSet(2) && this.handshakePromise.isDone()) {
                this.clearState(2);
                wrapLater = true;
            }
            if (wrapLater) {
                this.wrap(ctx, true);
            }
        }
        finally {
            if (decodeOut != null) {
                decodeOut.close();
            }
            if (notifyClosure) {
                if (executedRead) {
                    this.executeNotifyClosePromise(ctx);
                } else {
                    this.notifyClosePromise(null);
                }
            }
        }
        return originalLength - length;
    }

    private boolean setHandshakeSuccessUnwrapMarkReentry() {
        boolean setReentryState;
        boolean bl = setReentryState = !this.isStateSet(512);
        if (setReentryState) {
            this.setState(512);
        }
        try {
            boolean bl2 = this.setHandshakeSuccess();
            return bl2;
        }
        finally {
            if (setReentryState) {
                this.clearState(512);
            }
        }
    }

    private void executeNotifyClosePromise(ChannelHandlerContext ctx) {
        try {
            ctx.executor().execute(() -> this.notifyClosePromise(null));
        }
        catch (RejectedExecutionException e) {
            this.notifyClosePromise(e);
        }
    }

    private static void executeChannelRead(ChannelHandlerContext ctx, Buffer decodedOut) {
        try {
            ctx.executor().execute(() -> ctx.fireChannelRead((Object)decodedOut));
        }
        catch (RejectedExecutionException e) {
            decodedOut.close();
            throw e;
        }
    }

    private static boolean inEventLoop(Executor executor) {
        return executor instanceof EventExecutor && ((EventExecutor)executor).inEventLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean runDelegatedTasks(boolean inUnwrap) {
        block9: {
            if (this.delegatedTaskExecutor != ImmediateExecutor.INSTANCE && !SslHandler.inEventLoop(this.delegatedTaskExecutor)) break block9;
            while (true) lbl-1000:
            // 6 sources

            {
                if ((task = this.engine.getDelegatedTask()) == null) {
                    return true;
                }
                this.setState(128);
                if (task instanceof AsyncRunnable) {
                    pending = false;
                    try {
                        asyncTask = (AsyncRunnable)task;
                        completionHandler = new AsyncTaskCompletionHandler(inUnwrap);
                        asyncTask.run(completionHandler);
                        pending = completionHandler.resumeLater();
                        if (!pending) ** GOTO lbl-1000
                        var6_6 = false;
                        return var6_6;
                    }
                    finally {
                        if (pending) ** GOTO lbl-1000
                        this.clearState(128);
                    }
                    continue;
                }
                try {
                    task.run();
                }
                finally {
                    this.clearState(128);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
        }
        this.executeDelegatedTask(inUnwrap);
        return false;
    }

    private SslTasksRunner getTaskRunner(boolean inUnwrap) {
        return inUnwrap ? this.sslTaskRunnerForUnwrap : this.sslTaskRunner;
    }

    private void executeDelegatedTask(boolean inUnwrap) {
        this.executeDelegatedTask(this.getTaskRunner(inUnwrap));
    }

    private void executeDelegatedTask(SslTasksRunner task) {
        this.setState(128);
        try {
            this.delegatedTaskExecutor.execute(task);
        }
        catch (RejectedExecutionException e) {
            this.clearState(128);
            throw e;
        }
    }

    private boolean setHandshakeSuccess() {
        boolean notified;
        boolean bl = notified = !this.handshakePromise.isDone() && this.handshakePromise.trySuccess((Object)this.ctx.channel());
        if (notified) {
            if (logger.isDebugEnabled()) {
                SSLSession session = this.engine.getSession();
                logger.debug("{} HANDSHAKEN: protocol:{} cipher suite:{}", new Object[]{this.ctx.channel(), session.getProtocol(), session.getCipherSuite()});
            }
            this.ctx.fireChannelInboundEvent((Object)new SslHandshakeCompletionEvent(this.engine().getSession(), this.applicationProtocol()));
        }
        if (this.isStateSet(4)) {
            this.clearState(4);
            if (!((Boolean)this.ctx.channel().getOption(ChannelOption.AUTO_READ)).booleanValue()) {
                this.ctx.read();
            }
        }
        return notified;
    }

    private void setHandshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
        this.setHandshakeFailure(ctx, cause, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(ChannelHandlerContext ctx, Throwable cause, boolean closeInbound, boolean notify, boolean alwaysFlushAndClose) {
        try {
            block7: {
                this.setState(32);
                this.engine.closeOutbound();
                if (closeInbound) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException e) {
                        String msg;
                        if (!logger.isDebugEnabled() || (msg = e.getMessage()) != null && (msg.contains("possible truncation attack") || msg.contains("closing inbound before receiving peer's close_notify"))) break block7;
                        logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)ctx.channel(), (Object)e);
                    }
                }
            }
            if (this.handshakePromise.tryFailure(cause) || alwaysFlushAndClose) {
                SslUtils.handleHandshakeFailure(ctx, this.engine().getSession(), this.applicationProtocol(), cause, notify);
            }
        }
        finally {
            this.releaseAndFailAll(ctx, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailureTransportFailure(ChannelHandlerContext ctx, Throwable cause) {
        try {
            SSLException transportFailure = new SSLException("failure when writing TLS control frames", cause);
            this.releaseAndFailAll(ctx, transportFailure);
            if (this.handshakePromise.tryFailure((Throwable)transportFailure)) {
                ctx.fireChannelInboundEvent((Object)new SslHandshakeCompletionEvent(this.engine().getSession(), this.applicationProtocol(), transportFailure));
            }
        }
        finally {
            ctx.close();
        }
    }

    private void releaseAndFailAll(ChannelHandlerContext ctx, Throwable cause) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.releaseAndFailAll((ChannelOutboundInvoker)ctx, cause);
        }
    }

    private void notifyClosePromise(Throwable cause) {
        if (cause == null) {
            if (this.sslClosePromise.trySuccess((Object)this.ctx.channel())) {
                this.ctx.fireChannelInboundEvent((Object)new SslCloseCompletionEvent(this.engine().getSession()));
            }
        } else if (this.sslClosePromise.tryFailure(cause)) {
            this.ctx.fireChannelInboundEvent((Object)new SslCloseCompletionEvent(this.engine().getSession(), cause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> closeOutboundAndChannel(ChannelHandlerContext ctx, boolean disconnect) {
        this.setState(32);
        this.engine.closeOutbound();
        if (!ctx.channel().isActive()) {
            if (disconnect) {
                return ctx.disconnect();
            }
            return ctx.close();
        }
        Promise promise = ctx.newPromise();
        Promise closeNotifyPromise = ctx.newPromise();
        try {
            this.flush(ctx, (Promise<Void>)closeNotifyPromise);
        }
        finally {
            if (!this.isStateSet(64)) {
                this.setState(64);
                Promise cascade = ctx.newPromise();
                cascade.asFuture().cascadeTo(promise);
                this.safeClose(ctx, (Future<Void>)closeNotifyPromise.asFuture(), (Promise<Void>)cascade);
            } else {
                this.sslCloseFuture().addListener(future -> promise.setSuccess(null));
            }
        }
        return promise.asFuture();
    }

    private void flush(ChannelHandlerContext ctx, Promise<Void> promise) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.add(ctx.bufferAllocator().allocate(0), promise);
        } else {
            promise.setFailure((Throwable)SslHandler.newPendingWritesNullException());
        }
        this.flush(ctx);
    }

    public void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        Channel channel = ctx.channel();
        this.pendingUnencryptedWrites = new SslHandlerCoalescingBufferQueue(16);
        this.setOpensslEngineSocketFd(channel);
        boolean fastOpen = channel.isOptionSupported(ChannelOption.TCP_FASTOPEN_CONNECT) && Boolean.TRUE.equals(channel.getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
        boolean active = channel.isActive();
        if (active || fastOpen) {
            this.startHandshakeProcessing(active);
            if (fastOpen) {
                this.setState(16);
            }
        }
    }

    private void startHandshakeProcessing(boolean flushAtEnd) {
        if (!this.isStateSet(8)) {
            this.setState(8);
            if (this.engine.getUseClientMode()) {
                this.handshake(flushAtEnd);
            }
            this.applyHandshakeTimeout();
        } else if (this.isStateSet(16)) {
            this.forceFlush(this.ctx);
        }
    }

    public Future<Channel> renegotiate() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate((Promise<Channel>)ctx.executor().newPromise());
    }

    public Future<Channel> renegotiate(Promise<Channel> promise) {
        Objects.requireNonNull(promise, "promise");
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException();
        }
        EventExecutor executor = ctx.executor();
        if (!executor.inEventLoop()) {
            executor.execute(() -> this.renegotiateOnEventLoop(promise));
            return promise.asFuture();
        }
        this.renegotiateOnEventLoop(promise);
        return promise.asFuture();
    }

    private void renegotiateOnEventLoop(Promise<Channel> newHandshakePromise) {
        Future<Channel> oldHandshakePromise = this.handshakeFuture();
        if (!oldHandshakePromise.isDone()) {
            oldHandshakePromise.cascadeTo(newHandshakePromise);
        } else {
            this.handshakePromise = newHandshakePromise;
            this.handshake(true);
            this.applyHandshakeTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(boolean flushAtEnd) {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return;
        }
        if (this.handshakePromise.isDone()) {
            return;
        }
        ChannelHandlerContext ctx = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData(ctx, false);
        }
        catch (Throwable e) {
            this.setHandshakeFailure(ctx, e);
        }
        finally {
            if (flushAtEnd) {
                this.forceFlush(ctx);
            }
        }
    }

    private void applyHandshakeTimeout() {
        Promise<Channel> localHandshakePromise = this.handshakePromise;
        long handshakeTimeoutMillis = this.handshakeTimeoutMillis;
        if (handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        Future timeoutFuture = this.ctx.executor().schedule(() -> {
            if (localHandshakePromise.isDone()) {
                return;
            }
            SslHandshakeTimeoutException exception = new SslHandshakeTimeoutException("handshake timed out after " + handshakeTimeoutMillis + "ms");
            try {
                if (localHandshakePromise.tryFailure((Throwable)exception)) {
                    SslUtils.handleHandshakeFailure(this.ctx, this.engine().getSession(), this.applicationProtocol(), exception, true);
                }
            }
            finally {
                this.releaseAndFailAll(this.ctx, exception);
            }
        }, handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        localHandshakePromise.asFuture().addListener(f -> timeoutFuture.cancel());
    }

    private void forceFlush(ChannelHandlerContext ctx) {
        this.clearState(16);
        ctx.flush();
    }

    private void setOpensslEngineSocketFd(Channel c) {
        if (c instanceof UnixChannel && this.engine instanceof ReferenceCountedOpenSslEngine) {
            ((ReferenceCountedOpenSslEngine)this.engine).bioSetFd(((UnixChannel)c).fd().intValue());
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.setOpensslEngineSocketFd(ctx.channel());
        if (!this.startTls) {
            this.startHandshakeProcessing(true);
        }
        ctx.fireChannelActive();
    }

    private void safeClose(ChannelHandlerContext ctx, Future<Void> flushFuture, Promise<Void> promise) {
        long closeNotifyTimeout;
        if (!ctx.channel().isActive()) {
            ctx.close().cascadeTo(promise);
            return;
        }
        Future timeoutFuture = !flushFuture.isDone() ? ((closeNotifyTimeout = this.closeNotifyFlushTimeoutMillis) > 0L ? ctx.executor().schedule(() -> {
            if (!flushFuture.isDone()) {
                logger.warn("{} Last write attempt timed out; force-closing the connection.", (Object)ctx.channel());
                SslHandler.addCloseListener((Future<Void>)ctx.close(), promise);
            }
        }, closeNotifyTimeout, TimeUnit.MILLISECONDS) : null) : null;
        flushFuture.addListener(f -> {
            long closeNotifyReadTimeout;
            if (timeoutFuture != null) {
                timeoutFuture.cancel();
            }
            if ((closeNotifyReadTimeout = this.closeNotifyReadTimeoutMillis) <= 0L) {
                if (ctx.channel().isActive()) {
                    SslHandler.addCloseListener((Future<Void>)ctx.close(), promise);
                } else {
                    promise.trySuccess(null);
                }
            } else {
                Future<Channel> closeFuture = this.sslCloseFuture();
                Future closeNotifyReadTimeoutFuture = !closeFuture.isDone() ? ctx.executor().schedule(() -> {
                    if (!closeFuture.isDone()) {
                        logger.debug("{} did not receive close_notify in {}ms; force-closing the connection.", (Object)ctx.channel(), (Object)closeNotifyReadTimeout);
                        SslHandler.addCloseListener((Future<Void>)ctx.close(), promise);
                    }
                }, closeNotifyReadTimeout, TimeUnit.MILLISECONDS) : null;
                closeFuture.addListener(future -> {
                    if (closeNotifyReadTimeoutFuture != null) {
                        closeNotifyReadTimeoutFuture.cancel();
                    }
                    if (ctx.channel().isActive()) {
                        SslHandler.addCloseListener((Future<Void>)ctx.close(), promise);
                    } else {
                        promise.trySuccess(null);
                    }
                });
            }
        });
    }

    private static void addCloseListener(Future<Void> future, Promise<Void> promise) {
        future.cascadeTo(promise);
    }

    private Buffer allocate(ChannelHandlerContext ctx, int capacity) {
        BufferAllocator alloc = ctx.bufferAllocator();
        boolean hasDirect = alloc.getAllocationType().isDirect();
        boolean wantsDirect = this.engineType.wantsDirectBuffer;
        if (hasDirect && !wantsDirect) {
            alloc = DefaultBufferAllocators.onHeapAllocator();
        } else if (!hasDirect && wantsDirect) {
            alloc = DefaultBufferAllocators.offHeapAllocator();
        }
        return alloc.allocate(capacity);
    }

    private Buffer allocateOutNetBuf(ChannelHandlerContext ctx, int pendingBytes, int numComponents) {
        return this.engineType.allocateWrapBuffer(this, ctx.bufferAllocator(), pendingBytes, numComponents);
    }

    private boolean isStateSet(int bit) {
        return (this.state & bit) == bit;
    }

    private void setState(int bit) {
        this.state = (short)(this.state | bit);
    }

    private void clearState(int bit) {
        this.state = (short)(this.state & ~bit);
    }

    public long pendingOutboundBytes(ChannelHandlerContext ctx) {
        return this.pendingUnencryptedWrites == null ? 0L : (long)this.pendingUnencryptedWrites.readableBytes();
    }

    private final class LazyPromise
    extends DefaultPromise<Channel> {
        LazyPromise() {
            super((EventExecutor)ImmediateEventExecutor.INSTANCE);
        }

        protected void checkDeadLock() {
            if (SslHandler.this.ctx == null) {
                return;
            }
            this.checkDeadLock(SslHandler.this.ctx.executor());
        }
    }

    private final class SslHandlerCoalescingBufferQueue
    extends AbstractCoalescingBufferQueue {
        SslHandlerCoalescingBufferQueue(int initSize) {
            super(initSize);
        }

        protected Buffer compose(BufferAllocator alloc, Buffer cumulation, Buffer next) {
            if (cumulation.writableBytes() >= next.readableBytes()) {
                cumulation.writeBytes(next);
                next.close();
                return cumulation;
            }
            if (cumulation instanceof CompositeBuffer) {
                CompositeBuffer composite = (CompositeBuffer)cumulation;
                if (next.readableBytes() < SslHandler.this.wrapDataSize / 2) {
                    composite.ensureWritable(SslHandler.this.wrapDataSize);
                    composite.writeBytes(next);
                    next.close();
                } else {
                    composite.extendWith(next.send());
                }
                return composite;
            }
            int minIncrement = 2 * SslHandler.this.wrapDataSize;
            cumulation = this.copyAndCompose(alloc, cumulation, next, minIncrement);
            return cumulation;
        }

        protected Buffer composeFirst(BufferAllocator allocator, Buffer first) {
            if (first instanceof CompositeBuffer) {
                CompositeBuffer composite = (CompositeBuffer)first;
                first = SslHandler.this.engineType.wantsDirectBuffer && !allocator.getAllocationType().isDirect() ? DefaultBufferAllocators.offHeapAllocator().allocate(composite.readableBytes()) : allocator.allocate(composite.readableBytes());
                try {
                    first.writeBytes((Buffer)composite);
                }
                catch (Throwable cause) {
                    first.close();
                    throw cause;
                }
                composite.close();
            }
            return first;
        }

        protected Buffer removeEmptyValue() {
            return null;
        }
    }

    private final class SslTasksRunner
    implements Runnable {
        private final boolean inUnwrap;
        private final Runnable runCompleteTask = this::runComplete;

        SslTasksRunner(boolean inUnwrap) {
            this.inUnwrap = inUnwrap;
        }

        private void taskError(Throwable e) {
            if (this.inUnwrap) {
                try {
                    SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, e);
                }
                catch (Throwable cause) {
                    this.safeExceptionCaught(cause);
                }
            } else {
                SslHandler.this.setHandshakeFailure(SslHandler.this.ctx, e);
                SslHandler.this.forceFlush(SslHandler.this.ctx);
            }
        }

        private void safeExceptionCaught(Throwable cause) {
            try {
                SslHandler.this.channelExceptionCaught(SslHandler.this.ctx, this.wrapIfNeeded(cause));
            }
            catch (Throwable error) {
                SslHandler.this.ctx.fireChannelExceptionCaught(error);
            }
        }

        private Throwable wrapIfNeeded(Throwable cause) {
            if (!this.inUnwrap) {
                return cause;
            }
            return cause instanceof DecoderException ? cause : new DecoderException(cause);
        }

        private void tryDecodeAgain() {
            try {
                SslHandler.this.channelRead(SslHandler.this.ctx, SslHandler.this.ctx.bufferAllocator().allocate(0));
            }
            catch (Throwable cause) {
                this.safeExceptionCaught(cause);
            }
            finally {
                SslHandler.this.channelReadComplete0(SslHandler.this.ctx);
            }
        }

        private void resumeOnEventExecutor() {
            assert (SslHandler.this.ctx.executor().inEventLoop());
            SslHandler.this.clearState(128);
            try {
                SSLEngineResult.HandshakeStatus status = SslHandler.this.engine.getHandshakeStatus();
                switch (status) {
                    case NEED_TASK: {
                        SslHandler.this.executeDelegatedTask(this);
                        break;
                    }
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        SslHandler.this.setHandshakeSuccess();
                        try {
                            SslHandler.this.wrap(SslHandler.this.ctx, this.inUnwrap);
                        }
                        catch (Throwable e) {
                            this.taskError(e);
                            return;
                        }
                        if (this.inUnwrap) {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        SslHandler.this.forceFlush(SslHandler.this.ctx);
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_UNWRAP: {
                        try {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        catch (SSLException e) {
                            SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, e);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_WRAP: {
                        try {
                            if (!SslHandler.this.wrapNonAppData(SslHandler.this.ctx, false) && this.inUnwrap) {
                                SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                            }
                            SslHandler.this.forceFlush(SslHandler.this.ctx);
                        }
                        catch (Throwable e) {
                            this.taskError(e);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (Throwable cause) {
                this.safeExceptionCaught(cause);
            }
        }

        void runComplete() {
            EventExecutor executor = SslHandler.this.ctx.executor();
            executor.execute(this::resumeOnEventExecutor);
        }

        @Override
        public void run() {
            try {
                Runnable task = SslHandler.this.engine.getDelegatedTask();
                if (task == null) {
                    return;
                }
                if (task instanceof AsyncRunnable) {
                    AsyncRunnable asyncTask = (AsyncRunnable)task;
                    asyncTask.run(this.runCompleteTask);
                } else {
                    task.run();
                    this.runComplete();
                }
            }
            catch (Throwable cause) {
                this.handleException(cause);
            }
        }

        private void handleException(Throwable cause) {
            EventExecutor executor = SslHandler.this.ctx.executor();
            if (executor.inEventLoop()) {
                SslHandler.this.clearState(128);
                this.safeExceptionCaught(cause);
            } else {
                try {
                    executor.execute(() -> {
                        SslHandler.this.clearState(128);
                        this.safeExceptionCaught(cause);
                    });
                }
                catch (RejectedExecutionException ignore) {
                    SslHandler.this.clearState(128);
                    SslHandler.this.ctx.fireChannelExceptionCaught(cause);
                }
            }
        }
    }

    private final class AsyncTaskCompletionHandler
    implements Runnable {
        private final boolean inUnwrap;
        boolean didRun;
        boolean resumeLater;

        AsyncTaskCompletionHandler(boolean inUnwrap) {
            this.inUnwrap = inUnwrap;
        }

        @Override
        public void run() {
            this.didRun = true;
            if (this.resumeLater) {
                SslHandler.this.getTaskRunner(this.inUnwrap).runComplete();
            }
        }

        boolean resumeLater() {
            if (!this.didRun) {
                this.resumeLater = true;
                return true;
            }
            return false;
        }
    }

    private static enum SslEngineType {
        TCNATIVE(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            @Override
            Buffer allocateWrapBuffer(SslHandler handler, BufferAllocator allocator, int pendingBytes, int numComponents) {
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)handler.engine;
                int maxWrapLength = engine.calculateMaxLengthForWrap(pendingBytes, numComponents);
                if (allocator.getAllocationType() != StandardAllocationTypes.OFF_HEAP) {
                    allocator = DefaultBufferAllocators.offHeapAllocator();
                }
                return allocator.allocate(maxWrapLength);
            }

            @Override
            int calculatePendingData(SslHandler handler, int guess) {
                int sslPending = ((ReferenceCountedOpenSslEngine)handler.engine).sslPending();
                return sslPending > 0 ? sslPending : guess;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine engine) {
                return ((ReferenceCountedOpenSslEngine)engine).jdkCompatibilityMode;
            }
        }
        ,
        CONSCRYPT(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            @Override
            Buffer allocateWrapBuffer(SslHandler handler, BufferAllocator allocator, int pendingBytes, int numComponents) {
                ConscryptAlpnSslEngine engine = (ConscryptAlpnSslEngine)handler.engine;
                int size = engine.calculateOutNetBufSize(pendingBytes, numComponents);
                if (allocator.getAllocationType() != StandardAllocationTypes.OFF_HEAP) {
                    allocator = DefaultBufferAllocators.offHeapAllocator();
                }
                return allocator.allocate(size);
            }

            @Override
            int calculatePendingData(SslHandler handler, int guess) {
                return guess;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine engine) {
                return true;
            }
        }
        ,
        JDK(false, ByteToMessageDecoder.MERGE_CUMULATOR){

            @Override
            Buffer allocateWrapBuffer(SslHandler handler, BufferAllocator allocator, int pendingBytes, int numComponents) {
                if (allocator.getAllocationType() == StandardAllocationTypes.OFF_HEAP) {
                    allocator = DefaultBufferAllocators.onHeapAllocator();
                }
                return allocator.allocate(handler.engine.getSession().getPacketBufferSize());
            }

            @Override
            int calculatePendingData(SslHandler handler, int guess) {
                return guess;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine engine) {
                return true;
            }
        };

        final boolean wantsDirectBuffer;
        final ByteToMessageDecoder.Cumulator cumulator;

        static SslEngineType forEngine(SSLEngine engine) {
            return engine instanceof ReferenceCountedOpenSslEngine ? TCNATIVE : (engine instanceof ConscryptAlpnSslEngine ? CONSCRYPT : JDK);
        }

        private SslEngineType(boolean wantsDirectBuffer, ByteToMessageDecoder.Cumulator cumulator) {
            this.wantsDirectBuffer = wantsDirectBuffer;
            this.cumulator = cumulator;
        }

        abstract int calculatePendingData(SslHandler var1, int var2);

        abstract boolean jdkCompatibilityMode(SSLEngine var1);

        abstract Buffer allocateWrapBuffer(SslHandler var1, BufferAllocator var2, int var3, int var4);
    }
}

