/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class JdkAlpnSslUtils {
    private static final InternalLogger logger;
    private static final MethodHandle SET_APPLICATION_PROTOCOLS;
    private static final MethodHandle GET_APPLICATION_PROTOCOL;
    private static final MethodHandle GET_HANDSHAKE_APPLICATION_PROTOCOL;
    private static final MethodHandle SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final MethodHandle GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;

    private JdkAlpnSslUtils() {
    }

    static boolean supportsAlpn() {
        return GET_APPLICATION_PROTOCOL != null;
    }

    static String getApplicationProtocol(SSLEngine sslEngine) {
        try {
            return GET_APPLICATION_PROTOCOL.invokeExact(sslEngine);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    static String getHandshakeApplicationProtocol(SSLEngine sslEngine) {
        try {
            return GET_HANDSHAKE_APPLICATION_PROTOCOL.invokeExact(sslEngine);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    static void setApplicationProtocols(SSLEngine engine, List<String> supportedProtocols) {
        SSLParameters parameters = engine.getSSLParameters();
        String[] protocolArray = supportedProtocols.toArray(EmptyArrays.EMPTY_STRINGS);
        try {
            SET_APPLICATION_PROTOCOLS.invokeExact(parameters, protocolArray);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
        engine.setSSLParameters(parameters);
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine engine, BiFunction<SSLEngine, List<String>, String> selector) {
        try {
            SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invokeExact(engine, selector);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine engine) {
        try {
            return GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invokeExact(engine);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    static {
        MethodHandle getHandshakeApplicationProtocolSelector;
        MethodHandle setHandshakeApplicationProtocolSelector;
        MethodHandle setApplicationProtocols;
        MethodHandle getApplicationProtocol;
        MethodHandle getHandshakeApplicationProtocol;
        logger = InternalLoggerFactory.getInstance(JdkAlpnSslUtils.class);
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            SSLEngine engine = context.createSSLEngine();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            getHandshakeApplicationProtocol = AccessController.doPrivileged(() -> lookup.findVirtual(SSLEngine.class, "getHandshakeApplicationProtocol", MethodType.methodType(String.class)));
            String getHandshakeApplicationProtocolRes = getHandshakeApplicationProtocol.invokeExact(engine);
            getApplicationProtocol = AccessController.doPrivileged(() -> lookup.findVirtual(SSLEngine.class, "getApplicationProtocol", MethodType.methodType(String.class)));
            String getApplicationProtocolRes = getApplicationProtocol.invokeExact(engine);
            setApplicationProtocols = AccessController.doPrivileged(() -> lookup.findVirtual(SSLParameters.class, "setApplicationProtocols", MethodType.methodType(Void.TYPE, String[].class)));
            setApplicationProtocols.invokeExact(engine.getSSLParameters(), EmptyArrays.EMPTY_STRINGS);
            setHandshakeApplicationProtocolSelector = AccessController.doPrivileged(() -> lookup.findVirtual(SSLEngine.class, "setHandshakeApplicationProtocolSelector", MethodType.methodType(Void.TYPE, BiFunction.class)));
            setHandshakeApplicationProtocolSelector.invokeExact(engine, (sslEngine, strings) -> null);
            getHandshakeApplicationProtocolSelector = AccessController.doPrivileged(() -> lookup.findVirtual(SSLEngine.class, "getHandshakeApplicationProtocolSelector", MethodType.methodType(BiFunction.class)));
            BiFunction biFunction = getHandshakeApplicationProtocolSelector.invokeExact(engine);
        }
        catch (Throwable t) {
            int version = PlatformDependent.javaVersion();
            logger.error("Unable to initialize JdkAlpnSslUtils. Detected java version was: {}", (Object)version, (Object)t);
            getHandshakeApplicationProtocol = null;
            getApplicationProtocol = null;
            setApplicationProtocols = null;
            setHandshakeApplicationProtocolSelector = null;
            getHandshakeApplicationProtocolSelector = null;
        }
        GET_HANDSHAKE_APPLICATION_PROTOCOL = getHandshakeApplicationProtocol;
        GET_APPLICATION_PROTOCOL = getApplicationProtocol;
        SET_APPLICATION_PROTOCOLS = setApplicationProtocols;
        SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = setHandshakeApplicationProtocolSelector;
        GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = getHandshakeApplicationProtocolSelector;
    }
}

