/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.ssl.SniCompletionEvent;
import io.netty5.handler.ssl.SslClientHelloHandler;
import io.netty5.util.concurrent.Future;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public abstract class AbstractSniHandler<T>
extends SslClientHelloHandler<T> {
    private String hostname;

    private static String extractSniHostname(Buffer in) {
        int offset = in.readerOffset();
        int endOffset = in.writerOffset();
        if (endOffset - (offset += 34) >= 6) {
            int extensionsLength;
            int extensionsLimit;
            int sessionIdLength = in.getUnsignedByte(offset);
            int cipherSuitesLength = in.getUnsignedShort(offset += sessionIdLength + 1);
            int compressionMethodLength = in.getUnsignedByte(offset += cipherSuitesLength + 2);
            offset += compressionMethodLength + 1;
            if ((extensionsLimit = (offset += 2) + (extensionsLength = in.getUnsignedShort(offset))) <= endOffset) {
                while (extensionsLimit - offset >= 4) {
                    int extensionLength;
                    int extensionType = in.getUnsignedShort(offset);
                    offset += 2;
                    if (extensionsLimit - (offset += 2) < (extensionLength = in.getUnsignedShort(offset))) break;
                    if (extensionType == 0) {
                        int serverNameLength;
                        if (extensionsLimit - (offset += 2) < 3) break;
                        int serverNameType = in.getUnsignedByte(offset);
                        ++offset;
                        if (serverNameType != 0 || extensionsLimit - (offset += 2) < (serverNameLength = in.getUnsignedShort(offset))) break;
                        String hostname = InternalBufferUtils.copyToCharSequence((Buffer)in, (int)offset, (int)serverNameLength, (Charset)StandardCharsets.US_ASCII).toString();
                        return hostname.toLowerCase(Locale.US);
                    }
                    offset += extensionLength;
                }
            }
        }
        return null;
    }

    @Override
    protected Future<T> lookup(ChannelHandlerContext ctx, Buffer clientHello) throws Exception {
        this.hostname = clientHello == null ? null : AbstractSniHandler.extractSniHostname(clientHello);
        return this.lookup(ctx, this.hostname);
    }

    @Override
    protected void onLookupComplete(ChannelHandlerContext ctx, Future<? extends T> future) throws Exception {
        try {
            this.onLookupComplete(ctx, this.hostname, future);
        }
        catch (Throwable throwable) {
            AbstractSniHandler.fireSniCompletionEvent(ctx.isRemoved() ? ctx.pipeline().firstContext() : ctx, this.hostname, future);
            throw throwable;
        }
        AbstractSniHandler.fireSniCompletionEvent(ctx.isRemoved() ? ctx.pipeline().firstContext() : ctx, this.hostname, future);
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<? extends T> var3) throws Exception;

    private static void fireSniCompletionEvent(ChannelHandlerContext ctx, String hostname, Future<?> future) {
        Throwable cause = future.cause();
        if (cause == null) {
            ctx.fireChannelInboundEvent((Object)new SniCompletionEvent(hostname));
        } else {
            ctx.fireChannelInboundEvent((Object)new SniCompletionEvent(hostname, cause));
        }
    }
}

