/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.string;

import io.netty5.buffer.BufferUtil;
import io.netty5.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class LineSeparator {
    public static final LineSeparator DEFAULT = new LineSeparator(StringUtil.NEWLINE);
    public static final LineSeparator UNIX = new LineSeparator("\n");
    public static final LineSeparator WINDOWS = new LineSeparator("\r\n");
    private final String value;

    public LineSeparator(String lineSeparator) {
        this.value = Objects.requireNonNull(lineSeparator, "lineSeparator");
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineSeparator)) {
            return false;
        }
        LineSeparator that = (LineSeparator)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return BufferUtil.hexDump((byte[])this.value.getBytes(StandardCharsets.UTF_8));
    }
}

