/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import com.github.luben.zstd.Zstd;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.handler.codec.EncoderException;
import io.netty5.handler.codec.compression.CompressionException;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public final class ZstdCompressor
implements Compressor {
    private final int blockSize;
    private final int compressionLevel;
    private final int maxEncodeSize;
    private State state = State.PROCESSING;

    public static Supplier<ZstdCompressor> newFactory() {
        return ZstdCompressor.newFactory(3, 65536, 0x2000000);
    }

    public static Supplier<ZstdCompressor> newFactory(int compressionLevel) {
        return ZstdCompressor.newFactory(compressionLevel, 65536, 0x2000000);
    }

    public static Supplier<ZstdCompressor> newFactory(int blockSize, int maxEncodeSize) {
        return ZstdCompressor.newFactory(3, blockSize, maxEncodeSize);
    }

    public static Supplier<ZstdCompressor> newFactory(int compressionLevel, int blockSize, int maxEncodeSize) {
        ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)22, (String)"compressionLevel");
        ObjectUtil.checkPositive((int)blockSize, (String)"blockSize");
        ObjectUtil.checkPositive((int)maxEncodeSize, (String)"maxEncodeSize");
        return () -> new ZstdCompressor(compressionLevel, blockSize, maxEncodeSize);
    }

    private ZstdCompressor(int compressionLevel, int blockSize, int maxEncodeSize) {
        this.compressionLevel = compressionLevel;
        this.blockSize = blockSize;
        this.maxEncodeSize = maxEncodeSize;
    }

    private Buffer allocateBuffer(BufferAllocator allocator, Buffer msg) {
        int remaining = msg.readableBytes();
        long bufferSize = 0L;
        while (remaining > 0) {
            int curSize = Math.min(this.blockSize, remaining);
            remaining -= curSize;
            bufferSize += Zstd.compressBound((long)curSize);
        }
        if (bufferSize > (long)this.maxEncodeSize || 0L > bufferSize) {
            throw new EncoderException("requested encode buffer size (" + bufferSize + " bytes) exceeds the maximum allowable size (" + this.maxEncodeSize + " bytes)");
        }
        return allocator.allocate((int)bufferSize);
    }

    @Override
    public Buffer compress(Buffer in, BufferAllocator allocator) throws CompressionException {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                if (in.readableBytes() == 0) {
                    return allocator.allocate(0);
                }
                Buffer out = this.allocateBuffer(allocator, in);
                try {
                    this.compressData(in, out);
                    return out;
                }
                catch (Throwable cause) {
                    out.close();
                    throw cause;
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Buffer finish(BufferAllocator allocator) {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: 
            case PROCESSING: {
                this.state = State.FINISHED;
                return allocator.allocate(0);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.state != State.PROCESSING;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
    }

    private void compressData(Buffer in, Buffer out) {
        int flushableBytes = in.readableBytes();
        if (flushableBytes == 0) {
            return;
        }
        int bufSize = (int)Zstd.compressBound((long)flushableBytes);
        out.ensureWritable(bufSize);
        try {
            assert (out.countWritableComponents() == 1);
            try (ComponentIterator writableIteration = out.forEachComponent();){
                BufferComponent writableComponent = (BufferComponent)writableIteration.firstWritable();
                try (ComponentIterator readableIteration = in.forEachComponent();){
                    BufferComponent readableComponent = (BufferComponent)readableIteration.firstReadable();
                    while (readableComponent != null) {
                        int compressedLength;
                        if (in.isDirect() && out.isDirect()) {
                            ByteBuffer inNioBuffer = readableComponent.readableBuffer();
                            compressedLength = Zstd.compress((ByteBuffer)writableComponent.writableBuffer(), (ByteBuffer)inNioBuffer, (int)this.compressionLevel);
                        } else {
                            int outOffset;
                            byte[] outArray;
                            int inOffset;
                            byte[] inArray;
                            int inLen = readableComponent.readableBytes();
                            if (readableComponent.hasReadableArray()) {
                                inArray = readableComponent.readableArray();
                                inOffset = readableComponent.readableArrayOffset();
                            } else {
                                inArray = new byte[inLen];
                                readableComponent.readableBuffer().get(inArray);
                                inOffset = 0;
                            }
                            int outLen = writableComponent.writableBytes();
                            if (writableComponent.hasWritableArray()) {
                                outArray = writableComponent.writableArray();
                                outOffset = writableComponent.writableArrayOffset();
                            } else {
                                outArray = new byte[out.writableBytes()];
                                outOffset = 0;
                            }
                            compressedLength = (int)Zstd.compressByteArray((byte[])outArray, (int)outOffset, (int)outLen, (byte[])inArray, (int)inOffset, (int)inLen, (int)this.compressionLevel);
                            if (!writableComponent.hasWritableArray()) {
                                writableComponent.writableBuffer().put(outArray);
                            }
                        }
                        writableComponent.skipWritableBytes(compressedLength);
                        readableComponent.skipReadableBytes(readableComponent.readableBytes());
                        readableComponent = (BufferComponent)((ComponentIterator.Next)readableComponent).nextReadable();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CompressionException(e);
        }
    }

    private static enum State {
        PROCESSING,
        FINISHED,
        CLOSED;

    }
}

