/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.LZFException;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.handler.codec.compression.DecompressionException;
import io.netty5.handler.codec.compression.Decompressor;
import java.util.function.Supplier;

public final class LzfDecompressor
implements Decompressor {
    private State currentState = State.INIT_BLOCK;
    private static final short MAGIC_NUMBER = 23126;
    private ChunkDecoder decoder;
    private BufferRecycler recycler;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;

    private LzfDecompressor(boolean safeInstance) {
        this.decoder = safeInstance ? ChunkDecoderFactory.safeInstance() : ChunkDecoderFactory.optimalInstance();
        this.recycler = BufferRecycler.instance();
    }

    public static Supplier<LzfDecompressor> newFactory() {
        return LzfDecompressor.newFactory(false);
    }

    public static Supplier<LzfDecompressor> newFactory(boolean safeInstance) {
        return () -> new LzfDecompressor(safeInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public Buffer decompress(Buffer in, BufferAllocator allocator) throws DecompressionException {
        try {
            switch (1.$SwitchMap$io$netty5$handler$codec$compression$LzfDecompressor$State[this.currentState.ordinal()]) {
                case 1: 
                case 2: {
                    return allocator.allocate(0);
                }
                case 3: {
                    throw new DecompressionException("Decompressor closed");
                }
                case 4: {
                    if (in.readableBytes() < 5) {
                        return null;
                    }
                    magic = in.readUnsignedShort();
                    if (magic != 23126) {
                        this.streamCorrupted("unexpected block identifier");
                    }
                    type = in.readByte();
                    switch (type) {
                        case 0: {
                            this.isCompressed = false;
                            this.currentState = State.DECOMPRESS_DATA;
                            break;
                        }
                        case 1: {
                            this.isCompressed = true;
                            this.currentState = State.INIT_ORIGINAL_LENGTH;
                            break;
                        }
                        default: {
                            this.streamCorrupted(String.format("unknown type of chunk: %d (expected: %d or %d)", new Object[]{(int)type, 0, 1}));
                        }
                    }
                    this.chunkLength = in.readUnsignedShort();
                    if (this.chunkLength > 65535) {
                        this.streamCorrupted(String.format("chunk length exceeds maximum: %d (expected: =< %d)", new Object[]{this.chunkLength, 65535}));
                    }
                    if (type != 1) {
                        return null;
                    }
                }
                case 5: {
                    if (in.readableBytes() < 2) {
                        return null;
                    }
                    this.originalLength = in.readUnsignedShort();
                    if (this.originalLength > 65535) {
                        this.streamCorrupted(String.format("original length exceeds maximum: %d (expected: =< %d)", new Object[]{this.chunkLength, 65535}));
                    }
                    this.currentState = State.DECOMPRESS_DATA;
                }
                case 6: {
                    chunkLength = this.chunkLength;
                    if (in.readableBytes() < chunkLength) {
                        return null;
                    }
                    originalLength = this.originalLength;
                    if (!this.isCompressed) ** GOTO lbl84
                    if (in.countReadableComponents() == 1) {
                        readableIteration = in.forEachComponent();
                        try {
                            readableComponent = (BufferComponent)readableIteration.firstReadable();
                            if (readableComponent.hasReadableArray()) {
                                inputArray = readableComponent.readableArray();
                                inPos = readableComponent.readableArrayOffset();
                                try {
                                    out = this.decompress(allocator, inputArray, inPos, originalLength);
                                    in.skipReadableBytes(chunkLength);
                                    this.currentState = State.INIT_BLOCK;
                                    var12_18 = out;
                                }
                                catch (Throwable var13_19) {
                                    if (!readableComponent.hasReadableArray()) {
                                        this.recycler.releaseInputBuffer(inputArray);
                                    }
                                    throw var13_19;
                                }
                                if (!readableComponent.hasReadableArray()) {
                                    this.recycler.releaseInputBuffer(inputArray);
                                }
                                return var12_18;
                            }
                        }
                        finally {
                            if (readableIteration != null) {
                                readableIteration.close();
                            }
                        }
                    }
                    idx = in.readerOffset();
                    inputArray = this.recycler.allocInputBuffer(chunkLength);
                    in.copyInto(idx, inputArray, 0, chunkLength);
                    try {
                        out = this.decompress(allocator, inputArray, 0, originalLength);
                        in.skipReadableBytes(chunkLength);
                        this.currentState = State.INIT_BLOCK;
                        var10_16 = out;
                        return var10_16;
                    }
                    finally {
                        this.recycler.releaseInputBuffer(inputArray);
                    }
lbl84:
                    // 1 sources

                    if (chunkLength > 0) {
                        this.currentState = State.INIT_BLOCK;
                        return in.readSplit(chunkLength);
                    }
                    this.currentState = State.INIT_BLOCK;
                    return null;
                }
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            this.currentState = State.CORRUPTED;
            this.decoder = null;
            this.recycler = null;
            if (e instanceof DecompressionException) {
                throw (DecompressionException)e;
            }
            throw new DecompressionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer decompress(BufferAllocator allocator, byte[] inputArray, int offset, int len) throws LZFException {
        byte[] outputArray = this.recycler.allocOutputBuffer(len);
        try {
            this.decoder.decodeChunk(inputArray, offset, outputArray, 0, len);
            Buffer buffer = allocator.allocate(len).writeBytes(outputArray, 0, len);
            return buffer;
        }
        finally {
            this.recycler.releaseOutputBuffer(outputArray);
        }
    }

    private void streamCorrupted(String message) {
        this.currentState = State.CORRUPTED;
        throw new DecompressionException(message);
    }

    @Override
    public boolean isFinished() {
        switch (this.currentState) {
            case FINISHED: 
            case CORRUPTED: 
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.currentState == State.CLOSED;
    }

    @Override
    public void close() {
        this.currentState = State.CLOSED;
    }

    private static enum State {
        INIT_BLOCK,
        INIT_ORIGINAL_LENGTH,
        DECOMPRESS_DATA,
        CORRUPTED,
        FINISHED,
        CLOSED;

    }
}

