/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.codec.compression.Bzip2BitWriter;
import io.netty5.handler.codec.compression.Bzip2BlockCompressor;
import io.netty5.handler.codec.compression.CompressionException;
import io.netty5.handler.codec.compression.Compressor;
import java.util.function.Supplier;

public final class Bzip2Compressor
implements Compressor {
    private State currentState = State.INIT;
    private final Bzip2BitWriter writer = new Bzip2BitWriter();
    private final int streamBlockSize;
    private int streamCRC;
    private Bzip2BlockCompressor blockCompressor;
    private CompressorState compressorState = CompressorState.PROCESSING;

    private Bzip2Compressor(int blockSizeMultiplier) {
        this.streamBlockSize = blockSizeMultiplier * 100000;
    }

    public static Supplier<Bzip2Compressor> newFactory() {
        return Bzip2Compressor.newFactory(9);
    }

    public static Supplier<Bzip2Compressor> newFactory(int blockSizeMultiplier) {
        if (blockSizeMultiplier < 1 || blockSizeMultiplier > 9) {
            throw new IllegalArgumentException("blockSizeMultiplier: " + blockSizeMultiplier + " (expected: 1-9)");
        }
        return () -> new Bzip2Compressor(blockSizeMultiplier);
    }

    @Override
    public Buffer compress(Buffer in, BufferAllocator allocator) throws CompressionException {
        switch (this.compressorState) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                return this.compressData(in, allocator);
            }
        }
        throw new IllegalStateException();
    }

    private Buffer compressData(Buffer in, BufferAllocator allocator) {
        Buffer out = allocator.allocate(256);
        block6: while (true) {
            switch (this.currentState) {
                case INIT: {
                    out.ensureWritable(4);
                    out.writeMedium(4348520);
                    out.writeByte((byte)(48 + this.streamBlockSize / 100000));
                    this.currentState = State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    this.blockCompressor = new Bzip2BlockCompressor(this.writer, this.streamBlockSize);
                    this.currentState = State.WRITE_DATA;
                }
                case WRITE_DATA: {
                    if (in.readableBytes() == 0) {
                        return out;
                    }
                    Bzip2BlockCompressor blockCompressor = this.blockCompressor;
                    int length = Math.min(in.readableBytes(), blockCompressor.availableSize());
                    int bytesWritten = blockCompressor.write(in, in.readerOffset(), length);
                    in.skipReadableBytes(bytesWritten);
                    if (!blockCompressor.isFull()) {
                        if (in.readableBytes() > 0) continue block6;
                        return out;
                    }
                    this.currentState = State.CLOSE_BLOCK;
                }
                case CLOSE_BLOCK: {
                    this.closeBlock(out);
                    this.currentState = State.INIT_BLOCK;
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private void closeBlock(Buffer out) {
        Bzip2BlockCompressor blockCompressor = this.blockCompressor;
        if (!blockCompressor.isEmpty()) {
            blockCompressor.close(out);
            int blockCRC = blockCompressor.crc();
            this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ blockCRC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer finish(BufferAllocator allocator) {
        switch (this.compressorState) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                this.compressorState = CompressorState.FINISHED;
                Buffer footer = allocator.allocate(256);
                try {
                    this.closeBlock(footer);
                    int streamCRC = this.streamCRC;
                    Bzip2BitWriter writer = this.writer;
                    try {
                        writer.writeBits(footer, 24, 1536581L);
                        writer.writeBits(footer, 24, 3690640L);
                        writer.writeInt(footer, streamCRC);
                        writer.flush(footer);
                    }
                    finally {
                        this.blockCompressor = null;
                    }
                    return footer;
                }
                catch (Throwable cause) {
                    footer.close();
                    throw cause;
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.compressorState != CompressorState.PROCESSING;
    }

    @Override
    public boolean isClosed() {
        return this.compressorState == CompressorState.CLOSED;
    }

    @Override
    public void close() {
        this.compressorState = CompressorState.CLOSED;
    }

    private static enum CompressorState {
        PROCESSING,
        FINISHED,
        CLOSED;

    }

    private static enum State {
        INIT,
        INIT_BLOCK,
        WRITE_DATA,
        CLOSE_BLOCK;

    }
}

