/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.CodecException;
import io.netty5.handler.codec.MessageToMessageDecoder;
import io.netty5.handler.codec.MessageToMessageEncoder;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageCodec<INBOUND_IN, OUTBOUND_IN>
extends ChannelHandlerAdapter {
    private final MessageToMessageEncoder<Object> encoder = new MessageToMessageEncoder<Object>(){

        @Override
        public boolean acceptOutboundMessage(Object msg) throws Exception {
            return MessageToMessageCodec.this.acceptOutboundMessage(msg);
        }

        @Override
        protected void encodeAndClose(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            MessageToMessageCodec.this.encodeAndClose(ctx, msg, out);
        }
    };
    private final MessageToMessageDecoder<Object> decoder = new MessageToMessageDecoder<Object>(){

        @Override
        public boolean acceptInboundMessage(Object msg) throws Exception {
            return MessageToMessageCodec.this.acceptInboundMessage(msg);
        }

        @Override
        protected void decodeAndClose(ChannelHandlerContext ctx, Object msg) throws Exception {
            MessageToMessageCodec.this.decodeAndClose(ctx, msg);
        }
    };
    private final TypeParameterMatcher inboundMsgMatcher;
    private final TypeParameterMatcher outboundMsgMatcher;

    protected MessageToMessageCodec() {
        this.inboundMsgMatcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageCodec.class, (String)"INBOUND_IN");
        this.outboundMsgMatcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageCodec.class, (String)"OUTBOUND_IN");
    }

    protected MessageToMessageCodec(Class<? extends INBOUND_IN> inboundMessageType, Class<? extends OUTBOUND_IN> outboundMessageType) {
        this.inboundMsgMatcher = TypeParameterMatcher.get(inboundMessageType);
        this.outboundMsgMatcher = TypeParameterMatcher.get(outboundMessageType);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.decoder.channelRead(ctx, msg);
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        return this.encoder.write(ctx, msg);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.inboundMsgMatcher.match(msg);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.outboundMsgMatcher.match(msg);
    }

    protected void encode(ChannelHandlerContext ctx, OUTBOUND_IN msg, List<Object> out) throws Exception {
        throw new CodecException(((Object)((Object)this)).getClass().getName() + " must override either encode() or encodeAndClose().");
    }

    protected void encodeAndClose(ChannelHandlerContext ctx, OUTBOUND_IN msg, List<Object> out) throws Exception {
        try (AutoCloseable ignore = SilentDispose.autoClosing(msg);){
            this.encode(ctx, msg, out);
        }
    }

    protected void decode(ChannelHandlerContext ctx, INBOUND_IN msg) throws Exception {
        throw new CodecException(((Object)((Object)this)).getClass().getName() + " must override either decode() or decodeAndClose().");
    }

    protected void decodeAndClose(ChannelHandlerContext ctx, INBOUND_IN msg) throws Exception {
        try (AutoCloseable ignore = SilentDispose.autoClosing(msg);){
            this.decode(ctx, msg);
        }
    }
}

