/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelPipeline;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.handler.codec.DecoderResultProvider;
import io.netty5.handler.codec.MessageAggregationException;
import io.netty5.handler.codec.MessageToMessageDecoder;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.internal.ObjectUtil;

public abstract class MessageAggregator<I, S, C extends AutoCloseable, A extends AutoCloseable>
extends MessageToMessageDecoder<I> {
    private final int maxContentLength;
    private A currentMessage;
    private boolean handlingOversizedMessage;
    private ChannelHandlerContext ctx;
    private FutureContextListener<ChannelHandlerContext, Void> continueResponseWriteListener;
    private boolean aggregating;

    protected MessageAggregator(int maxContentLength) {
        MessageAggregator.validateMaxContentLength(maxContentLength);
        this.maxContentLength = maxContentLength;
    }

    protected MessageAggregator(int maxContentLength, Class<? extends I> inboundMessageType) {
        super(inboundMessageType);
        MessageAggregator.validateMaxContentLength(maxContentLength);
        this.maxContentLength = maxContentLength;
    }

    private static void validateMaxContentLength(int maxContentLength) {
        ObjectUtil.checkPositiveOrZero((int)maxContentLength, (String)"maxContentLength");
    }

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        if (!super.acceptInboundMessage(msg)) {
            return false;
        }
        if (this.isAggregated(msg)) {
            return false;
        }
        if (this.tryStartMessage(msg) != null) {
            this.aggregating = true;
            return true;
        }
        return this.aggregating && this.tryContentMessage(msg) != null;
    }

    protected abstract S tryStartMessage(Object var1);

    protected abstract C tryContentMessage(Object var1);

    protected abstract boolean isLastContentMessage(C var1) throws Exception;

    protected abstract boolean isAggregated(Object var1) throws Exception;

    protected abstract int lengthForContent(C var1);

    protected abstract int lengthForAggregation(A var1);

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    protected final ChannelHandlerContext ctx() {
        if (this.ctx == null) {
            throw new IllegalStateException("not added to a pipeline yet");
        }
        return this.ctx;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, I msg) throws Exception {
        assert (this.aggregating);
        S startMsg = this.tryStartMessage(msg);
        if (startMsg != null) {
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.close();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            Object continueResponse = this.newContinueResponse(startMsg, this.maxContentLength, ctx.pipeline());
            if (continueResponse != null) {
                FutureContextListener listener = this.continueResponseWriteListener;
                if (listener == null) {
                    this.continueResponseWriteListener = listener = (context, future) -> {
                        if (future.isFailed()) {
                            context.fireChannelExceptionCaught(future.cause());
                        }
                    };
                }
                boolean closeAfterWrite = this.closeAfterContinueResponse(continueResponse);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(continueResponse);
                Future future2 = ctx.writeAndFlush(continueResponse).addListener((Object)ctx, listener);
                if (closeAfterWrite) {
                    future2.addListener((Object)ctx, ChannelFutureListeners.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(startMsg, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(ctx, startMsg);
                return;
            }
            if (startMsg instanceof DecoderResultProvider && !((DecoderResultProvider)startMsg).decoderResult().isSuccess()) {
                A aggregated = this.beginAggregation(ctx.bufferAllocator(), startMsg);
                this.finishAggregation(ctx.bufferAllocator(), aggregated);
                ctx.fireChannelRead(aggregated);
                return;
            }
            this.currentMessage = this.beginAggregation(ctx.bufferAllocator(), startMsg);
            return;
        }
        C contentMsg = this.tryContentMessage(msg);
        if (contentMsg != null) {
            boolean last;
            if (this.currentMessage == null) {
                return;
            }
            if (this.lengthForAggregation(this.currentMessage) > this.maxContentLength - this.lengthForContent(contentMsg)) {
                this.invokeHandleOversizedMessage(ctx, this.currentMessage);
                return;
            }
            this.aggregate(ctx.bufferAllocator(), this.currentMessage, contentMsg);
            if (contentMsg instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)contentMsg).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    last = true;
                } else {
                    last = this.isLastContentMessage(contentMsg);
                }
            } else {
                last = this.isLastContentMessage(contentMsg);
            }
            if (last) {
                this.finishAggregation0(ctx.bufferAllocator(), this.currentMessage);
                A message = this.currentMessage;
                this.currentMessage = null;
                ctx.fireChannelRead(message);
            }
        } else {
            throw new MessageAggregationException();
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2) throws Exception;

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3) throws Exception;

    protected abstract boolean closeAfterContinueResponse(Object var1) throws Exception;

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1) throws Exception;

    protected abstract A beginAggregation(BufferAllocator var1, S var2) throws Exception;

    protected abstract void aggregate(BufferAllocator var1, A var2, C var3) throws Exception;

    private void finishAggregation0(BufferAllocator allocator, A aggregated) throws Exception {
        this.aggregating = false;
        this.finishAggregation(allocator, aggregated);
    }

    protected void finishAggregation(BufferAllocator allocator, A aggregated) throws Exception {
    }

    private void invokeHandleOversizedMessage(ChannelHandlerContext ctx, Object oversized) throws Exception {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        try {
            this.handleOversizedMessage(ctx, oversized);
        }
        finally {
            if (oversized instanceof AutoCloseable) {
                ((AutoCloseable)oversized).close();
            }
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext ctx, Object oversized) throws Exception {
        ctx.fireChannelExceptionCaught((Throwable)new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.currentMessage != null && !((Boolean)ctx.channel().getOption(ChannelOption.AUTO_READ)).booleanValue()) {
            ctx.read();
        }
        ctx.fireChannelReadComplete();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelInactive(ctx);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            super.handlerRemoved(ctx);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() throws Exception {
        if (this.currentMessage != null) {
            this.currentMessage.close();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
            this.aggregating = false;
        }
    }
}

