/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferUtil;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.EncoderException;
import io.netty5.handler.codec.MessageToMessageEncoder;
import io.netty5.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Objects;

public class LengthFieldPrepender
extends MessageToMessageEncoder<Buffer> {
    private final ByteOrder byteOrder;
    private final int lengthFieldLength;
    private final boolean lengthIncludesLengthFieldLength;
    private final int lengthAdjustment;

    public LengthFieldPrepender(int lengthFieldLength) {
        this(lengthFieldLength, false);
    }

    public LengthFieldPrepender(int lengthFieldLength, boolean lengthIncludesLengthFieldLength) {
        this(lengthFieldLength, 0, lengthIncludesLengthFieldLength);
    }

    public LengthFieldPrepender(int lengthFieldLength, int lengthAdjustment) {
        this(lengthFieldLength, lengthAdjustment, false);
    }

    public LengthFieldPrepender(int lengthFieldLength, int lengthAdjustment, boolean lengthIncludesLengthFieldLength) {
        this(ByteOrder.BIG_ENDIAN, lengthFieldLength, lengthAdjustment, lengthIncludesLengthFieldLength);
    }

    public LengthFieldPrepender(ByteOrder byteOrder, int lengthFieldLength, int lengthAdjustment, boolean lengthIncludesLengthFieldLength) {
        Objects.requireNonNull(byteOrder, "byteOrder");
        this.byteOrder = byteOrder;
        this.lengthFieldLength = lengthFieldLength;
        this.lengthIncludesLengthFieldLength = lengthIncludesLengthFieldLength;
        this.lengthAdjustment = lengthAdjustment;
    }

    public boolean isSharable() {
        return true;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Buffer buffer, List<Object> out) throws Exception {
        int length = buffer.readableBytes() + this.lengthAdjustment;
        if (this.lengthIncludesLengthFieldLength) {
            length += this.lengthFieldLength;
        }
        ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
        out.add(this.getLengthFieldBuffer(ctx, length, this.lengthFieldLength, this.byteOrder));
        out.add(buffer.split());
    }

    protected Buffer getLengthFieldBuffer(ChannelHandlerContext ctx, int length, int lengthFieldLength, ByteOrder byteOrder) {
        boolean reverseBytes = byteOrder == ByteOrder.LITTLE_ENDIAN;
        switch (lengthFieldLength) {
            case 1: {
                if (length >= 256) {
                    throw new IllegalArgumentException("length does not fit into a byte: " + length);
                }
                return ctx.bufferAllocator().allocate(lengthFieldLength).writeByte((byte)length);
            }
            case 2: {
                if (length >= 65536) {
                    throw new IllegalArgumentException("length does not fit into a short integer: " + length);
                }
                return ctx.bufferAllocator().allocate(lengthFieldLength).writeShort(reverseBytes ? Short.reverseBytes((short)length) : (short)length);
            }
            case 3: {
                if (length >= 0x1000000) {
                    throw new IllegalArgumentException("length does not fit into a medium integer: " + length);
                }
                return ctx.bufferAllocator().allocate(lengthFieldLength).writeMedium(reverseBytes ? BufferUtil.reverseMedium((int)length) : length);
            }
            case 4: {
                return ctx.bufferAllocator().allocate(lengthFieldLength).writeInt(reverseBytes ? Integer.reverseBytes(length) : length);
            }
            case 8: {
                return ctx.bufferAllocator().allocate(lengthFieldLength).writeLong(reverseBytes ? Long.reverseBytes(length) : (long)length);
            }
        }
        throw new EncoderException("unsupported lengthFieldLength: " + lengthFieldLength + " (expected: 1, 2, 3, 4, or 8)");
    }
}

