/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.MessageToByteEncoder;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.TypeParameterMatcher;

public abstract class ByteToMessageCodec<I>
extends ChannelHandlerAdapter {
    private final TypeParameterMatcher outboundMsgMatcher;
    private final MessageToByteEncoder<I> encoder;
    private final ByteToMessageDecoder decoder = new ByteToMessageDecoder(){

        @Override
        public void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
            ByteToMessageCodec.this.decode(ctx, in);
        }

        @Override
        protected void decodeLast(ChannelHandlerContext ctx, Buffer in) throws Exception {
            ByteToMessageCodec.this.decodeLast(ctx, in);
        }
    };

    protected ByteToMessageCodec() {
        this((BufferAllocator)null);
    }

    protected ByteToMessageCodec(Class<? extends I> outboundMessageType) {
        this(outboundMessageType, null);
    }

    protected ByteToMessageCodec(BufferAllocator allocator) {
        this.outboundMsgMatcher = TypeParameterMatcher.find((Object)((Object)this), ByteToMessageCodec.class, (String)"I");
        this.encoder = new Encoder(allocator);
    }

    protected ByteToMessageCodec(Class<? extends I> outboundMessageType, BufferAllocator allocator) {
        this.outboundMsgMatcher = TypeParameterMatcher.get(outboundMessageType);
        this.encoder = new Encoder(allocator);
    }

    public final boolean isSharable() {
        return false;
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.outboundMsgMatcher.match(msg);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.decoder.channelRead(ctx, msg);
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        return this.encoder.write(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelReadComplete(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelInactive(ctx);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        try {
            this.decoder.handlerAdded(ctx);
        }
        finally {
            this.encoder.handlerAdded(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            this.decoder.handlerRemoved(ctx);
        }
        finally {
            this.encoder.handlerRemoved(ctx);
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, Buffer var3) throws Exception;

    protected abstract void decode(ChannelHandlerContext var1, Buffer var2) throws Exception;

    protected void decodeLast(ChannelHandlerContext ctx, Buffer in) throws Exception {
        if (in.readableBytes() > 0) {
            this.decode(ctx, in);
        }
    }

    private final class Encoder
    extends MessageToByteEncoder<I> {
        private final BufferAllocator allocator;

        Encoder(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public boolean acceptOutboundMessage(Object msg) throws Exception {
            return ByteToMessageCodec.this.acceptOutboundMessage(msg);
        }

        @Override
        protected Buffer allocateBuffer(ChannelHandlerContext ctx, I msg) throws Exception {
            BufferAllocator alloc = this.allocator != null ? this.allocator : ctx.bufferAllocator();
            return alloc.allocate(256);
        }

        @Override
        protected void encode(ChannelHandlerContext ctx, I msg, Buffer out) throws Exception {
            ByteToMessageCodec.this.encode(ctx, msg, out);
        }
    }
}

