/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2.headers;

import io.netty5.handler.codec.http.headers.HttpCookiePair;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import io.netty5.handler.codec.http2.headers.DefaultHttp2Headers;
import io.netty5.util.AsciiString;
import java.util.Iterator;

public interface Http2Headers
extends HttpHeaders {
    public static Http2Headers emptyHeaders() {
        return Http2Headers.newHeaders(2, false, false, false);
    }

    public static Http2Headers newHeaders() {
        return Http2Headers.newHeaders(16, true, true, true);
    }

    public static Http2Headers newHeaders(boolean validate) {
        return Http2Headers.newHeaders(16, validate, validate, validate);
    }

    public static Http2Headers newHeaders(int sizeHint, boolean checkNames, boolean checkCookies, boolean checkValues) {
        return new DefaultHttp2Headers(sizeHint, checkNames, checkCookies, checkValues);
    }

    public Http2Headers copy();

    public Http2Headers add(CharSequence var1, CharSequence var2);

    public Http2Headers add(CharSequence var1, Iterable<? extends CharSequence> var2);

    default public Http2Headers add(CharSequence name, Iterator<? extends CharSequence> valuesItr) {
        super.add(name, valuesItr);
        return this;
    }

    public Http2Headers add(CharSequence var1, CharSequence ... var2);

    public Http2Headers add(HttpHeaders var1);

    public Http2Headers set(CharSequence var1, CharSequence var2);

    public Http2Headers set(CharSequence var1, Iterable<? extends CharSequence> var2);

    default public Http2Headers set(CharSequence name, Iterator<? extends CharSequence> valueItr) {
        super.set(name, valueItr);
        return this;
    }

    default public Http2Headers set(CharSequence name, CharSequence ... values) {
        super.set(name, values);
        return this;
    }

    default public Http2Headers set(HttpHeaders headers) {
        super.set(headers);
        return this;
    }

    default public Http2Headers replace(HttpHeaders headers) {
        super.replace(headers);
        return this;
    }

    public Http2Headers clear();

    public Http2Headers addCookie(HttpCookiePair var1);

    default public Http2Headers addCookie(CharSequence name, CharSequence value) {
        super.addCookie(name, value);
        return this;
    }

    public Http2Headers addSetCookie(HttpSetCookie var1);

    default public Http2Headers addSetCookie(CharSequence name, CharSequence value) {
        super.addSetCookie(name, value);
        return this;
    }

    public Http2Headers method(CharSequence var1);

    public Http2Headers scheme(CharSequence var1);

    public Http2Headers authority(CharSequence var1);

    public Http2Headers path(CharSequence var1);

    public Http2Headers status(CharSequence var1);

    public CharSequence method();

    public CharSequence scheme();

    public CharSequence authority();

    public CharSequence path();

    public CharSequence status();

    public static enum PseudoHeaderName {
        METHOD(":method", true),
        SCHEME(":scheme", true),
        AUTHORITY(":authority", true),
        PATH(":path", true),
        STATUS(":status", false),
        PROTOCOL(":protocol", true);

        private static final char PSEUDO_HEADER_PREFIX = ':';
        private static final byte PSEUDO_HEADER_PREFIX_BYTE = 58;
        private final AsciiString value;
        private final boolean requestOnly;

        private PseudoHeaderName(String value, boolean requestOnly) {
            this.value = AsciiString.cached((String)value);
            this.requestOnly = requestOnly;
        }

        public AsciiString value() {
            return this.value;
        }

        public static boolean hasPseudoHeaderFormat(CharSequence headerName) {
            if (headerName instanceof AsciiString) {
                AsciiString asciiHeaderName = (AsciiString)headerName;
                return !asciiHeaderName.isEmpty() && asciiHeaderName.byteAt(0) == 58;
            }
            return headerName.length() > 0 && headerName.charAt(0) == ':';
        }

        public static boolean isPseudoHeader(CharSequence header) {
            return PseudoHeaderName.getPseudoHeader(header) != null;
        }

        public static PseudoHeaderName getPseudoHeader(CharSequence header) {
            if (header.length() < 5 || header.charAt(0) != ':') {
                return null;
            }
            switch (header.charAt(2)) {
                case 'a': {
                    if (!AsciiString.contentEqualsIgnoreCase((CharSequence)PseudoHeaderName.PATH.value, (CharSequence)header)) break;
                    return PATH;
                }
                case 'c': {
                    if (!AsciiString.contentEqualsIgnoreCase((CharSequence)PseudoHeaderName.SCHEME.value, (CharSequence)header)) break;
                    return SCHEME;
                }
                case 'e': {
                    if (!AsciiString.contentEqualsIgnoreCase((CharSequence)PseudoHeaderName.METHOD.value, (CharSequence)header)) break;
                    return METHOD;
                }
                case 'r': {
                    if (!AsciiString.contentEqualsIgnoreCase((CharSequence)PseudoHeaderName.PROTOCOL.value, (CharSequence)header)) break;
                    return PROTOCOL;
                }
                case 't': {
                    if (!AsciiString.contentEqualsIgnoreCase((CharSequence)PseudoHeaderName.STATUS.value, (CharSequence)header)) break;
                    return STATUS;
                }
                case 'u': {
                    if (!AsciiString.contentEqualsIgnoreCase((CharSequence)PseudoHeaderName.AUTHORITY.value, (CharSequence)header)) break;
                    return AUTHORITY;
                }
            }
            return null;
        }

        public boolean isRequestOnly() {
            return this.requestOnly;
        }
    }
}

