/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.FullHttpMessage;
import io.netty5.handler.codec.http.HttpScheme;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http2.Http2Connection;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2FrameListener;
import io.netty5.handler.codec.http2.Http2Stream;
import io.netty5.handler.codec.http2.HttpConversionUtil;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.internal.UnstableApi;

@UnstableApi
public class InboundHttpToHttp2Adapter
implements ChannelHandler {
    private final Http2Connection connection;
    private final Http2FrameListener listener;

    public InboundHttpToHttp2Adapter(Http2Connection connection, Http2FrameListener listener) {
        this.connection = connection;
        this.listener = listener;
    }

    private static int getStreamId(Http2Connection connection, HttpHeaders httpHeaders) {
        CharSequence streamId = httpHeaders.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId != null) {
            return Integer.parseInt(streamId.toString());
        }
        return connection.remote().incrementAndGetNextStreamId();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage fullHttpMessage;
            try (FullHttpMessage fullHttpMessage2 = fullHttpMessage = (FullHttpMessage)msg;){
                InboundHttpToHttp2Adapter.handle(ctx, this.connection, this.listener, fullHttpMessage);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    static void handle(ChannelHandlerContext ctx, Http2Connection connection, Http2FrameListener listener, FullHttpMessage<?> message) throws Http2Exception {
        int streamId = InboundHttpToHttp2Adapter.getStreamId(connection, message.headers());
        Http2Stream stream = connection.stream(streamId);
        if (stream == null) {
            stream = connection.remote().createStream(streamId, false);
        }
        message.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (CharSequence)HttpScheme.HTTP.name());
        Http2Headers messageHeaders = HttpConversionUtil.toHttp2Headers(message, true);
        boolean hasContent = message.payload().readableBytes() > 0;
        boolean hasTrailers = !message.trailingHeaders().isEmpty();
        listener.onHeadersRead(ctx, streamId, messageHeaders, 0, !hasContent && !hasTrailers);
        if (hasContent) {
            Buffer payload = message.payload();
            listener.onDataRead(ctx, streamId, payload, 0, !hasTrailers);
        }
        if (hasTrailers) {
            Http2Headers headers = HttpConversionUtil.toHttp2Headers(message.trailingHeaders(), true);
            listener.onHeadersRead(ctx, streamId, headers, 0, true);
        }
        stream.closeRemoteSide();
    }
}

