/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.FullHttpMessage;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpScheme;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2ConnectionDecoder;
import io.netty5.handler.codec.http2.Http2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2ConnectionHandler;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.handler.codec.http2.HttpConversionUtil;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.UnstableApi;

@UnstableApi
public class HttpToHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private final boolean validateHeaders;
    private int currentStreamId;
    private HttpScheme httpScheme;

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders) {
        super(decoder, encoder, initialSettings);
        this.validateHeaders = validateHeaders;
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders, boolean decoupleCloseAndGoAway) {
        this(decoder, encoder, initialSettings, validateHeaders, decoupleCloseAndGoAway, null);
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders, boolean decoupleCloseAndGoAway, HttpScheme httpScheme) {
        super(decoder, encoder, initialSettings, decoupleCloseAndGoAway);
        this.validateHeaders = validateHeaders;
        this.httpScheme = httpScheme;
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders, boolean decoupleCloseAndGoAway, boolean flushPreface, HttpScheme httpScheme) {
        super(decoder, encoder, initialSettings, decoupleCloseAndGoAway, flushPreface);
        this.validateHeaders = validateHeaders;
        this.httpScheme = httpScheme;
    }

    private int getStreamId(HttpHeaders httpHeaders) throws Exception {
        CharSequence streamId = httpHeaders.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId == null) {
            return this.connection().local().incrementAndGetNextStreamId();
        }
        return Integer.parseInt(streamId.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpContent)) {
            return ctx.write(msg);
        }
        boolean release = true;
        Promise promise = ctx.newPromise();
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator((Promise<Void>)promise, ctx.executor());
        try {
            Http2ConnectionEncoder encoder = this.encoder();
            boolean endStream = false;
            if (msg instanceof HttpMessage) {
                HttpMessage httpMsg = (HttpMessage)msg;
                this.currentStreamId = this.getStreamId(httpMsg.headers());
                if (this.httpScheme != null && !httpMsg.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text())) {
                    httpMsg.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (CharSequence)this.httpScheme.name());
                }
                Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(httpMsg, this.validateHeaders);
                endStream = msg instanceof FullHttpMessage && ((FullHttpMessage)msg).payload().readableBytes() == 0;
                HttpToHttp2ConnectionHandler.writeHeaders(ctx, encoder, this.currentStreamId, httpMsg.headers(), http2Headers, endStream).cascadeTo(promiseAggregator.newPromise());
            }
            if (!endStream && msg instanceof HttpContent) {
                boolean isLastContent = false;
                HttpHeaders trailers = HttpHeaders.emptyHeaders();
                Http2Headers http2Trailers = Http2Headers.emptyHeaders();
                if (msg instanceof LastHttpContent) {
                    isLastContent = true;
                    LastHttpContent lastContent = (LastHttpContent)msg;
                    trailers = lastContent.trailingHeaders();
                    http2Trailers = HttpConversionUtil.toHttp2Headers(trailers, this.validateHeaders);
                }
                Buffer payload = ((HttpContent)msg).payload();
                endStream = isLastContent && trailers.isEmpty();
                encoder.writeData(ctx, this.currentStreamId, payload, 0, endStream).cascadeTo(promiseAggregator.newPromise());
                release = false;
                if (!trailers.isEmpty()) {
                    HttpToHttp2ConnectionHandler.writeHeaders(ctx, encoder, this.currentStreamId, trailers, http2Trailers, true).cascadeTo(promiseAggregator.newPromise());
                }
            }
        }
        catch (Throwable t) {
            this.onError(ctx, true, t);
            promiseAggregator.setFailure(t);
        }
        finally {
            if (release) {
                Resource.dispose((Object)msg);
            }
            promiseAggregator.doneAllocatingPromises();
        }
        return promise.asFuture();
    }

    private static Future<Void> writeHeaders(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, int streamId, HttpHeaders headers, Http2Headers http2Headers, boolean endStream) {
        CharSequence dependencyIdValue = headers.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text());
        int dependencyId = dependencyIdValue == null ? 0 : Integer.parseInt(dependencyIdValue.toString());
        CharSequence weightValue = headers.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text());
        short weight = weightValue == null ? (short)16 : (short)Short.parseShort(weightValue.toString());
        return encoder.writeHeaders(ctx, streamId, http2Headers, dependencyId, weight, false, 0, endStream);
    }
}

