/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.EncoderException;
import io.netty5.handler.codec.MessageToMessageCodec;
import io.netty5.handler.codec.http.DefaultHttpContent;
import io.netty5.handler.codec.http.DefaultLastHttpContent;
import io.netty5.handler.codec.http.FullHttpMessage;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpScheme;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.headers.HeaderValidationException;
import io.netty5.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty5.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty5.handler.codec.http2.Http2DataFrame;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.codec.http2.Http2HeadersFrame;
import io.netty5.handler.codec.http2.Http2StreamChannel;
import io.netty5.handler.codec.http2.Http2StreamFrame;
import io.netty5.handler.codec.http2.HttpConversionUtil;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.handler.ssl.SslHandler;
import io.netty5.util.Attribute;
import io.netty5.util.AttributeKey;
import io.netty5.util.Send;
import io.netty5.util.internal.UnstableApi;
import java.util.List;

@UnstableApi
public class Http2StreamFrameToHttpObjectCodec
extends MessageToMessageCodec<Http2StreamFrame, HttpObject> {
    private static final AttributeKey<HttpScheme> SCHEME_ATTR_KEY = AttributeKey.valueOf(HttpScheme.class, (String)"STREAMFRAMECODEC_SCHEME");
    private final boolean isServer;
    private final boolean validateHeaders;

    public Http2StreamFrameToHttpObjectCodec(boolean isServer, boolean validateHeaders) {
        this.isServer = isServer;
        this.validateHeaders = validateHeaders;
    }

    public Http2StreamFrameToHttpObjectCodec(boolean isServer) {
        this(isServer, true);
    }

    public boolean isSharable() {
        return true;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof Http2HeadersFrame || msg instanceof Http2DataFrame;
    }

    protected void decodeAndClose(ChannelHandlerContext ctx, Http2StreamFrame frame) throws Exception {
        if (frame instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)frame;
            Http2Headers headers = headersFrame.headers();
            Http2FrameStream stream = headersFrame.stream();
            int id = stream == null ? 0 : stream.id();
            CharSequence status = headers.status();
            if (null != status && HttpResponseStatus.CONTINUE.codeAsText().contentEquals(status)) {
                FullHttpMessage<?> fullMsg = this.newFullMessage(id, headers, ctx.bufferAllocator());
                ctx.fireChannelRead(fullMsg);
                return;
            }
            if (headersFrame.isEndStream()) {
                if (headers.method() == null && status == null) {
                    DefaultLastHttpContent last = new DefaultLastHttpContent(ctx.bufferAllocator().allocate(0), this.validateHeaders);
                    HttpConversionUtil.addHttp2ToHttpHeaders(id, headers, last.trailingHeaders(), HttpVersion.HTTP_1_1, true, true);
                    ctx.fireChannelRead((Object)last);
                } else {
                    FullHttpMessage<?> full = this.newFullMessage(id, headers, ctx.bufferAllocator());
                    ctx.fireChannelRead(full);
                }
            } else {
                HttpMessage req = this.newMessage(id, headers);
                if (!HttpUtil.isContentLengthSet((HttpMessage)req)) {
                    req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
                }
                ctx.fireChannelRead((Object)req);
            }
        } else if (frame instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)frame;
            if (dataFrame.isEndStream()) {
                ctx.fireChannelRead((Object)new DefaultLastHttpContent(dataFrame.content(), this.validateHeaders));
            } else {
                ctx.fireChannelRead((Object)new DefaultHttpContent(dataFrame.content()));
            }
        }
    }

    private void encodeLastContent(LastHttpContent<?> last, List<Object> out) {
        boolean needFiller = !(last instanceof FullHttpMessage) && last.trailingHeaders().isEmpty();
        Buffer payload = last.payload();
        if (payload.readableBytes() > 0 || needFiller) {
            out.add(new DefaultHttp2DataFrame((Send<Buffer>)payload.send(), last.trailingHeaders().isEmpty()));
        } else {
            last.close();
        }
        if (!last.trailingHeaders().isEmpty()) {
            Http2Headers headers = HttpConversionUtil.toHttp2Headers(last.trailingHeaders(), this.validateHeaders);
            out.add(new DefaultHttp2HeadersFrame(headers, true));
        }
    }

    protected void encodeAndClose(ChannelHandlerContext ctx, HttpObject obj, List<Object> out) throws Exception {
        HttpResponse res;
        if (obj instanceof HttpResponse && (res = (HttpResponse)obj).status().equals((Object)HttpResponseStatus.CONTINUE)) {
            if (res instanceof FullHttpResponse) {
                Http2Headers headers = this.toHttp2Headers(ctx, (HttpMessage)res);
                out.add(new DefaultHttp2HeadersFrame(headers, false));
                ((FullHttpResponse)res).close();
                return;
            }
            throw new EncoderException(HttpResponseStatus.CONTINUE + " must be a FullHttpResponse");
        }
        if (obj instanceof HttpMessage) {
            Http2Headers headers = this.toHttp2Headers(ctx, (HttpMessage)obj);
            boolean noMoreFrames = false;
            if (obj instanceof FullHttpMessage) {
                FullHttpMessage full = (FullHttpMessage)obj;
                noMoreFrames = full.payload().readableBytes() == 0 && full.trailingHeaders().isEmpty();
            }
            out.add(new DefaultHttp2HeadersFrame(headers, noMoreFrames));
        }
        if (obj instanceof LastHttpContent) {
            LastHttpContent last = (LastHttpContent)obj;
            this.encodeLastContent(last, out);
        } else if (obj instanceof HttpContent) {
            HttpContent cont = (HttpContent)obj;
            Buffer payload = cont.payload();
            out.add(new DefaultHttp2DataFrame((Send<Buffer>)payload.send(), false));
        }
    }

    private Http2Headers toHttp2Headers(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        try {
            if (msg instanceof HttpRequest) {
                msg.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (CharSequence)Http2StreamFrameToHttpObjectCodec.connectionScheme(ctx).name());
            }
            return HttpConversionUtil.toHttp2Headers(msg, this.validateHeaders);
        }
        catch (HeaderValidationException e) {
            throw new Http2Exception(Http2Error.PROTOCOL_ERROR, e.getMessage(), e);
        }
    }

    private HttpMessage newMessage(int id, Http2Headers headers) throws Http2Exception {
        return this.isServer ? HttpConversionUtil.toHttpRequest(id, headers, this.validateHeaders) : HttpConversionUtil.toHttpResponse(id, headers, this.validateHeaders);
    }

    private FullHttpMessage<?> newFullMessage(int id, Http2Headers headers, BufferAllocator alloc) throws Http2Exception {
        return this.isServer ? HttpConversionUtil.toFullHttpRequest(id, headers, alloc, this.validateHeaders) : HttpConversionUtil.toFullHttpResponse(id, headers, alloc, this.validateHeaders);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        Attribute<HttpScheme> schemeAttribute = Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(ctx);
        if (schemeAttribute.get() == null) {
            HttpScheme scheme = this.isSsl(ctx) ? HttpScheme.HTTPS : HttpScheme.HTTP;
            schemeAttribute.set((Object)scheme);
        }
    }

    protected boolean isSsl(ChannelHandlerContext ctx) {
        Channel connChannel = Http2StreamFrameToHttpObjectCodec.connectionChannel(ctx);
        return null != connChannel.pipeline().get(SslHandler.class);
    }

    private static HttpScheme connectionScheme(ChannelHandlerContext ctx) {
        HttpScheme scheme = (HttpScheme)Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(ctx).get();
        return scheme == null ? HttpScheme.HTTP : scheme;
    }

    private static Attribute<HttpScheme> connectionSchemeAttribute(ChannelHandlerContext ctx) {
        Channel ch = Http2StreamFrameToHttpObjectCodec.connectionChannel(ctx);
        return ch.attr(SCHEME_ATTR_KEY);
    }

    private static Channel connectionChannel(ChannelHandlerContext ctx) {
        Channel ch = ctx.channel();
        return ch instanceof Http2StreamChannel ? ch.parent() : ch;
    }
}

