/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.base64.Base64;
import io.netty5.handler.codec.base64.Base64Dialect;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.HttpServerUpgradeHandler;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2ConnectionHandler;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Flags;
import io.netty5.handler.codec.http2.Http2FrameAdapter;
import io.netty5.handler.codec.http2.Http2FrameCodec;
import io.netty5.handler.codec.http2.Http2FrameReader;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@UnstableApi
public class Http2ServerUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodec {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ServerUpgradeCodec.class);
    private static final List<CharSequence> REQUIRED_UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler[] handlers;
    private final Http2FrameReader frameReader;
    private Http2Settings settings;

    public Http2ServerUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this(null, connectionHandler, EMPTY_HANDLERS);
    }

    public Http2ServerUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler) {
        this(handlerName, connectionHandler, EMPTY_HANDLERS);
    }

    public Http2ServerUpgradeCodec(Http2FrameCodec http2Codec, ChannelHandler ... handlers) {
        this(null, http2Codec, handlers);
    }

    private Http2ServerUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, ChannelHandler ... handlers) {
        this.handlerName = handlerName;
        this.connectionHandler = connectionHandler;
        this.handlers = handlers;
        this.frameReader = new DefaultHttp2FrameReader();
    }

    public Collection<CharSequence> requiredUpgradeHeaders() {
        return REQUIRED_UPGRADE_HEADERS;
    }

    public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders headers) {
        try {
            Iterator upgradeHeaders = upgradeRequest.headers().valuesIterator(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
            if (upgradeHeaders.hasNext()) {
                CharSequence settingHeader = (CharSequence)upgradeHeaders.next();
                if (!upgradeHeaders.hasNext()) {
                    this.settings = this.decodeSettingsHeader(ctx, settingHeader);
                    return true;
                }
            }
            throw new IllegalArgumentException("There must be 1 and only 1 " + Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER + " header.");
        }
        catch (Throwable cause) {
            logger.info("Error during upgrade to HTTP/2", cause);
            return false;
        }
    }

    public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
        try {
            ctx.pipeline().addAfter(ctx.name(), this.handlerName, (ChannelHandler)this.connectionHandler);
            if (this.handlers != null) {
                String name = ctx.pipeline().context((ChannelHandler)this.connectionHandler).name();
                for (int i = this.handlers.length - 1; i >= 0; --i) {
                    ctx.pipeline().addAfter(name, null, this.handlers[i]);
                }
            }
            this.connectionHandler.onHttpServerUpgrade(this.settings);
        }
        catch (Http2Exception e) {
            ctx.fireChannelExceptionCaught((Throwable)e);
            ctx.close();
        }
    }

    private Http2Settings decodeSettingsHeader(ChannelHandlerContext ctx, CharSequence settingsHeader) throws Http2Exception {
        try (Buffer header = ctx.bufferAllocator().allocate(settingsHeader.length());){
            Http2Settings http2Settings;
            block12: {
                header.writeCharSequence(settingsHeader, StandardCharsets.UTF_8);
                Buffer payload = Base64.decode((Buffer)header, (Base64Dialect)Base64Dialect.URL_SAFE);
                try {
                    Buffer frame = Http2ServerUpgradeCodec.createSettingsFrame(ctx, payload);
                    http2Settings = this.decodeSettings(ctx, frame);
                    if (payload == null) break block12;
                }
                catch (Throwable throwable) {
                    if (payload != null) {
                        try {
                            payload.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                payload.close();
            }
            return http2Settings;
        }
    }

    private Http2Settings decodeSettings(ChannelHandlerContext ctx, Buffer frame) throws Http2Exception {
        try (Buffer buffer = frame;){
            final Http2Settings decodedSettings = new Http2Settings();
            this.frameReader.readFrame(ctx, frame, new Http2FrameAdapter(){

                @Override
                public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
                    decodedSettings.copyFrom(settings);
                }
            });
            Http2Settings http2Settings = decodedSettings;
            return http2Settings;
        }
    }

    private static Buffer createSettingsFrame(ChannelHandlerContext ctx, Buffer payload) {
        Buffer frame = ctx.bufferAllocator().allocate(9 + payload.readableBytes());
        Http2CodecUtil.writeFrameHeader(frame, payload.readableBytes(), (byte)4, new Http2Flags(), 0);
        frame.writeBytes(payload);
        return frame;
    }
}

