/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ServerChannel;
import io.netty5.handler.codec.http2.DefaultHttp2StreamChannel;
import io.netty5.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2FrameCodec;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.codec.http2.Http2FrameStreamEvent;
import io.netty5.handler.codec.http2.Http2FrameStreamException;
import io.netty5.handler.codec.http2.Http2GoAwayFrame;
import io.netty5.handler.codec.http2.Http2ResetFrame;
import io.netty5.handler.codec.http2.Http2StreamChannel;
import io.netty5.handler.codec.http2.Http2StreamFrame;
import io.netty5.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty5.handler.codec.http2.MaxCapacityQueue;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.internal.UnstableApi;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import javax.net.ssl.SSLException;

@UnstableApi
public final class Http2MultiplexHandler
extends Http2ChannelDuplexHandler {
    private static final FutureContextListener<Channel, Void> CHILD_CHANNEL_REGISTRATION_LISTENER = Http2MultiplexHandler::registerDone;
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<DefaultHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<DefaultHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    private volatile ChannelHandlerContext ctx;

    public Http2MultiplexHandler(ChannelHandler inboundStreamHandler) {
        this(inboundStreamHandler, null);
    }

    public Http2MultiplexHandler(ChannelHandler inboundStreamHandler, ChannelHandler upgradeStreamHandler) {
        this.inboundStreamHandler = Objects.requireNonNull(inboundStreamHandler, "inboundStreamHandler");
        this.upgradeStreamHandler = upgradeStreamHandler;
    }

    private static void registerDone(Channel childChannel, Future<?> future) {
        if (future.isFailed()) {
            if (childChannel.isRegistered()) {
                childChannel.close();
            } else {
                ((DefaultHttp2StreamChannel)childChannel).closeForcibly();
            }
        }
    }

    @Override
    protected void handlerAdded0(ChannelHandlerContext ctx) {
        if (ctx.executor().inEventLoop() != ctx.channel().executor().inEventLoop()) {
            throw new IllegalStateException("EventExecutor must be on the same thread as the EventLoop of the Channel");
        }
        this.ctx = ctx;
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.readCompletePendingQueue.clear();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.parentReadInProgress = true;
        if (msg instanceof Http2StreamFrame) {
            if (msg instanceof Http2WindowUpdateFrame) {
                return;
            }
            Http2StreamFrame streamFrame = (Http2StreamFrame)msg;
            Http2FrameCodec.DefaultHttp2FrameStream s = (Http2FrameCodec.DefaultHttp2FrameStream)streamFrame.stream();
            DefaultHttp2StreamChannel channel = (DefaultHttp2StreamChannel)s.attachment;
            if (msg instanceof Http2ResetFrame) {
                channel.pipeline().fireChannelInboundEvent(msg);
            } else {
                channel.fireChildRead(streamFrame);
            }
            return;
        }
        if (msg instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame(ctx, (Http2GoAwayFrame)msg);
        }
        ctx.fireChannelRead(msg);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.forEachActiveStream(DefaultHttp2StreamChannel.WRITABLE_VISITOR);
        }
        ctx.fireChannelWritabilityChanged();
    }

    public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof Http2FrameStreamEvent) {
            Http2FrameStreamEvent event = (Http2FrameStreamEvent)evt;
            Http2FrameCodec.DefaultHttp2FrameStream stream = (Http2FrameCodec.DefaultHttp2FrameStream)event.stream();
            if (event.type() == Http2FrameStreamEvent.Type.State) {
                switch (stream.state()) {
                    case HALF_CLOSED_LOCAL: {
                        if (stream.id() != 1) break;
                    }
                    case HALF_CLOSED_REMOTE: 
                    case OPEN: {
                        this.createStreamChannelIfNeeded(stream);
                        break;
                    }
                    case CLOSED: {
                        DefaultHttp2StreamChannel channel = (DefaultHttp2StreamChannel)stream.attachment;
                        if (channel == null) break;
                        channel.streamClosed();
                        break;
                    }
                }
            }
            return;
        }
        ctx.fireChannelInboundEvent(evt);
    }

    private void createStreamChannelIfNeeded(Http2FrameCodec.DefaultHttp2FrameStream stream) throws Http2Exception {
        DefaultHttp2StreamChannel ch;
        if (stream.attachment != null) {
            return;
        }
        if (stream.id() == 1 && !Http2MultiplexHandler.isServer(this.ctx)) {
            if (this.upgradeStreamHandler == null) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
            }
            ch = new DefaultHttp2StreamChannel(this, stream, ++this.idCount, this.upgradeStreamHandler);
            ch.closeOutbound();
        } else {
            ch = new DefaultHttp2StreamChannel(this, stream, ++this.idCount, this.inboundStreamHandler);
        }
        Future future = ch.register();
        if (future.isDone()) {
            Http2MultiplexHandler.registerDone(ch, future);
        } else {
            future.addListener((Object)ch, CHILD_CHANNEL_REGISTRATION_LISTENER);
        }
    }

    Http2StreamChannel newOutboundStream() {
        return new DefaultHttp2StreamChannel(this, (Http2FrameCodec.DefaultHttp2FrameStream)this.newStream(), ++this.idCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof Http2FrameStreamException) {
            Http2FrameStreamException exception = (Http2FrameStreamException)cause;
            Http2FrameStream stream2 = exception.stream();
            DefaultHttp2StreamChannel childChannel = (DefaultHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream2).attachment;
            try {
                childChannel.pipeline().fireChannelExceptionCaught(cause.getCause());
            }
            finally {
                childChannel.closeForcibly();
            }
            return;
        }
        if (cause.getCause() instanceof SSLException) {
            this.forEachActiveStream(stream -> {
                DefaultHttp2StreamChannel childChannel = (DefaultHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream).attachment;
                childChannel.pipeline().fireChannelExceptionCaught(cause);
                return true;
            });
        }
        ctx.fireChannelExceptionCaught(cause);
    }

    private static boolean isServer(ChannelHandlerContext ctx) {
        return ctx.channel().parent() instanceof ServerChannel;
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext ctx, Http2GoAwayFrame goAwayFrame) {
        if (goAwayFrame.lastStreamId() == Integer.MAX_VALUE) {
            return;
        }
        try {
            boolean server = Http2MultiplexHandler.isServer(ctx);
            this.forEachActiveStream(stream -> {
                int streamId = stream.id();
                if (streamId > goAwayFrame.lastStreamId() && Http2CodecUtil.isStreamIdValid(streamId, server)) {
                    DefaultHttp2StreamChannel childChannel = (DefaultHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream).attachment;
                    childChannel.pipeline().fireChannelInboundEvent((Object)goAwayFrame.copy());
                }
                return true;
            });
        }
        catch (Http2Exception e) {
            ctx.fireChannelExceptionCaught((Throwable)e);
            ctx.close();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.processPendingReadCompleteQueue();
        ctx.fireChannelReadComplete();
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        DefaultHttp2StreamChannel childChannel = this.readCompletePendingQueue.poll();
        if (childChannel != null) {
            try {
                do {
                    childChannel.fireChildReadComplete();
                } while ((childChannel = this.readCompletePendingQueue.poll()) != null);
            }
            finally {
                this.parentReadInProgress = false;
                this.readCompletePendingQueue.clear();
                this.ctx.flush();
            }
        } else {
            this.parentReadInProgress = false;
        }
    }

    boolean isParentReadInProgress() {
        return this.parentReadInProgress;
    }

    void addChannelToReadCompletePendingQueue(DefaultHttp2StreamChannel channel) {
        while (!this.readCompletePendingQueue.offer(channel)) {
            this.processPendingReadCompleteQueue();
        }
    }

    ChannelHandlerContext parentContext() {
        return this.ctx;
    }
}

