/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferUtil;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http2.Http2Flags;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.handler.logging.LogLevel;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogLevel;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;

@UnstableApi
public class Http2FrameLogger {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public Http2FrameLogger(LogLevel level) {
        this(Http2FrameLogger.checkAndConvertLevel(level), InternalLoggerFactory.getInstance(Http2FrameLogger.class));
    }

    public Http2FrameLogger(LogLevel level, String name) {
        this(Http2FrameLogger.checkAndConvertLevel(level), InternalLoggerFactory.getInstance((String)Objects.requireNonNull(name, "name")));
    }

    public Http2FrameLogger(LogLevel level, Class<?> clazz) {
        this(Http2FrameLogger.checkAndConvertLevel(level), InternalLoggerFactory.getInstance(Objects.requireNonNull(clazz, "clazz")));
    }

    private Http2FrameLogger(InternalLogLevel level, InternalLogger logger) {
        this.level = level;
        this.logger = logger;
    }

    private static InternalLogLevel checkAndConvertLevel(LogLevel level) {
        return Objects.requireNonNull(level, "level").toInternalLevel();
    }

    public boolean isEnabled() {
        return this.logger.isEnabled(this.level);
    }

    public void logData(Direction direction, ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endStream) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} DATA: streamId={} padding={} endStream={} length={} bytes={}", new Object[]{ctx.channel(), direction.name(), streamId, padding, endStream, data.readableBytes(), this.toString(data)});
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} padding={} endStream={}", new Object[]{ctx.channel(), direction.name(), streamId, headers, padding, endStream});
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} streamDependency={} weight={} exclusive={} padding={} endStream={}", new Object[]{ctx.channel(), direction.name(), streamId, headers, streamDependency, weight, exclusive, padding, endStream});
        }
    }

    public void logPriority(Direction direction, ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PRIORITY: streamId={} streamDependency={} weight={} exclusive={}", new Object[]{ctx.channel(), direction.name(), streamId, streamDependency, weight, exclusive});
        }
    }

    public void logRstStream(Direction direction, ChannelHandlerContext ctx, int streamId, long errorCode) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} RST_STREAM: streamId={} errorCode={}", new Object[]{ctx.channel(), direction.name(), streamId, errorCode});
        }
    }

    public void logSettingsAck(Direction direction, ChannelHandlerContext ctx) {
        this.logger.log(this.level, "{} {} SETTINGS: ack=true", (Object)ctx.channel(), (Object)direction.name());
    }

    public void logSettings(Direction direction, ChannelHandlerContext ctx, Http2Settings settings) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} SETTINGS: ack=false settings={}", new Object[]{ctx.channel(), direction.name(), settings});
        }
    }

    public void logPing(Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PING: ack=false bytes={}", new Object[]{ctx.channel(), direction.name(), data});
        }
    }

    public void logPingAck(Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PING: ack=true bytes={}", new Object[]{ctx.channel(), direction.name(), data});
        }
    }

    public void logPushPromise(Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} PUSH_PROMISE: streamId={} promisedStreamId={} headers={} padding={}", new Object[]{ctx.channel(), direction.name(), streamId, promisedStreamId, headers, padding});
        }
    }

    public void logGoAway(Direction direction, ChannelHandlerContext ctx, int lastStreamId, long errorCode, Buffer debugData) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} GO_AWAY: lastStreamId={} errorCode={} length={} bytes={}", new Object[]{ctx.channel(), direction.name(), lastStreamId, errorCode, debugData.readableBytes(), this.toString(debugData)});
        }
    }

    public void logWindowsUpdate(Direction direction, ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} WINDOW_UPDATE: streamId={} windowSizeIncrement={}", new Object[]{ctx.channel(), direction.name(), streamId, windowSizeIncrement});
        }
    }

    public void logUnknownFrame(Direction direction, ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, Buffer data) {
        if (this.isEnabled()) {
            this.logger.log(this.level, "{} {} UNKNOWN: frameType={} streamId={} flags={} length={} bytes={}", new Object[]{ctx.channel(), direction.name(), frameType & 0xFF, streamId, flags.value(), data.readableBytes(), this.toString(data)});
        }
    }

    private String toString(Buffer buf) {
        if (this.level == InternalLogLevel.TRACE || buf.readableBytes() <= 64) {
            return BufferUtil.hexDump((Buffer)buf);
        }
        int length = Math.min(buf.readableBytes(), 64);
        return BufferUtil.hexDump((Buffer)buf, (int)buf.readerOffset(), (int)length) + "...";
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

