/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2FrameListener;
import io.netty5.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.internal.ObjectUtil;

final class Http2EmptyDataFrameListener
extends Http2FrameListenerDecorator {
    private final int maxConsecutiveEmptyFrames;
    private boolean violationDetected;
    private int emptyDataFrames;

    Http2EmptyDataFrameListener(Http2FrameListener listener, int maxConsecutiveEmptyFrames) {
        super(listener);
        this.maxConsecutiveEmptyFrames = ObjectUtil.checkPositive((int)maxConsecutiveEmptyFrames, (String)"maxConsecutiveEmptyFrames");
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endOfStream) throws Http2Exception {
        if (endOfStream || data.readableBytes() > 0) {
            this.emptyDataFrames = 0;
        } else if (this.emptyDataFrames++ == this.maxConsecutiveEmptyFrames && !this.violationDetected) {
            this.violationDetected = true;
            throw Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Maximum number %d of empty data frames without end_of_stream flag received", this.maxConsecutiveEmptyFrames);
        }
        return super.onDataRead(ctx, streamId, data, padding, endOfStream);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
        this.emptyDataFrames = 0;
        super.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        this.emptyDataFrames = 0;
        super.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
    }
}

