/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2LifecycleManager;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;

final class Http2ControlFrameLimitEncoder
extends DecoratingHttp2ConnectionEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ControlFrameLimitEncoder.class);
    private final int maxOutstandingControlFrames;
    private Http2LifecycleManager lifecycleManager;
    private int outstandingControlFrames;
    private final FutureListener<Void> outstandingControlFramesListener = future -> --this.outstandingControlFrames;
    private boolean limitReached;

    Http2ControlFrameLimitEncoder(Http2ConnectionEncoder delegate, int maxOutstandingControlFrames) {
        super(delegate);
        this.maxOutstandingControlFrames = ObjectUtil.checkPositive((int)maxOutstandingControlFrames, (String)"maxOutstandingControlFrames");
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
        super.lifecycleManager(lifecycleManager);
    }

    @Override
    public Future<Void> writeSettingsAck(ChannelHandlerContext ctx) {
        FutureListener<Void> listener = this.handleOutstandingControlFrames(ctx);
        Future<Void> f = super.writeSettingsAck(ctx);
        if (listener != null) {
            f.addListener(listener);
        }
        return f;
    }

    @Override
    public Future<Void> writePing(ChannelHandlerContext ctx, boolean ack, long data) {
        if (ack) {
            FutureListener<Void> listener = this.handleOutstandingControlFrames(ctx);
            Future<Void> f = super.writePing(ctx, ack, data);
            if (listener != null) {
                f.addListener(listener);
            }
            return f;
        }
        return super.writePing(ctx, ack, data);
    }

    @Override
    public Future<Void> writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode) {
        FutureListener<Void> listener = this.handleOutstandingControlFrames(ctx);
        Future<Void> f = super.writeRstStream(ctx, streamId, errorCode);
        if (listener != null) {
            f.addListener(listener);
        }
        return f;
    }

    private FutureListener<Void> handleOutstandingControlFrames(ChannelHandlerContext ctx) {
        if (!this.limitReached) {
            if (this.outstandingControlFrames == this.maxOutstandingControlFrames) {
                ctx.flush();
            }
            if (this.outstandingControlFrames == this.maxOutstandingControlFrames) {
                this.limitReached = true;
                Http2Exception exception = Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Maximum number %d of outstanding control frames reached", this.maxOutstandingControlFrames);
                logger.info("Maximum number {} of outstanding control frames reached. Closing channel {}", new Object[]{this.maxOutstandingControlFrames, ctx.channel(), exception});
                this.lifecycleManager.onError(ctx, true, exception);
                ctx.close();
                return null;
            }
            ++this.outstandingControlFrames;
            return this.outstandingControlFramesListener;
        }
        return null;
    }
}

