/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2FrameCodec;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;

@UnstableApi
public abstract class Http2ChannelDuplexHandler
implements ChannelHandler {
    private volatile Http2FrameCodec frameCodec;

    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.frameCodec = Http2ChannelDuplexHandler.requireHttp2FrameCodec(ctx);
        this.handlerAdded0(ctx);
    }

    protected void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
    }

    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            this.handlerRemoved0(ctx);
        }
        finally {
            this.frameCodec = null;
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
    }

    public final Http2FrameStream newStream() {
        Http2FrameCodec codec = this.frameCodec;
        if (codec == null) {
            throw new IllegalStateException(StringUtil.simpleClassName(Http2FrameCodec.class) + " not found. Has the handler been added to a pipeline?");
        }
        return codec.newStream();
    }

    protected final void forEachActiveStream(Http2FrameStreamVisitor streamVisitor) throws Http2Exception {
        this.frameCodec.forEachActiveStream(streamVisitor);
    }

    private static Http2FrameCodec requireHttp2FrameCodec(ChannelHandlerContext ctx) {
        ChannelHandlerContext frameCodecCtx = ctx.pipeline().context(Http2FrameCodec.class);
        if (frameCodecCtx == null) {
            throw new IllegalArgumentException(Http2FrameCodec.class.getSimpleName() + " was not found in the channel pipeline.");
        }
        return (Http2FrameCodec)frameCodecCtx.handler();
    }
}

