/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.handler.codec.http2.HpackUtil;
import io.netty5.util.AsciiString;
import io.netty5.util.ByteProcessor;
import java.util.Objects;

final class HpackHuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;
    private final EncodedLengthProcessor encodedLengthProcessor = new EncodedLengthProcessor();
    private final EncodeProcessor encodeProcessor = new EncodeProcessor();

    HpackHuffmanEncoder() {
        this(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    }

    private HpackHuffmanEncoder(int[] codes, byte[] lengths) {
        this.codes = codes;
        this.lengths = lengths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Buffer out, CharSequence data) {
        Objects.requireNonNull(out, "out");
        if (data instanceof AsciiString) {
            AsciiString string = (AsciiString)data;
            this.encodeProcessor.out = out;
            try {
                string.forEachByte((ByteProcessor)this.encodeProcessor);
            }
            finally {
                this.encodeProcessor.end();
            }
        } else {
            this.encodeSlowPath(out, data);
        }
    }

    private void encodeSlowPath(Buffer out, CharSequence data) {
        long current = 0L;
        int n = 0;
        for (int i = 0; i < data.length(); ++i) {
            int b = data.charAt(i) & 0xFF;
            int code = this.codes[b];
            byte nbits = this.lengths[b];
            current <<= nbits;
            current |= (long)code;
            n += nbits;
            while (n >= 8) {
                out.writeByte((byte)(current >> (n -= 8)));
            }
        }
        if (n > 0) {
            current <<= 8 - n;
            out.writeByte((byte)(current |= (long)(255 >>> n)));
        }
    }

    int getEncodedLength(CharSequence data) {
        if (data instanceof AsciiString) {
            AsciiString string = (AsciiString)data;
            this.encodedLengthProcessor.reset();
            string.forEachByte((ByteProcessor)this.encodedLengthProcessor);
            return this.encodedLengthProcessor.length();
        }
        return this.getEncodedLengthSlowPath(data);
    }

    private int getEncodedLengthSlowPath(CharSequence data) {
        long len = 0L;
        for (int i = 0; i < data.length(); ++i) {
            len += (long)this.lengths[data.charAt(i) & 0xFF];
        }
        return (int)(len + 7L >> 3);
    }

    private final class EncodedLengthProcessor
    implements ByteProcessor {
        private long len;

        private EncodedLengthProcessor() {
        }

        public boolean process(byte value) {
            this.len += (long)HpackHuffmanEncoder.this.lengths[value & 0xFF];
            return true;
        }

        void reset() {
            this.len = 0L;
        }

        int length() {
            return (int)(this.len + 7L >> 3);
        }
    }

    private final class EncodeProcessor
    implements ByteProcessor {
        Buffer out;
        private long current;
        private int n;

        private EncodeProcessor() {
        }

        public boolean process(byte value) {
            int b = value & 0xFF;
            byte nbits = HpackHuffmanEncoder.this.lengths[b];
            this.current <<= nbits;
            this.current |= (long)HpackHuffmanEncoder.this.codes[b];
            this.n += nbits;
            while (this.n >= 8) {
                this.n -= 8;
                this.out.writeByte((byte)(this.current >> this.n));
            }
            return true;
        }

        void end() {
            try {
                if (this.n > 0) {
                    this.current <<= 8 - this.n;
                    this.current |= (long)(255 >>> this.n);
                    this.out.writeByte((byte)this.current);
                }
            }
            finally {
                this.out = null;
                this.current = 0L;
                this.n = 0;
            }
        }
    }
}

