/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferHolder;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.http2.Http2Flags;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.codec.http2.Http2UnknownFrame;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import java.nio.charset.StandardCharsets;

@UnstableApi
public final class DefaultHttp2UnknownFrame
extends BufferHolder<Http2UnknownFrame>
implements Http2UnknownFrame {
    private final byte frameType;
    private final Http2Flags flags;
    private Http2FrameStream stream;

    public DefaultHttp2UnknownFrame(byte frameType, Http2Flags flags) {
        this(frameType, flags, DefaultBufferAllocators.onHeapAllocator().allocate(0));
    }

    public DefaultHttp2UnknownFrame(byte frameType, Http2Flags flags, Buffer data) {
        super(data);
        this.frameType = frameType;
        this.flags = flags;
    }

    @Override
    public Buffer content() {
        return this.getBuffer();
    }

    @Override
    public Http2FrameStream stream() {
        return this.stream;
    }

    @Override
    public DefaultHttp2UnknownFrame stream(Http2FrameStream stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public byte frameType() {
        return this.frameType;
    }

    @Override
    public Http2Flags flags() {
        return this.flags;
    }

    @Override
    public String name() {
        return "UNKNOWN";
    }

    @Override
    public DefaultHttp2UnknownFrame copy() {
        return this.receive(this.getBuffer().copy());
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(frameType=" + this.frameType + ", stream=" + this.stream + ", flags=" + this.flags + ", content=" + this.getBuffer().toString(StandardCharsets.UTF_8) + ")";
    }

    protected DefaultHttp2UnknownFrame receive(Buffer buf) {
        return new DefaultHttp2UnknownFrame(this.frameType, this.flags, buf).stream(this.stream);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttp2UnknownFrame)) {
            return false;
        }
        DefaultHttp2UnknownFrame other = (DefaultHttp2UnknownFrame)o;
        Http2FrameStream otherStream = other.stream();
        return (this.stream == otherStream || otherStream != null && otherStream.equals(this.stream)) && this.flags.equals(other.flags()) && this.frameType == other.frameType() && super.equals((Object)other);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.frameType;
        hash = hash * 31 + this.flags.hashCode();
        if (this.stream != null) {
            hash = hash * 31 + this.stream.hashCode();
        }
        return hash;
    }
}

