/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.AdaptiveReadHandleFactory;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelId;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelOutputShutdownException;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultChannelPipeline;
import io.netty5.channel.EventLoop;
import io.netty5.channel.MessageSizeEstimator;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteBufferWaterMark;
import io.netty5.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty5.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty5.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2DataFrame;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Frame;
import io.netty5.handler.codec.http2.Http2FrameCodec;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.codec.http2.Http2FrameStreamException;
import io.netty5.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty5.handler.codec.http2.Http2HeadersFrame;
import io.netty5.handler.codec.http2.Http2MultiplexHandler;
import io.netty5.handler.codec.http2.Http2StreamChannel;
import io.netty5.handler.codec.http2.Http2StreamChannelId;
import io.netty5.handler.codec.http2.Http2StreamFrame;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.DefaultAttributeMap;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.ThrowableUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class DefaultHttp2StreamChannel
extends DefaultAttributeMap
implements Http2StreamChannel {
    static final Http2FrameStreamVisitor WRITABLE_VISITOR = stream -> {
        DefaultHttp2StreamChannel childChannel = (DefaultHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream).attachment;
        childChannel.trySetWritable();
        return true;
    };
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2StreamChannel.class);
    private static final int MIN_HTTP2_FRAME_SIZE = 9;
    private static final AtomicLongFieldUpdater<DefaultHttp2StreamChannel> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(DefaultHttp2StreamChannel.class, "totalPendingSize");
    private static final AtomicIntegerFieldUpdater<DefaultHttp2StreamChannel> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DefaultHttp2StreamChannel.class, "unwritable");
    private static final AtomicIntegerFieldUpdater<DefaultHttp2StreamChannel> AUTOREAD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DefaultHttp2StreamChannel.class, "autoRead");
    private volatile BufferAllocator bufferAllocator = DefaultBufferAllocators.preferredAllocator();
    private volatile ReadHandleFactory readHandleFactory = new AdaptiveReadHandleFactory();
    private volatile int connectTimeoutMillis = 30000;
    private volatile int maxMessagesPerWrite = Integer.MAX_VALUE;
    private volatile int autoRead = 1;
    private volatile boolean autoClose = true;
    private volatile WriteBufferWaterMark writeBufferWaterMark = WriteBufferWaterMark.DEFAULT;
    private volatile boolean allowHalfClosure;
    private final Http2MultiplexHandler handler;
    private final ChannelId channelId;
    private final ChannelPipeline pipeline;
    private final Http2FrameCodec.DefaultHttp2FrameStream stream;
    private final Promise<Void> closePromise;
    private volatile boolean registered;
    private volatile long totalPendingSize;
    private volatile int unwritable;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private Runnable fireChannelWritabilityChangedTask;
    private int flowControlledBytes;
    private ReadStatus readStatus = ReadStatus.IDLE;
    private Queue<Object> inboundBuffer;
    private boolean firstFrameWritten;
    private boolean readCompletePending;
    private ReadHandleFactory.ReadHandle readHandle;
    private boolean writeDoneAndNoFlush;
    private boolean closeInitiated;
    private boolean readEOS;

    private static void windowUpdateFrameWriteComplete(Channel streamChannel, Future<?> future) {
        Throwable cause = future.cause();
        if (cause != null) {
            Throwable unwrappedCause;
            if (cause instanceof Http2FrameStreamException && (unwrappedCause = cause.getCause()) != null) {
                cause = unwrappedCause;
            }
            streamChannel.pipeline().fireChannelExceptionCaught(cause);
            ((DefaultHttp2StreamChannel)streamChannel).closeTransport((Promise<Void>)streamChannel.newPromise());
        }
    }

    DefaultHttp2StreamChannel(Http2MultiplexHandler handler, Http2FrameCodec.DefaultHttp2FrameStream stream, int id, ChannelHandler inboundHandler) {
        this.handler = handler;
        this.stream = stream;
        stream.attachment = this;
        this.pipeline = new DefaultHttp2ChannelPipeline(this);
        this.closePromise = this.pipeline.newPromise();
        this.channelId = new Http2StreamChannelId(this.parent().id(), id);
        if (inboundHandler != null) {
            this.pipeline.addLast(new ChannelHandler[]{inboundHandler});
        }
    }

    private void incrementPendingOutboundBytes(long size, boolean invokeLater) {
        if (size == 0L) {
            return;
        }
        long newWriteBufferSize = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, size);
        if (newWriteBufferSize > (long)this.writeBufferWaterMark.high()) {
            this.setUnwritable(invokeLater);
        }
    }

    private void decrementPendingOutboundBytes(long size, boolean invokeLater) {
        if (size == 0L) {
            return;
        }
        long newWriteBufferSize = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -size);
        if (newWriteBufferSize < (long)this.writeBufferWaterMark.low() && this.parent().isWritable()) {
            this.setWritable(invokeLater);
        }
    }

    void trySetWritable() {
        if (this.totalPendingSize < (long)this.writeBufferWaterMark.low()) {
            this.setWritable(false);
        }
    }

    private void setWritable(boolean invokeLater) {
        block1: {
            int newValue;
            int oldValue;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue & 0xFFFFFFFE)) {
            }
            if (oldValue == 0 || newValue != 0) break block1;
            this.fireChannelWritabilityChanged(invokeLater);
        }
    }

    private void setUnwritable(boolean invokeLater) {
        block1: {
            int newValue;
            int oldValue;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue | 1)) {
            }
            if (oldValue != 0) break block1;
            this.fireChannelWritabilityChanged(invokeLater);
        }
    }

    private void fireChannelWritabilityChanged(boolean invokeLater) {
        ChannelPipeline pipeline = this.pipeline();
        if (invokeLater) {
            Runnable task = this.fireChannelWritabilityChangedTask;
            if (task == null) {
                this.fireChannelWritabilityChangedTask = task = () -> ((ChannelPipeline)pipeline).fireChannelWritabilityChanged();
            }
            this.executor().execute(task);
        } else {
            pipeline.fireChannelWritabilityChanged();
        }
    }

    @Override
    public Http2FrameStream stream() {
        return this.stream;
    }

    void closeOutbound() {
        this.outputShutdown = true;
    }

    void streamClosed() {
        this.readEOS();
        this.doBeginRead();
    }

    public boolean isOpen() {
        return !this.closePromise.isDone();
    }

    public boolean isActive() {
        return this.isOpen();
    }

    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Inbound: {
                return this.inputShutdown;
            }
            case Outbound: {
                return this.outputShutdown;
            }
        }
        throw new AssertionError();
    }

    public ChannelId id() {
        return this.channelId;
    }

    public EventLoop executor() {
        return this.parent().executor();
    }

    public Channel parent() {
        return this.handler.parentContext().channel();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public SocketAddress localAddress() {
        return this.parent().localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.parent().remoteAddress();
    }

    public Future<Void> closeFuture() {
        return this.closePromise.asFuture();
    }

    public long writableBytes() {
        long bytes = (long)this.writeBufferWaterMark.high() - this.totalPendingSize - this.pipeline.pendingOutboundBytes();
        if (bytes > 0L) {
            return this.unwritable == 0 ? bytes : 0L;
        }
        return 0L;
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int compareTo(Channel o) {
        if (this == o) {
            return 0;
        }
        return this.id().compareTo((Object)o.id());
    }

    public String toString() {
        return this.parent().toString() + "(H2 - " + this.stream + ")";
    }

    void fireChildRead(Http2Frame frame) {
        assert (this.executor().inEventLoop());
        if (!this.isActive()) {
            Resource.dispose((Object)frame);
        } else if (this.readStatus != ReadStatus.IDLE) {
            assert (this.inboundBuffer == null || this.inboundBuffer.isEmpty());
            ReadHandleFactory.ReadHandle readHandle = this.readHandle();
            boolean continueReading = this.doRead0(frame, readHandle);
            if (continueReading && !this.isShutdown(ChannelShutdownDirection.Inbound)) {
                this.maybeAddChannelToReadCompletePendingQueue();
            } else {
                this.notifyReadComplete(readHandle, true);
            }
        } else {
            if (this.inboundBuffer == null) {
                this.inboundBuffer = new ArrayDeque<Object>(4);
            }
            this.inboundBuffer.add(frame);
        }
    }

    void fireChildReadComplete() {
        assert (this.executor().inEventLoop());
        assert (this.readStatus != ReadStatus.IDLE || !this.readCompletePending);
        this.notifyReadComplete(this.readHandle(), false);
    }

    private void connectTransport(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
        if (!promise.setUncancellable()) {
            return;
        }
        promise.setFailure((Throwable)new UnsupportedOperationException());
    }

    private ReadHandleFactory.ReadHandle readHandle() {
        if (this.readHandle == null) {
            this.readHandle = this.readHandleFactory.newHandle((Channel)this);
        }
        return this.readHandle;
    }

    private void registerTransport(Promise<Void> promise) {
        if (!promise.setUncancellable()) {
            return;
        }
        if (this.registered) {
            promise.setFailure((Throwable)new UnsupportedOperationException("Re-register is not supported"));
            return;
        }
        this.registered = true;
        promise.setSuccess(null);
        this.pipeline().fireChannelRegistered();
        if (this.isActive()) {
            this.pipeline().fireChannelActive();
            if (this.isAutoRead()) {
                this.read();
            }
        }
    }

    private void bindTransport(SocketAddress localAddress, Promise<Void> promise) {
        if (!promise.setUncancellable()) {
            return;
        }
        promise.setFailure((Throwable)new UnsupportedOperationException());
    }

    private void disconnectTransport(Promise<Void> promise) {
        this.closeTransport(promise);
    }

    private void closeTransport(Promise<Void> promise) {
        if (!promise.setUncancellable()) {
            return;
        }
        if (this.closeInitiated) {
            if (this.closePromise.isDone()) {
                promise.setSuccess(null);
            } else {
                this.closeFuture().addListener(promise, (p, future) -> p.setSuccess(null));
            }
            return;
        }
        this.closeInitiated = true;
        this.readCompletePending = false;
        boolean wasActive = this.isActive();
        if (this.parent().isActive() && !this.readEOS && Http2CodecUtil.isStreamIdValid(this.stream.id())) {
            DefaultHttp2ResetFrame resetFrame = new DefaultHttp2ResetFrame(Http2Error.CANCEL).stream(this.stream());
            this.writeTransport(resetFrame, (Promise<Void>)this.newPromise());
            this.flush();
        }
        if (this.inboundBuffer != null) {
            Object msg;
            while ((msg = this.inboundBuffer.poll()) != null) {
                Resource.dispose((Object)msg);
            }
            this.inboundBuffer = null;
        }
        this.outputShutdown = true;
        this.closePromise.setSuccess(null);
        promise.setSuccess(null);
        this.fireChannelInactiveAndDeregister((Promise<Void>)this.newPromise(), wasActive);
    }

    private void shutdownTransport(ChannelShutdownDirection direction, Promise<Void> promise) {
        if (!promise.setUncancellable()) {
            return;
        }
        if (!this.isActive()) {
            if (this.isOpen()) {
                promise.setFailure((Throwable)new NotYetConnectedException());
            } else {
                promise.setFailure((Throwable)new ClosedChannelException());
            }
            return;
        }
        if (this.isShutdown(direction)) {
            promise.setSuccess(null);
            return;
        }
        boolean fireEvent = false;
        switch (direction) {
            case Outbound: {
                fireEvent = this.shutdownOutput(true, promise);
                break;
            }
            case Inbound: {
                try {
                    this.inputShutdown = true;
                    promise.setSuccess(null);
                    fireEvent = true;
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                }
                break;
            }
            default: {
                promise.setFailure((Throwable)new IllegalStateException());
            }
        }
        if (fireEvent) {
            this.pipeline().fireChannelShutdown(direction);
        }
    }

    private boolean shutdownOutput(boolean writeFrame, Promise<Void> promise) {
        if (!promise.setUncancellable()) {
            return false;
        }
        if (this.isShutdown(ChannelShutdownDirection.Outbound)) {
            promise.setSuccess(null);
            return false;
        }
        if (writeFrame) {
            this.writeTransport(new DefaultHttp2HeadersFrame(Http2Headers.emptyHeaders(), true), (Promise<Void>)this.newPromise());
        }
        this.outputShutdown = true;
        promise.setSuccess(null);
        return true;
    }

    void closeForcibly() {
        this.closeTransport((Promise<Void>)this.newPromise());
    }

    private void deregisterTransport(Promise<Void> promise) {
        this.fireChannelInactiveAndDeregister(promise, false);
    }

    private void fireChannelInactiveAndDeregister(Promise<Void> promise, boolean fireChannelInactive) {
        if (!promise.setUncancellable()) {
            return;
        }
        if (!this.registered) {
            promise.setSuccess(null);
            return;
        }
        this.invokeLater(() -> {
            if (fireChannelInactive) {
                this.pipeline.fireChannelInactive();
            }
            if (this.registered) {
                this.registered = false;
                this.pipeline.fireChannelUnregistered();
            }
            this.safeSetSuccess(promise);
        });
    }

    private void safeSetSuccess(Promise<Void> promise) {
        if (!promise.trySuccess(null)) {
            logger.warn("Failed to mark a promise as success because it is done already: {}", promise);
        }
    }

    private void invokeLater(Runnable task) {
        try {
            this.executor().execute(task);
        }
        catch (RejectedExecutionException e) {
            logger.warn("Can't invoke task later as EventLoop rejected it", (Throwable)e);
        }
    }

    private void readTransport(ReadBufferAllocator allocator) {
        if (!this.isActive()) {
            return;
        }
        this.updateLocalWindowIfNeeded();
        switch (this.readStatus) {
            case IDLE: {
                this.readStatus = ReadStatus.IN_PROGRESS;
                this.doBeginRead();
                break;
            }
            case IN_PROGRESS: {
                this.readStatus = ReadStatus.REQUESTED;
                break;
            }
        }
    }

    private Object pollQueuedMessage() {
        return this.inboundBuffer == null ? null : this.inboundBuffer.poll();
    }

    void doBeginRead() {
        while (this.readStatus != ReadStatus.IDLE) {
            boolean continueReading;
            Object message = this.pollQueuedMessage();
            if (message == null) {
                if (this.readEOS) {
                    this.closeForcibly();
                }
                this.flush();
                break;
            }
            ReadHandleFactory.ReadHandle allocHandle = this.readHandle();
            do {
                continueReading = this.doRead0((Http2Frame)message, allocHandle);
            } while ((this.readEOS || continueReading) && (message = this.pollQueuedMessage()) != null);
            if (continueReading && this.handler.isParentReadInProgress() && !this.readEOS) {
                this.maybeAddChannelToReadCompletePendingQueue();
                continue;
            }
            this.notifyReadComplete(allocHandle, true);
        }
    }

    void readEOS() {
        this.readEOS = true;
    }

    private void updateLocalWindowIfNeeded() {
        if (this.flowControlledBytes != 0) {
            int bytes = this.flowControlledBytes;
            this.flowControlledBytes = 0;
            Future future = this.handler.parentContext().write((Object)new DefaultHttp2WindowUpdateFrame(bytes).stream(this.stream));
            this.writeDoneAndNoFlush = true;
            if (future.isDone()) {
                DefaultHttp2StreamChannel.windowUpdateFrameWriteComplete(this, future);
            } else {
                future.addListener((Object)this, DefaultHttp2StreamChannel::windowUpdateFrameWriteComplete);
            }
        }
    }

    void notifyReadComplete(ReadHandleFactory.ReadHandle allocHandle, boolean forceReadComplete) {
        if (!this.readCompletePending && !forceReadComplete) {
            return;
        }
        this.readCompletePending = false;
        this.readStatus = this.readStatus == ReadStatus.REQUESTED ? ReadStatus.IN_PROGRESS : ReadStatus.IDLE;
        allocHandle.readComplete();
        this.pipeline().fireChannelReadComplete();
        if (this.isAutoRead()) {
            this.read();
        }
        this.flush();
        if (this.readEOS) {
            this.closeForcibly();
        }
    }

    private boolean doRead0(Http2Frame frame, ReadHandleFactory.ReadHandle allocHandle) {
        int bytes;
        if (this.isShutdown(ChannelShutdownDirection.Inbound) && (frame instanceof Http2DataFrame || frame instanceof Http2HeadersFrame)) {
            Resource.dispose((Object)frame);
            return allocHandle.lastRead(0, 0, 0);
        }
        if (frame instanceof Http2DataFrame) {
            bytes = ((Http2DataFrame)frame).initialFlowControlledBytes();
            this.flowControlledBytes += bytes;
        } else {
            bytes = 9;
        }
        boolean continueReading = allocHandle.lastRead(bytes, bytes, 1);
        boolean shutdownInput = this.isShutdownNeeded(frame);
        this.pipeline().fireChannelRead((Object)frame);
        if (shutdownInput) {
            this.shutdownTransport(ChannelShutdownDirection.Inbound, (Promise<Void>)this.newPromise());
        }
        return continueReading;
    }

    private boolean isShutdownNeeded(Http2Frame frame) {
        if (frame instanceof Http2HeadersFrame) {
            return ((Http2HeadersFrame)frame).isEndStream();
        }
        if (frame instanceof Http2DataFrame) {
            return ((Http2DataFrame)frame).isEndStream();
        }
        return false;
    }

    private void writeTransport(Object msg, Promise<Void> promise) {
        if (!promise.setUncancellable()) {
            Resource.dispose((Object)msg);
            return;
        }
        if (!this.isActive()) {
            Resource.dispose((Object)msg);
            promise.setFailure((Throwable)new ClosedChannelException());
            return;
        }
        if (this.isShutdown(ChannelShutdownDirection.Outbound) && (msg instanceof Http2HeadersFrame || msg instanceof Http2DataFrame)) {
            Resource.dispose((Object)msg);
            promise.setFailure((Throwable)DefaultHttp2StreamChannel.newOutputShutdownException(DefaultHttp2StreamChannel.class, "writeTransport(Object, Promise)"));
            return;
        }
        try {
            if (msg instanceof Http2StreamFrame) {
                Http2StreamFrame frame = this.validateStreamFrame((Http2StreamFrame)msg).stream(this.stream());
                boolean shutdownOutput = this.isShutdownNeeded(frame);
                this.writeHttp2StreamFrame(frame, promise);
                if (shutdownOutput && this.shutdownOutput(false, (Promise<Void>)this.newPromise())) {
                    this.pipeline().fireChannelShutdown(ChannelShutdownDirection.Outbound);
                }
            } else {
                String msgStr = msg.toString();
                Resource.dispose((Object)msg);
                promise.setFailure((Throwable)new IllegalArgumentException("Message must be an " + StringUtil.simpleClassName(Http2StreamFrame.class) + ": " + msgStr));
            }
        }
        catch (Throwable t) {
            promise.tryFailure(t);
        }
    }

    private void writeHttp2StreamFrame(Http2StreamFrame frame, Promise<Void> promise) {
        boolean firstWrite;
        if (!(this.firstFrameWritten || Http2CodecUtil.isStreamIdValid(this.stream().id()) || frame instanceof Http2HeadersFrame)) {
            Resource.dispose((Object)frame);
            promise.setFailure((Throwable)new IllegalArgumentException("The first frame must be a headers frame. Was: " + frame.name()));
            return;
        }
        if (this.firstFrameWritten) {
            firstWrite = false;
        } else {
            this.firstFrameWritten = true;
            firstWrite = true;
        }
        Future f = this.handler.parentContext().write((Object)frame);
        if (f.isDone()) {
            if (firstWrite) {
                this.firstWriteComplete(f, promise);
            } else {
                this.writeComplete(f, promise);
            }
        } else {
            long bytes = FlowControlledFrameSizeEstimator.HANDLE_INSTANCE.size((Object)frame);
            this.incrementPendingOutboundBytes(bytes, false);
            f.addListener(future -> {
                if (firstWrite) {
                    this.firstWriteComplete(future, promise);
                } else {
                    this.writeComplete(future, promise);
                }
                this.decrementPendingOutboundBytes(bytes, false);
            });
            this.writeDoneAndNoFlush = true;
        }
    }

    private void firstWriteComplete(Future<?> future, Promise<Void> promise) {
        Throwable cause = future.cause();
        if (cause == null) {
            promise.setSuccess(null);
        } else {
            this.closeForcibly();
            promise.setFailure(this.wrapStreamClosedError(cause));
        }
    }

    private void writeComplete(Future<?> future, Promise<Void> promise) {
        Throwable cause = future.cause();
        if (cause == null) {
            promise.setSuccess(null);
        } else {
            Throwable error = this.wrapStreamClosedError(cause);
            if (error instanceof IOException) {
                if (this.isAutoClose()) {
                    this.closeForcibly();
                } else {
                    this.shutdownTransport(ChannelShutdownDirection.Outbound, (Promise<Void>)this.newPromise());
                }
            }
            promise.setFailure(error);
        }
    }

    private Throwable wrapStreamClosedError(Throwable cause) {
        if (cause instanceof Http2Exception && ((Http2Exception)cause).error() == Http2Error.STREAM_CLOSED) {
            return new ClosedChannelException().initCause(cause);
        }
        return cause;
    }

    private Http2StreamFrame validateStreamFrame(Http2StreamFrame frame) {
        if (frame.stream() != null && frame.stream() != this.stream) {
            String msgString = frame.toString();
            Resource.dispose((Object)frame);
            throw new IllegalArgumentException("Stream " + frame.stream() + " must not be set on the frame: " + msgString);
        }
        return frame;
    }

    private void flushTransport() {
        if (!this.writeDoneAndNoFlush || this.handler.isParentReadInProgress()) {
            return;
        }
        this.writeDoneAndNoFlush = false;
        this.handler.parentContext().flush();
    }

    private void sendOutboundEventTransport(Object event, Promise<Void> promise) {
        Resource.dispose((Object)event);
        promise.setSuccess(null);
    }

    public BufferAllocator bufferAllocator() {
        return this.bufferAllocator;
    }

    private <T> void validate(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        option.validate(value);
    }

    public <T> T getOption(ChannelOption<T> option) {
        Objects.requireNonNull(option, "option");
        if (option == ChannelOption.AUTO_READ) {
            return (T)Boolean.valueOf(this.isAutoRead());
        }
        if (option == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            return (T)this.getWriteBufferWaterMark();
        }
        if (option == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            return (T)Integer.valueOf(this.getConnectTimeoutMillis());
        }
        if (option == ChannelOption.BUFFER_ALLOCATOR) {
            return (T)this.getBufferAllocator();
        }
        if (option == ChannelOption.READ_HANDLE_FACTORY) {
            return this.getReadHandleFactory();
        }
        if (option == ChannelOption.AUTO_CLOSE) {
            return (T)Boolean.valueOf(this.isAutoClose());
        }
        if (option == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
            return (T)this.getMessageSizeEstimator();
        }
        if (option == ChannelOption.MAX_MESSAGES_PER_WRITE) {
            return (T)Integer.valueOf(this.getMaxMessagesPerWrite());
        }
        if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        return null;
    }

    public <T> Channel setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.AUTO_READ) {
            this.setAutoRead((Boolean)value);
        } else if (option == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            this.setWriteBufferWaterMark((WriteBufferWaterMark)value);
        } else if (option == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            this.setConnectTimeoutMillis((Integer)value);
        } else if (option == ChannelOption.BUFFER_ALLOCATOR) {
            this.setBufferAllocator((BufferAllocator)value);
        } else if (option == ChannelOption.READ_HANDLE_FACTORY) {
            this.setReadHandleFactory((ReadHandleFactory)value);
        } else if (option == ChannelOption.AUTO_CLOSE) {
            this.setAutoClose((Boolean)value);
        } else {
            if (option == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
                return this;
            }
            if (option == ChannelOption.MAX_MESSAGES_PER_WRITE) {
                this.setMaxMessagesPerWrite((Integer)value);
            } else if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
                this.setAllowHalfClosure((Boolean)value);
            }
        }
        return this;
    }

    public boolean isOptionSupported(ChannelOption<?> option) {
        return option == ChannelOption.AUTO_READ || option == ChannelOption.WRITE_BUFFER_WATER_MARK || option == ChannelOption.CONNECT_TIMEOUT_MILLIS || option == ChannelOption.BUFFER_ALLOCATOR || option == ChannelOption.READ_HANDLE_FACTORY || option == ChannelOption.AUTO_CLOSE || option == ChannelOption.MESSAGE_SIZE_ESTIMATOR || option == ChannelOption.MAX_MESSAGES_PER_WRITE || option == ChannelOption.ALLOW_HALF_CLOSURE;
    }

    private int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    private void setConnectTimeoutMillis(int connectTimeoutMillis) {
        ObjectUtil.checkPositiveOrZero((int)connectTimeoutMillis, (String)"connectTimeoutMillis");
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    private int getMaxMessagesPerWrite() {
        return this.maxMessagesPerWrite;
    }

    private void setMaxMessagesPerWrite(int maxMessagesPerWrite) {
        this.maxMessagesPerWrite = ObjectUtil.checkPositive((int)maxMessagesPerWrite, (String)"maxMessagesPerWrite");
    }

    private BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public void setBufferAllocator(BufferAllocator bufferAllocator) {
        Objects.requireNonNull(bufferAllocator, "bufferAllocator");
        this.bufferAllocator = bufferAllocator;
    }

    private <T extends ReadHandleFactory> T getReadHandleFactory() {
        return (T)this.readHandleFactory;
    }

    private void setReadHandleFactory(ReadHandleFactory readHandleFactory) {
        this.readHandleFactory = Objects.requireNonNull(readHandleFactory, "readHandleFactory");
    }

    private boolean isAutoRead() {
        return this.autoRead == 1;
    }

    private void setAutoRead(boolean autoRead) {
        boolean oldAutoRead;
        boolean bl = oldAutoRead = AUTOREAD_UPDATER.getAndSet(this, autoRead ? 1 : 0) == 1;
        if (autoRead && !oldAutoRead) {
            this.read();
        } else if (!autoRead && oldAutoRead) {
            this.autoReadCleared();
        }
    }

    protected void autoReadCleared() {
    }

    private WriteBufferWaterMark getWriteBufferWaterMark() {
        return this.writeBufferWaterMark;
    }

    private boolean isAutoClose() {
        return this.autoClose;
    }

    private void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    private void setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        this.writeBufferWaterMark = Objects.requireNonNull(writeBufferWaterMark, "writeBufferWaterMark");
    }

    private MessageSizeEstimator getMessageSizeEstimator() {
        return FlowControlledFrameSizeEstimator.INSTANCE;
    }

    private boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    private void setAllowHalfClosure(boolean allowHalfClosure) {
        this.allowHalfClosure = allowHalfClosure;
    }

    private void maybeAddChannelToReadCompletePendingQueue() {
        if (!this.readCompletePending) {
            this.readCompletePending = true;
            this.handler.addChannelToReadCompletePendingQueue(this);
        }
    }

    private static ChannelOutputShutdownException newOutputShutdownException(Class<?> clazz, String method) {
        return (ChannelOutputShutdownException)ThrowableUtil.unknownStackTrace((Throwable)new ChannelOutputShutdownException(){

            public Throwable fillInStackTrace() {
                return this;
            }
        }, clazz, (String)method);
    }

    private static final class DefaultHttp2ChannelPipeline
    extends DefaultChannelPipeline {
        DefaultHttp2ChannelPipeline(Channel channel) {
            super(channel);
        }

        private DefaultHttp2StreamChannel defaultHttp2StreamChannel() {
            return (DefaultHttp2StreamChannel)this.channel();
        }

        protected EventExecutor transportExecutor() {
            return this.defaultHttp2StreamChannel().executor();
        }

        protected void pendingOutboundBytesUpdated(long pendingOutboundBytes) {
        }

        protected void registerTransport(Promise<Void> promise) {
            this.defaultHttp2StreamChannel().registerTransport(promise);
        }

        protected void bindTransport(SocketAddress localAddress, Promise<Void> promise) {
            this.defaultHttp2StreamChannel().bindTransport(localAddress, promise);
        }

        protected void connectTransport(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
            this.defaultHttp2StreamChannel().connectTransport(remoteAddress, localAddress, promise);
        }

        protected void disconnectTransport(Promise<Void> promise) {
            this.defaultHttp2StreamChannel().disconnectTransport(promise);
        }

        protected void closeTransport(Promise<Void> promise) {
            this.defaultHttp2StreamChannel().closeTransport(promise);
        }

        protected void shutdownTransport(ChannelShutdownDirection direction, Promise<Void> promise) {
            this.defaultHttp2StreamChannel().shutdownTransport(direction, promise);
        }

        protected void deregisterTransport(Promise<Void> promise) {
            this.defaultHttp2StreamChannel().deregisterTransport(promise);
        }

        protected void readTransport(ReadBufferAllocator readBufferAllocator) {
            this.defaultHttp2StreamChannel().readTransport(readBufferAllocator);
        }

        protected void writeTransport(Object msg, Promise<Void> promise) {
            this.defaultHttp2StreamChannel().writeTransport(msg, promise);
        }

        protected void flushTransport() {
            this.defaultHttp2StreamChannel().flushTransport();
        }

        protected void sendOutboundEventTransport(Object event, Promise<Void> promise) {
            this.defaultHttp2StreamChannel().sendOutboundEventTransport(event, promise);
        }

        protected boolean isTransportSupportingDisconnect() {
            return false;
        }
    }

    private static enum ReadStatus {
        IDLE,
        IN_PROGRESS,
        REQUESTED;

    }

    private static final class FlowControlledFrameSizeEstimator
    implements MessageSizeEstimator {
        static final FlowControlledFrameSizeEstimator INSTANCE = new FlowControlledFrameSizeEstimator();
        private static final MessageSizeEstimator.Handle HANDLE_INSTANCE = msg -> msg instanceof Http2DataFrame ? (int)Math.min(Integer.MAX_VALUE, (long)((Http2DataFrame)msg).initialFlowControlledBytes() + 9L) : 9;

        private FlowControlledFrameSizeEstimator() {
        }

        public MessageSizeEstimator.Handle newHandle() {
            return HANDLE_INSTANCE;
        }
    }
}

