/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.codec.http2.Http2ResetFrame;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public final class DefaultHttp2ResetFrame
extends AbstractHttp2StreamFrame
implements Http2ResetFrame {
    private final long errorCode;

    public DefaultHttp2ResetFrame(Http2Error error) {
        this.errorCode = Objects.requireNonNull(error, "error").code();
    }

    public DefaultHttp2ResetFrame(long errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public DefaultHttp2ResetFrame stream(Http2FrameStream stream) {
        super.stream(stream);
        return this;
    }

    @Override
    public String name() {
        return "RST_STREAM";
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(stream=" + this.stream() + ", errorCode=" + this.errorCode + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttp2ResetFrame)) {
            return false;
        }
        DefaultHttp2ResetFrame other = (DefaultHttp2ResetFrame)o;
        return super.equals(o) && this.errorCode == other.errorCode;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        return hash;
    }
}

