/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx.extensions.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.handler.codec.CodecException;
import io.netty5.handler.codec.compression.ZlibCodecFactory;
import io.netty5.handler.codec.compression.ZlibWrapper;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty5.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import io.netty5.util.Send;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

abstract class DeflateEncoder
extends WebSocketExtensionEncoder {
    static final Supplier<Buffer> EMPTY_DEFLATE_BLOCK;
    private final int compressionLevel;
    private final int windowSize;
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionEncoderFilter;
    private EmbeddedChannel encoder;

    DeflateEncoder(int compressionLevel, int windowSize, boolean noContext, WebSocketExtensionFilter extensionEncoderFilter) {
        this.compressionLevel = compressionLevel;
        this.windowSize = windowSize;
        this.noContext = noContext;
        this.extensionEncoderFilter = Objects.requireNonNull(extensionEncoderFilter, "extensionEncoderFilter");
    }

    protected WebSocketExtensionFilter extensionEncoderFilter() {
        return this.extensionEncoderFilter;
    }

    protected abstract int rsv(WebSocketFrame var1);

    protected abstract boolean removeFrameTail(WebSocketFrame var1);

    protected void encodeAndClose(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        WebSocketFrame outMsg;
        Buffer compressedContent;
        if (msg.binaryData().readableBytes() > 0) {
            compressedContent = this.compressContent(ctx, msg);
        } else if (msg.isFinalFragment()) {
            compressedContent = EMPTY_DEFLATE_BLOCK.get();
            msg.close();
        } else {
            msg.close();
            throw new CodecException("cannot compress content buffer");
        }
        if (msg instanceof TextWebSocketFrame) {
            outMsg = new TextWebSocketFrame(msg.isFinalFragment(), this.rsv(msg), compressedContent);
        } else if (msg instanceof BinaryWebSocketFrame) {
            outMsg = new BinaryWebSocketFrame(msg.isFinalFragment(), this.rsv(msg), compressedContent);
        } else if (msg instanceof ContinuationWebSocketFrame) {
            outMsg = new ContinuationWebSocketFrame(msg.isFinalFragment(), this.rsv(msg), compressedContent);
        } else {
            compressedContent.close();
            throw new CodecException("unexpected frame type: " + ((Object)((Object)msg)).getClass().getName());
        }
        out.add((Object)outMsg);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.handlerRemoved(ctx);
    }

    private Buffer compressContent(ChannelHandlerContext ctx, WebSocketFrame msg) {
        CompositeBuffer compressedContent;
        Buffer partCompressedContent;
        if (this.encoder == null) {
            this.encoder = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)this.compressionLevel, (int)this.windowSize, (int)8)});
        }
        this.encoder.writeOutbound(new Object[]{msg.binaryData()});
        ArrayList<Send> bufferList = new ArrayList<Send>();
        while ((partCompressedContent = (Buffer)this.encoder.readOutbound()) != null) {
            if (partCompressedContent.readableBytes() == 0) {
                partCompressedContent.close();
                continue;
            }
            bufferList.add(partCompressedContent.send());
        }
        if (bufferList.isEmpty()) {
            throw new CodecException("cannot read compressed buffer");
        }
        if (msg.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        CompositeBuffer fullCompressedContent = ctx.bufferAllocator().compose(bufferList);
        if (this.removeFrameTail(msg)) {
            int realLength = fullCompressedContent.readableBytes() - DeflateDecoder.FRAME_TAIL_LENGTH;
            compressedContent = fullCompressedContent.readerOffset(0).writerOffset(realLength);
        } else {
            compressedContent = fullCompressedContent;
        }
        return compressedContent;
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.encoder.finishAndReleaseAll();
            this.encoder = null;
        }
    }

    static {
        byte[] emptyDeflate = new byte[]{0};
        EMPTY_DEFLATE_BLOCK = DefaultBufferAllocators.preferredAllocator().constBufferSupplier(emptyDeflate);
    }
}

