/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferHolder;
import io.netty5.util.Send;
import io.netty5.util.internal.StringUtil;
import java.nio.charset.Charset;

public abstract class WebSocketFrame
extends BufferHolder<WebSocketFrame> {
    private final boolean finalFragment;
    private final int rsv;

    protected WebSocketFrame(Buffer binaryData) {
        this(true, 0, binaryData);
    }

    protected WebSocketFrame(Send<Buffer> binaryData) {
        super(binaryData);
        this.finalFragment = true;
        this.rsv = 0;
    }

    protected WebSocketFrame(boolean finalFragment, int rsv, Buffer binaryData) {
        super(binaryData);
        this.finalFragment = finalFragment;
        this.rsv = rsv;
    }

    protected WebSocketFrame(WebSocketFrame copyFrom, Buffer binaryData) {
        super(binaryData);
        this.finalFragment = copyFrom.finalFragment;
        this.rsv = copyFrom.rsv;
    }

    public boolean isFinalFragment() {
        return this.finalFragment;
    }

    public int rsv() {
        return this.rsv;
    }

    public Buffer binaryData() {
        return this.getBuffer();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)((Object)this)) + "(data: " + this.getBuffer().toString(Charset.defaultCharset()) + ")";
    }
}

