/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageEncoder;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class WebSocket13FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket13FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int GATHERING_WRITE_THRESHOLD = 1024;
    private final boolean maskPayload;

    public WebSocket13FrameEncoder(boolean maskPayload) {
        this.maskPayload = maskPayload;
    }

    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        int opcode;
        Buffer data = msg.binaryData();
        if (msg instanceof TextWebSocketFrame) {
            opcode = 1;
        } else if (msg instanceof PingWebSocketFrame) {
            opcode = 9;
        } else if (msg instanceof PongWebSocketFrame) {
            opcode = 10;
        } else if (msg instanceof CloseWebSocketFrame) {
            opcode = 8;
        } else if (msg instanceof BinaryWebSocketFrame) {
            opcode = 2;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            opcode = 0;
        } else {
            throw new UnsupportedOperationException("Cannot encode frame of type: " + ((Object)((Object)msg)).getClass().getName());
        }
        int length = data.readableBytes();
        if (logger.isTraceEnabled()) {
            logger.trace("Encoding WebSocket Frame opCode={} length={}", (Object)((byte)opcode), (Object)length);
        }
        int b0 = 0;
        if (msg.isFinalFragment()) {
            b0 |= 0x80;
        }
        b0 |= msg.rsv() % 8 << 4;
        b0 |= opcode % 128;
        if (opcode == 9 && length > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + length);
        }
        Buffer buf = null;
        try {
            int size;
            int maskLength;
            int n = maskLength = this.maskPayload ? 4 : 0;
            if (length <= 125) {
                size = 2 + maskLength;
                if (this.maskPayload || length <= 1024) {
                    size += length;
                }
                buf = ctx.bufferAllocator().allocate(size);
                buf.writeByte((byte)b0);
                byte b = this.maskPayload ? (byte)(0x80 | (byte)length) : (byte)length;
                buf.writeByte(b);
            } else if (length <= 65535) {
                size = 4 + maskLength;
                if (this.maskPayload || length <= 1024) {
                    size += length;
                }
                buf = ctx.bufferAllocator().allocate(size);
                buf.writeByte((byte)b0);
                buf.writeByte((byte)(this.maskPayload ? 254 : 126));
                buf.writeByte((byte)(length >>> 8 & 0xFF));
                buf.writeByte((byte)(length & 0xFF));
            } else {
                size = 10 + maskLength;
                if (this.maskPayload || length <= 1024) {
                    size += length;
                }
                buf = ctx.bufferAllocator().allocate(size);
                buf.writeByte((byte)b0);
                buf.writeByte((byte)(this.maskPayload ? 255 : 127));
                buf.writeLong((long)length);
            }
            if (this.maskPayload) {
                byte[] mask = new byte[4];
                ThreadLocalRandom.current().nextBytes(mask);
                buf.writeBytes(mask);
                int counter = 0;
                int i = data.readerOffset();
                int end = data.writerOffset();
                int intMask = (mask[0] & 0xFF) << 24 | (mask[1] & 0xFF) << 16 | (mask[2] & 0xFF) << 8 | mask[3] & 0xFF;
                while (i + 3 < end) {
                    int intData = data.getInt(i);
                    buf.writeInt(intData ^ intMask);
                    i += 4;
                }
                while (i < end) {
                    byte byteData = data.getByte(i);
                    buf.writeByte((byte)(byteData ^ mask[counter++ % 4]));
                    ++i;
                }
                out.add(buf);
            } else if (buf.writableBytes() >= data.readableBytes()) {
                buf.writeBytes(data);
                out.add(buf);
            } else {
                out.add(buf);
                out.add(data.split());
            }
        }
        catch (Throwable t) {
            if (buf != null) {
                buf.close();
            }
            throw t;
        }
    }
}

