/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.AsciiString;
import io.netty5.util.NetUtil;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.UnstableApi;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS = AsciiString.of((CharSequence)(HttpHeaderValues.CHARSET + "="));
    private static final AsciiString SEMICOLON = AsciiString.cached((String)";");
    private static final String COMMA_STRING = String.valueOf(',');

    private HttpUtil() {
    }

    public static boolean isOriginForm(URI uri) {
        return HttpUtil.isOriginForm(uri.toString());
    }

    public static boolean isOriginForm(String uri) {
        return uri.startsWith("/");
    }

    public static boolean isAsteriskForm(URI uri) {
        return HttpUtil.isAsteriskForm(uri.toString());
    }

    public static boolean isAsteriskForm(String uri) {
        return "*".equals(uri);
    }

    public static boolean isKeepAlive(HttpMessage message) {
        return !message.headers().containsIgnoreCase((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE) && (message.protocolVersion().isKeepAliveDefault() || message.headers().containsIgnoreCase((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE));
    }

    public static void setKeepAlive(HttpMessage message, boolean keepAlive) {
        HttpUtil.setKeepAlive(message.headers(), message.protocolVersion(), keepAlive);
    }

    public static void setKeepAlive(HttpHeaders h, HttpVersion httpVersion, boolean keepAlive) {
        if (httpVersion.isKeepAliveDefault()) {
            if (keepAlive) {
                h.remove((CharSequence)HttpHeaderNames.CONNECTION);
            } else {
                h.set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE);
            }
        } else if (keepAlive) {
            h.set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE);
        } else {
            h.remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
    }

    public static long getContentLength(HttpMessage message) {
        CharSequence value = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        throw new NumberFormatException("header not found: " + HttpHeaderNames.CONTENT_LENGTH);
    }

    public static long getContentLength(HttpMessage message, long defaultValue) {
        CharSequence value = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        return defaultValue;
    }

    public static int getContentLength(HttpMessage message, int defaultValue) {
        return (int)Math.min(Integer.MAX_VALUE, HttpUtil.getContentLength(message, (long)defaultValue));
    }

    public static void setContentLength(HttpMessage message, long length) {
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(length));
    }

    public static boolean isContentLengthSet(HttpMessage m) {
        return m.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage message) {
        return HttpUtil.isExpectHeaderValid(message) && message.headers().containsIgnoreCase((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE);
    }

    static boolean isUnsupportedExpectation(HttpMessage message) {
        if (!HttpUtil.isExpectHeaderValid(message)) {
            return false;
        }
        CharSequence expectValue = message.headers().get((CharSequence)HttpHeaderNames.EXPECT);
        return expectValue != null && !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderValues.CONTINUE, (CharSequence)expectValue);
    }

    private static boolean isExpectHeaderValid(HttpMessage message) {
        return message instanceof HttpRequest && message.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static void set100ContinueExpected(HttpMessage message, boolean expected) {
        if (expected) {
            message.headers().set((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE);
        } else {
            message.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
        }
    }

    public static boolean isTransferEncodingChunked(HttpMessage message) {
        return message.headers().containsIgnoreCase((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
    }

    public static void setTransferEncodingChunked(HttpMessage m, boolean chunked) {
        if (chunked) {
            m.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
            m.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        } else {
            Iterator<CharSequence> encodings = m.headers().valuesIterator((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            if (!encodings.hasNext()) {
                return;
            }
            ArrayList<CharSequence> values = new ArrayList<CharSequence>();
            do {
                values.add(encodings.next());
            } while (encodings.hasNext());
            values.removeIf(arg_0 -> ((AsciiString)HttpHeaderValues.CHUNKED).contentEqualsIgnoreCase(arg_0));
            if (values.isEmpty()) {
                m.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            } else {
                m.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, values);
            }
        }
    }

    public static Charset getCharset(HttpMessage message) {
        return HttpUtil.getCharset(message, StandardCharsets.ISO_8859_1);
    }

    public static Charset getCharset(CharSequence contentTypeValue) {
        if (contentTypeValue != null) {
            return HttpUtil.getCharset(contentTypeValue, StandardCharsets.ISO_8859_1);
        }
        return StandardCharsets.ISO_8859_1;
    }

    public static Charset getCharset(HttpMessage message, Charset defaultCharset) {
        CharSequence contentTypeValue = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue != null) {
            return HttpUtil.getCharset(contentTypeValue, defaultCharset);
        }
        return defaultCharset;
    }

    public static Charset getCharset(CharSequence contentTypeValue, Charset defaultCharset) {
        if (contentTypeValue != null) {
            CharSequence charsetRaw = HttpUtil.getCharsetAsSequence(contentTypeValue);
            if (charsetRaw != null) {
                if (charsetRaw.length() > 2 && charsetRaw.charAt(0) == '\"' && charsetRaw.charAt(charsetRaw.length() - 1) == '\"') {
                    charsetRaw = charsetRaw.subSequence(1, charsetRaw.length() - 1);
                }
                try {
                    return Charset.forName(charsetRaw.toString());
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException ignored) {
                    return defaultCharset;
                }
            }
            return defaultCharset;
        }
        return defaultCharset;
    }

    @Deprecated
    public static CharSequence getCharsetAsString(HttpMessage message) {
        return HttpUtil.getCharsetAsSequence(message);
    }

    public static CharSequence getCharsetAsSequence(HttpMessage message) {
        CharSequence contentTypeValue = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue != null) {
            return HttpUtil.getCharsetAsSequence(contentTypeValue);
        }
        return null;
    }

    public static CharSequence getCharsetAsSequence(CharSequence contentTypeValue) {
        Objects.requireNonNull(contentTypeValue, "contentTypeValue");
        int indexOfCharset = AsciiString.indexOfIgnoreCaseAscii((CharSequence)contentTypeValue, (CharSequence)CHARSET_EQUALS, (int)0);
        if (indexOfCharset == -1) {
            return null;
        }
        int indexOfEncoding = indexOfCharset + CHARSET_EQUALS.length();
        if (indexOfEncoding < contentTypeValue.length()) {
            CharSequence charsetCandidate = contentTypeValue.subSequence(indexOfEncoding, contentTypeValue.length());
            int indexOfSemicolon = AsciiString.indexOfIgnoreCaseAscii((CharSequence)charsetCandidate, (CharSequence)SEMICOLON, (int)0);
            if (indexOfSemicolon == -1) {
                return charsetCandidate;
            }
            return charsetCandidate.subSequence(0, indexOfSemicolon);
        }
        return null;
    }

    public static CharSequence getMimeType(HttpMessage message) {
        CharSequence contentTypeValue = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue != null) {
            return HttpUtil.getMimeType(contentTypeValue);
        }
        return null;
    }

    public static CharSequence getMimeType(CharSequence contentTypeValue) {
        Objects.requireNonNull(contentTypeValue, "contentTypeValue");
        int indexOfSemicolon = AsciiString.indexOfIgnoreCaseAscii((CharSequence)contentTypeValue, (CharSequence)SEMICOLON, (int)0);
        if (indexOfSemicolon != -1) {
            return contentTypeValue.subSequence(0, indexOfSemicolon);
        }
        return contentTypeValue.length() > 0 ? contentTypeValue : null;
    }

    public static String formatHostnameForHttp(InetSocketAddress addr) {
        String hostString = NetUtil.getHostname((InetSocketAddress)addr);
        if (NetUtil.isValidIpV6Address((String)hostString)) {
            if (!addr.isUnresolved()) {
                hostString = NetUtil.toAddressString((InetAddress)addr.getAddress());
            }
            return "[" + hostString + "]";
        }
        return hostString;
    }

    @UnstableApi
    public static long normalizeAndGetContentLength(Iterator<CharSequence> contentLengthFields, boolean isHttp10OrEarlier, boolean allowDuplicateContentLengths) {
        boolean multipleContentLengths;
        if (!contentLengthFields.hasNext()) {
            return -1L;
        }
        String firstField = contentLengthFields.next().toString();
        boolean bl = multipleContentLengths = contentLengthFields.hasNext() || firstField.indexOf(44) >= 0;
        if (multipleContentLengths && !isHttp10OrEarlier) {
            if (allowDuplicateContentLengths) {
                String firstValue = null;
                CharSequence field = firstField;
                while (true) {
                    String[] tokens;
                    for (String token : tokens = field.toString().split(COMMA_STRING, -1)) {
                        String trimmed = token.trim();
                        if (firstValue == null) {
                            firstValue = trimmed;
                            continue;
                        }
                        if (trimmed.equals(firstValue)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + contentLengthFields);
                    }
                    if (!contentLengthFields.hasNext()) break;
                    field = contentLengthFields.next();
                }
                firstField = firstValue;
            } else {
                throw new IllegalArgumentException("Multiple Content-Length values found: " + contentLengthFields);
            }
        }
        if (firstField.isEmpty() || !Character.isDigit(firstField.charAt(0))) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + firstField);
        }
        try {
            long value = Long.parseLong(firstField);
            return ObjectUtil.checkPositiveOrZero((long)value, (String)"Content-Length value");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + firstField, e);
        }
    }
}

