/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.handler.codec.MessageAggregator;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.FullHttpMessage;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpExpectationFailedEvent;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpMessageUtil;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpStatusClass;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.TooLongHttpContentException;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.Send;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;

public class HttpObjectAggregator<C extends HttpContent<C>>
extends MessageAggregator<HttpObject, HttpMessage, HttpContent<C>, FullHttpMessage<?>> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpObjectAggregator.class);
    private final boolean closeOnExpectationFailed;

    public HttpObjectAggregator(int maxContentLength) {
        this(maxContentLength, false);
    }

    public HttpObjectAggregator(int maxContentLength, boolean closeOnExpectationFailed) {
        super(maxContentLength);
        this.closeOnExpectationFailed = closeOnExpectationFailed;
    }

    protected HttpMessage tryStartMessage(Object msg) {
        return msg instanceof HttpMessage ? (HttpMessage)msg : null;
    }

    protected HttpContent<C> tryContentMessage(Object msg) {
        return msg instanceof HttpContent ? (HttpContent)msg : null;
    }

    protected boolean isAggregated(Object msg) throws Exception {
        return msg instanceof FullHttpMessage;
    }

    protected int lengthForContent(HttpContent<C> msg) {
        return msg.payload().readableBytes();
    }

    protected int lengthForAggregation(FullHttpMessage<?> msg) {
        return msg.payload().readableBytes();
    }

    protected boolean isLastContentMessage(HttpContent<C> msg) throws Exception {
        return msg instanceof LastHttpContent;
    }

    protected boolean isContentLengthInvalid(HttpMessage start, int maxContentLength) {
        try {
            return HttpUtil.getContentLength(start, -1L) > (long)maxContentLength;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static FullHttpResponse continueResponse(HttpMessage start, int maxContentLength, ChannelPipeline pipeline) {
        if (HttpUtil.isUnsupportedExpectation(start)) {
            pipeline.fireChannelInboundEvent((Object)HttpExpectationFailedEvent.INSTANCE);
            return HttpObjectAggregator.newErrorResponse(HttpResponseStatus.EXPECTATION_FAILED, pipeline.channel().bufferAllocator(), true, false);
        }
        if (HttpUtil.is100ContinueExpected(start)) {
            if (HttpUtil.getContentLength(start, -1L) <= (long)maxContentLength) {
                return HttpObjectAggregator.newErrorResponse(HttpResponseStatus.CONTINUE, pipeline.channel().bufferAllocator(), false, false);
            }
            pipeline.fireChannelInboundEvent((Object)HttpExpectationFailedEvent.INSTANCE);
            return HttpObjectAggregator.newErrorResponse(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, pipeline.channel().bufferAllocator(), true, false);
        }
        return null;
    }

    protected Object newContinueResponse(HttpMessage start, int maxContentLength, ChannelPipeline pipeline) {
        FullHttpResponse response = HttpObjectAggregator.continueResponse(start, maxContentLength, pipeline);
        if (response != null) {
            start.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
        }
        return response;
    }

    protected boolean closeAfterContinueResponse(Object msg) {
        return this.closeOnExpectationFailed && this.ignoreContentAfterContinueResponse(msg);
    }

    protected boolean ignoreContentAfterContinueResponse(Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            return httpResponse.status().codeClass() == HttpStatusClass.CLIENT_ERROR;
        }
        return false;
    }

    protected FullHttpMessage<?> beginAggregation(BufferAllocator allocator, HttpMessage start) throws Exception {
        AggregatedFullHttpMessage ret;
        assert (!(start instanceof FullHttpMessage));
        HttpUtil.setTransferEncodingChunked(start, false);
        CompositeBuffer content = allocator.compose();
        if (start instanceof HttpRequest) {
            ret = new AggregatedFullHttpRequest((HttpRequest)start, (Buffer)content, null);
        } else if (start instanceof HttpResponse) {
            ret = new AggregatedFullHttpResponse((HttpResponse)start, (Buffer)content, null);
        } else {
            throw new Error();
        }
        return ret;
    }

    protected void aggregate(BufferAllocator allocator, FullHttpMessage<?> aggregated, HttpContent<C> content) throws Exception {
        CompositeBuffer payload = (CompositeBuffer)aggregated.payload();
        payload.extendWith(content.payload().send());
        if (content instanceof LastHttpContent) {
            ((AggregatedFullHttpMessage)aggregated).setTrailingHeaders(((LastHttpContent)content).trailingHeaders());
        }
    }

    protected void finishAggregation(BufferAllocator allocator, FullHttpMessage<?> aggregated) throws Exception {
        if (!HttpUtil.isContentLengthSet(aggregated)) {
            aggregated.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(aggregated.payload().readableBytes()));
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext ctx, Object oversized) throws Exception {
        if (oversized instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)oversized;
            if (oversized instanceof FullHttpMessage || !HttpUtil.is100ContinueExpected(request) && !HttpUtil.isKeepAlive(request)) {
                Future future2 = ctx.writeAndFlush((Object)HttpObjectAggregator.newErrorResponse(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, ctx.bufferAllocator(), true, true));
                future2.addListener(f -> {
                    if (f.isFailed()) {
                        logger.debug("Failed to send a 413 Request Entity Too Large.", f.cause());
                    }
                    ctx.close();
                });
            } else {
                ctx.writeAndFlush((Object)HttpObjectAggregator.newErrorResponse(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, ctx.bufferAllocator(), true, false)).addListener(future -> {
                    if (future.isFailed()) {
                        logger.debug("Failed to send a 413 Request Entity Too Large.", future.cause());
                        ctx.close();
                    }
                });
            }
        } else {
            if (oversized instanceof HttpResponse) {
                throw new ResponseTooLargeException("Response entity too large: " + oversized);
            }
            throw new IllegalStateException();
        }
    }

    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.channelExceptionCaught(ctx, cause);
        if (cause instanceof ResponseTooLargeException) {
            ctx.close();
        }
    }

    private static FullHttpResponse newErrorResponse(HttpResponseStatus status, BufferAllocator allocator, boolean emptyContent, boolean closeConnection) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, allocator.allocate(0));
        if (emptyContent) {
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)HttpHeaderValues.ZERO);
        }
        if (closeConnection) {
            resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE);
        }
        return resp;
    }

    private static final class AggregatedFullHttpResponse
    extends AggregatedFullHttpMessage<FullHttpResponse>
    implements FullHttpResponse {
        AggregatedFullHttpResponse(HttpResponse message, Buffer content, HttpHeaders trailingHeaders) {
            super(message, content, trailingHeaders);
        }

        public Send<FullHttpResponse> send() {
            return this.payload().send().map(FullHttpResponse.class, p -> new AggregatedFullHttpResponse(this, (Buffer)p, this.trailingHeaders()));
        }

        @Override
        public AggregatedFullHttpResponse copy() {
            return new AggregatedFullHttpResponse(this, this.payload().copy(), this.trailingHeaders().copy());
        }

        public FullHttpResponse touch(Object hint) {
            this.payload().touch(hint);
            return this;
        }

        @Override
        public FullHttpResponse setStatus(HttpResponseStatus status) {
            ((HttpResponse)this.message).setStatus(status);
            return this;
        }

        @Override
        public HttpResponseStatus status() {
            return ((HttpResponse)this.message).status();
        }

        @Override
        public FullHttpResponse setProtocolVersion(HttpVersion version) {
            super.setProtocolVersion(version);
            return this;
        }

        public String toString() {
            return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
        }
    }

    private static final class AggregatedFullHttpRequest
    extends AggregatedFullHttpMessage<FullHttpRequest>
    implements FullHttpRequest {
        AggregatedFullHttpRequest(HttpRequest request, Buffer content, HttpHeaders trailingHeaders) {
            super(request, content, trailingHeaders);
        }

        public Send<FullHttpRequest> send() {
            return this.payload().send().map(FullHttpRequest.class, p -> new AggregatedFullHttpRequest(this, (Buffer)p, this.trailingHeaders()));
        }

        @Override
        public AggregatedFullHttpRequest copy() {
            return new AggregatedFullHttpRequest(this, this.payload().copy(), this.trailingHeaders().copy());
        }

        public FullHttpRequest touch(Object hint) {
            this.payload().touch(hint);
            return this;
        }

        @Override
        public FullHttpRequest setMethod(HttpMethod method) {
            ((HttpRequest)this.message).setMethod(method);
            return this;
        }

        @Override
        public FullHttpRequest setUri(String uri) {
            ((HttpRequest)this.message).setUri(uri);
            return this;
        }

        @Override
        public HttpMethod method() {
            return ((HttpRequest)this.message).method();
        }

        @Override
        public String uri() {
            return ((HttpRequest)this.message).uri();
        }

        @Override
        public FullHttpRequest setProtocolVersion(HttpVersion version) {
            super.setProtocolVersion(version);
            return this;
        }

        public String toString() {
            return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
        }
    }

    private static abstract class AggregatedFullHttpMessage<R extends FullHttpMessage<R>>
    implements FullHttpMessage<R> {
        protected final HttpMessage message;
        private final Buffer payload;
        private HttpHeaders trailingHeaders;

        AggregatedFullHttpMessage(HttpMessage message, Buffer payload, HttpHeaders trailingHeaders) {
            this.message = message;
            this.payload = payload;
            this.trailingHeaders = trailingHeaders;
        }

        public void close() {
            this.payload.close();
        }

        public boolean isAccessible() {
            return this.payload.isAccessible();
        }

        @Override
        public Buffer payload() {
            return this.payload;
        }

        @Override
        public HttpHeaders trailingHeaders() {
            HttpHeaders trailingHeaders = this.trailingHeaders;
            return Objects.requireNonNullElse(trailingHeaders, HttpHeaders.emptyHeaders());
        }

        void setTrailingHeaders(HttpHeaders trailingHeaders) {
            this.trailingHeaders = trailingHeaders;
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.message.protocolVersion();
        }

        @Override
        public HttpVersion protocolVersion() {
            return this.message.protocolVersion();
        }

        @Override
        public FullHttpMessage<R> setProtocolVersion(HttpVersion version) {
            this.message.setProtocolVersion(version);
            return this;
        }

        @Override
        public HttpHeaders headers() {
            return this.message.headers();
        }

        public DecoderResult decoderResult() {
            return this.message.decoderResult();
        }

        public void setDecoderResult(DecoderResult result) {
            this.message.setDecoderResult(result);
        }
    }

    private static final class ResponseTooLargeException
    extends TooLongHttpContentException {
        private static final long serialVersionUID = 1922084473597224689L;

        ResponseTooLargeException(String message) {
            super(message);
        }
    }
}

